/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.LittleEndianOutput;

public final class DeltaRecord
extends StandardRecord {
    public static final short sid = 16;
    public static final double DEFAULT_VALUE = 0.001;
    private double field_1_max_change;

    public DeltaRecord(double d) {
        this.field_1_max_change = d;
    }

    public DeltaRecord(RecordInputStream recordInputStream) {
        this.field_1_max_change = recordInputStream.readDouble();
    }

    public double getMaxChange() {
        return this.field_1_max_change;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[DELTA]\n");
        stringBuffer.append("    .maxchange = ").append(this.getMaxChange()).append("\n");
        stringBuffer.append("[/DELTA]\n");
        return stringBuffer.toString();
    }

    @Override
    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeDouble(this.getMaxChange());
    }

    @Override
    protected int getDataSize() {
        return 8;
    }

    @Override
    public short getSid() {
        return 16;
    }

    @Override
    public Object clone() {
        return this;
    }
}

