/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.geographic;

import java.io.IOException;
import java.io.InputStream;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.plugins.opendata.core.io.AbstractImporter;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.MifReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.TabReader;
import org.openstreetmap.josm.tools.I18n;

public class MifTabImporter
extends AbstractImporter {
    public static final ExtensionFileFilter MIF_TAB_FILE_FILTER = new ExtensionFileFilter("mif,tab", "mif", I18n.tr((String)"MapInfo files", (Object[])new Object[0]) + " (*." + "mif" + ",*." + "tab" + ")");

    public MifTabImporter() {
        super(MIF_TAB_FILE_FILTER);
    }

    protected DataSet parseDataSet(InputStream in, ProgressMonitor instance) throws IllegalDataException {
        try {
            if (this.file.getName().toLowerCase().endsWith("mif")) {
                return MifReader.parseDataSet(in, this.file, this.handler, instance);
            }
            return TabReader.parseDataSet(in, this.file, this.handler, instance);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new IllegalDataException((Throwable)e);
        }
    }
}

