/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.hssf.record.constant.ConstantValueParser;
import org.apache.poi.ss.formula.Formula;
import org.apache.poi.util.LittleEndianOutput;
import org.apache.poi.util.StringUtil;

public final class ExternalNameRecord
extends StandardRecord {
    public static final short sid = 35;
    private static final int OPT_AUTOMATIC_LINK = 2;
    private static final int OPT_STD_DOCUMENT_NAME = 8;
    private static final int OPT_OLE_LINK = 16;
    private short field_1_option_flag;
    private short field_2_ixals;
    private short field_3_not_used;
    private String field_4_name;
    private Formula field_5_name_definition;
    private Object[] _ddeValues;
    private int _nColumns;
    private int _nRows;

    public boolean isAutomaticLink() {
        return (this.field_1_option_flag & 2) != 0;
    }

    public boolean isStdDocumentNameIdentifier() {
        return (this.field_1_option_flag & 8) != 0;
    }

    public boolean isOLELink() {
        return (this.field_1_option_flag & 0x10) != 0;
    }

    public String getText() {
        return this.field_4_name;
    }

    @Override
    protected int getDataSize() {
        int n = 6;
        n += StringUtil.getEncodedSize(this.field_4_name) - 1;
        if (!this.isOLELink() && !this.isStdDocumentNameIdentifier()) {
            if (this.isAutomaticLink()) {
                n += 3;
                n += ConstantValueParser.getEncodedSize(this._ddeValues);
            } else {
                n += this.field_5_name_definition.getEncodedSize();
            }
        }
        return n;
    }

    @Override
    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.field_1_option_flag);
        littleEndianOutput.writeShort(this.field_2_ixals);
        littleEndianOutput.writeShort(this.field_3_not_used);
        littleEndianOutput.writeByte(this.field_4_name.length());
        StringUtil.writeUnicodeStringFlagAndData(littleEndianOutput, this.field_4_name);
        if (!this.isOLELink() && !this.isStdDocumentNameIdentifier()) {
            if (this.isAutomaticLink()) {
                littleEndianOutput.writeByte(this._nColumns - 1);
                littleEndianOutput.writeShort(this._nRows - 1);
                ConstantValueParser.encode(littleEndianOutput, this._ddeValues);
            } else {
                this.field_5_name_definition.serialize(littleEndianOutput);
            }
        }
    }

    public ExternalNameRecord(RecordInputStream recordInputStream) {
        this.field_1_option_flag = recordInputStream.readShort();
        this.field_2_ixals = recordInputStream.readShort();
        this.field_3_not_used = recordInputStream.readShort();
        int n = recordInputStream.readUByte();
        this.field_4_name = StringUtil.readUnicodeString(recordInputStream, n);
        if (!this.isOLELink() && !this.isStdDocumentNameIdentifier()) {
            if (this.isAutomaticLink()) {
                int n2 = recordInputStream.readUByte() + 1;
                int n3 = recordInputStream.readShort() + 1;
                int n4 = n3 * n2;
                this._ddeValues = ConstantValueParser.parse(recordInputStream, n4);
                this._nColumns = n2;
                this._nRows = n3;
            } else {
                int n5 = recordInputStream.readUShort();
                this.field_5_name_definition = Formula.read(n5, recordInputStream);
            }
        }
    }

    @Override
    public short getSid() {
        return 35;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[EXTERNALNAME]\n");
        stringBuffer.append("    .ix      = ").append(this.field_2_ixals).append("\n");
        stringBuffer.append("    .name    = ").append(this.field_4_name).append("\n");
        if (this.field_5_name_definition != null) {
            stringBuffer.append("    .formula = ").append(this.field_5_name_definition).append("\n");
        }
        stringBuffer.append("[/EXTERNALNAME]\n");
        return stringBuffer.toString();
    }
}

