/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.util;

import org.apache.poi.ss.util.CellRangeAddressBase;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianOutput;

public final class CellRangeAddress8Bit
extends CellRangeAddressBase {
    public static final int ENCODED_SIZE = 6;

    public CellRangeAddress8Bit(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    public CellRangeAddress8Bit(LittleEndianInput littleEndianInput) {
        super(CellRangeAddress8Bit.readUShortAndCheck(littleEndianInput), littleEndianInput.readUShort(), littleEndianInput.readUByte(), littleEndianInput.readUByte());
    }

    private static int readUShortAndCheck(LittleEndianInput littleEndianInput) {
        if (littleEndianInput.available() < 6) {
            throw new RuntimeException("Ran out of data reading CellRangeAddress");
        }
        return littleEndianInput.readUShort();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.getFirstRow());
        littleEndianOutput.writeShort(this.getLastRow());
        littleEndianOutput.writeByte(this.getFirstColumn());
        littleEndianOutput.writeByte(this.getLastColumn());
    }

    public static int getEncodedSize(int n) {
        return n * 6;
    }
}

