/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.HexRead;
import org.apache.poi.util.LittleEndianByteArrayInputStream;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianOutput;
import org.apache.poi.util.StringUtil;

public final class HyperlinkRecord
extends StandardRecord {
    public static final short sid = 440;
    static final int HLINK_URL = 1;
    static final int HLINK_LABEL = 20;
    static final int HLINK_PLACE = 8;
    private static final int HLINK_TARGET_FRAME = 128;
    private static final int HLINK_UNC_PATH = 256;
    static final GUID STD_MONIKER = GUID.parse("79EAC9D0-BAF9-11CE-8C82-00AA004BA90B");
    static final GUID URL_MONIKER = GUID.parse("79EAC9E0-BAF9-11CE-8C82-00AA004BA90B");
    static final GUID FILE_MONIKER = GUID.parse("00000303-0000-0000-C000-000000000046");
    private static final byte[] URL_TAIL = HexRead.readFromString("79 58 81 F4  3B 1D 7F 48   AF 2C 82 5D  C4 85 27 63   00 00 00 00  A5 AB 00 00");
    private static final byte[] FILE_TAIL = HexRead.readFromString("FF FF AD DE  00 00 00 00   00 00 00 00  00 00 00 00   00 00 00 00  00 00 00 00");
    private static final int TAIL_SIZE = FILE_TAIL.length;
    private CellRangeAddress _range;
    private GUID _guid;
    private int _fileOpts;
    private int _linkOpts;
    private String _label;
    private String _targetFrame;
    private GUID _moniker;
    private String _shortFilename;
    private String _address;
    private String _textMark;
    private byte[] _uninterpretedTail;

    public HyperlinkRecord() {
    }

    private static String cleanString(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(0);
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    public String getLabel() {
        return HyperlinkRecord.cleanString(this._label);
    }

    public String getTargetFrame() {
        return HyperlinkRecord.cleanString(this._targetFrame);
    }

    public String getAddress() {
        if ((this._linkOpts & 1) != 0 && FILE_MONIKER.equals(this._moniker)) {
            return HyperlinkRecord.cleanString(this._address != null ? this._address : this._shortFilename);
        }
        if ((this._linkOpts & 8) != 0) {
            return HyperlinkRecord.cleanString(this._textMark);
        }
        return HyperlinkRecord.cleanString(this._address);
    }

    public String getTextMark() {
        return HyperlinkRecord.cleanString(this._textMark);
    }

    public HyperlinkRecord(RecordInputStream recordInputStream) {
        int n;
        this._range = new CellRangeAddress(recordInputStream);
        this._guid = new GUID(recordInputStream);
        int n2 = recordInputStream.readInt();
        if (n2 != 2) {
            throw new RecordFormatException("Stream Version must be 0x2 but found " + n2);
        }
        this._linkOpts = recordInputStream.readInt();
        if ((this._linkOpts & 0x14) != 0) {
            n = recordInputStream.readInt();
            this._label = recordInputStream.readUnicodeLEString(n);
        }
        if ((this._linkOpts & 0x80) != 0) {
            n = recordInputStream.readInt();
            this._targetFrame = recordInputStream.readUnicodeLEString(n);
        }
        if ((this._linkOpts & 1) != 0 && (this._linkOpts & 0x100) != 0) {
            this._moniker = null;
            n = recordInputStream.readInt();
            this._address = recordInputStream.readUnicodeLEString(n);
        }
        if ((this._linkOpts & 1) != 0 && (this._linkOpts & 0x100) == 0) {
            this._moniker = new GUID(recordInputStream);
            if (URL_MONIKER.equals(this._moniker)) {
                int n3;
                n = recordInputStream.readInt();
                if (n == (n3 = recordInputStream.remaining())) {
                    int n4 = n / 2;
                    this._address = recordInputStream.readUnicodeLEString(n4);
                } else {
                    int n5 = (n - TAIL_SIZE) / 2;
                    this._address = recordInputStream.readUnicodeLEString(n5);
                    this._uninterpretedTail = HyperlinkRecord.readTail(URL_TAIL, recordInputStream);
                }
            } else if (FILE_MONIKER.equals(this._moniker)) {
                this._fileOpts = recordInputStream.readShort();
                n = recordInputStream.readInt();
                this._shortFilename = StringUtil.readCompressedUnicode(recordInputStream, n);
                this._uninterpretedTail = HyperlinkRecord.readTail(FILE_TAIL, recordInputStream);
                int n6 = recordInputStream.readInt();
                if (n6 > 0) {
                    int n7 = recordInputStream.readInt();
                    int n8 = recordInputStream.readUShort();
                    if (n8 != 3) {
                        throw new RecordFormatException("Expected 0x3 but found " + n8);
                    }
                    this._address = StringUtil.readUnicodeLE(recordInputStream, n7 / 2);
                } else {
                    this._address = null;
                }
            } else if (STD_MONIKER.equals(this._moniker)) {
                this._fileOpts = recordInputStream.readShort();
                n = recordInputStream.readInt();
                byte[] byArray = new byte[n];
                recordInputStream.readFully(byArray);
                this._address = new String(byArray);
            }
        }
        if ((this._linkOpts & 8) != 0) {
            n = recordInputStream.readInt();
            this._textMark = recordInputStream.readUnicodeLEString(n);
        }
        if (recordInputStream.remaining() > 0) {
            System.out.println(HexDump.toHex(recordInputStream.readRemainder()));
        }
    }

    @Override
    public void serialize(LittleEndianOutput littleEndianOutput) {
        this._range.serialize(littleEndianOutput);
        this._guid.serialize(littleEndianOutput);
        littleEndianOutput.writeInt(2);
        littleEndianOutput.writeInt(this._linkOpts);
        if ((this._linkOpts & 0x14) != 0) {
            littleEndianOutput.writeInt(this._label.length());
            StringUtil.putUnicodeLE(this._label, littleEndianOutput);
        }
        if ((this._linkOpts & 0x80) != 0) {
            littleEndianOutput.writeInt(this._targetFrame.length());
            StringUtil.putUnicodeLE(this._targetFrame, littleEndianOutput);
        }
        if ((this._linkOpts & 1) != 0 && (this._linkOpts & 0x100) != 0) {
            littleEndianOutput.writeInt(this._address.length());
            StringUtil.putUnicodeLE(this._address, littleEndianOutput);
        }
        if ((this._linkOpts & 1) != 0 && (this._linkOpts & 0x100) == 0) {
            this._moniker.serialize(littleEndianOutput);
            if (URL_MONIKER.equals(this._moniker)) {
                if (this._uninterpretedTail == null) {
                    littleEndianOutput.writeInt(this._address.length() * 2);
                    StringUtil.putUnicodeLE(this._address, littleEndianOutput);
                } else {
                    littleEndianOutput.writeInt(this._address.length() * 2 + TAIL_SIZE);
                    StringUtil.putUnicodeLE(this._address, littleEndianOutput);
                    HyperlinkRecord.writeTail(this._uninterpretedTail, littleEndianOutput);
                }
            } else if (FILE_MONIKER.equals(this._moniker)) {
                littleEndianOutput.writeShort(this._fileOpts);
                littleEndianOutput.writeInt(this._shortFilename.length());
                StringUtil.putCompressedUnicode(this._shortFilename, littleEndianOutput);
                HyperlinkRecord.writeTail(this._uninterpretedTail, littleEndianOutput);
                if (this._address == null) {
                    littleEndianOutput.writeInt(0);
                } else {
                    int n = this._address.length() * 2;
                    littleEndianOutput.writeInt(n + 6);
                    littleEndianOutput.writeInt(n);
                    littleEndianOutput.writeShort(3);
                    StringUtil.putUnicodeLE(this._address, littleEndianOutput);
                }
            }
        }
        if ((this._linkOpts & 8) != 0) {
            littleEndianOutput.writeInt(this._textMark.length());
            StringUtil.putUnicodeLE(this._textMark, littleEndianOutput);
        }
    }

    @Override
    protected int getDataSize() {
        int n = 0;
        n += 8;
        n += 16;
        n += 4;
        n += 4;
        if ((this._linkOpts & 0x14) != 0) {
            n += 4;
            n += this._label.length() * 2;
        }
        if ((this._linkOpts & 0x80) != 0) {
            n += 4;
            n += this._targetFrame.length() * 2;
        }
        if ((this._linkOpts & 1) != 0 && (this._linkOpts & 0x100) != 0) {
            n += 4;
            n += this._address.length() * 2;
        }
        if ((this._linkOpts & 1) != 0 && (this._linkOpts & 0x100) == 0) {
            n += 16;
            if (URL_MONIKER.equals(this._moniker)) {
                n += 4;
                n += this._address.length() * 2;
                if (this._uninterpretedTail != null) {
                    n += TAIL_SIZE;
                }
            } else if (FILE_MONIKER.equals(this._moniker)) {
                n += 2;
                n += 4;
                n += this._shortFilename.length();
                n += TAIL_SIZE;
                n += 4;
                if (this._address != null) {
                    n += 6;
                    n += this._address.length() * 2;
                }
            }
        }
        if ((this._linkOpts & 8) != 0) {
            n += 4;
            n += this._textMark.length() * 2;
        }
        return n;
    }

    private static byte[] readTail(byte[] byArray, LittleEndianInput littleEndianInput) {
        byte[] byArray2 = new byte[TAIL_SIZE];
        littleEndianInput.readFully(byArray2);
        return byArray2;
    }

    private static void writeTail(byte[] byArray, LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.write(byArray);
    }

    @Override
    public short getSid() {
        return 440;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[HYPERLINK RECORD]\n");
        stringBuffer.append("    .range   = ").append(this._range.formatAsString()).append("\n");
        stringBuffer.append("    .guid    = ").append(this._guid.formatAsString()).append("\n");
        stringBuffer.append("    .linkOpts= ").append(HexDump.intToHex(this._linkOpts)).append("\n");
        stringBuffer.append("    .label   = ").append(this.getLabel()).append("\n");
        if ((this._linkOpts & 0x80) != 0) {
            stringBuffer.append("    .targetFrame= ").append(this.getTargetFrame()).append("\n");
        }
        if ((this._linkOpts & 1) != 0 && this._moniker != null) {
            stringBuffer.append("    .moniker   = ").append(this._moniker.formatAsString()).append("\n");
        }
        if ((this._linkOpts & 8) != 0) {
            stringBuffer.append("    .textMark= ").append(this.getTextMark()).append("\n");
        }
        stringBuffer.append("    .address   = ").append(this.getAddress()).append("\n");
        stringBuffer.append("[/HYPERLINK RECORD]\n");
        return stringBuffer.toString();
    }

    @Override
    public Object clone() {
        HyperlinkRecord hyperlinkRecord = new HyperlinkRecord();
        hyperlinkRecord._range = this._range.copy();
        hyperlinkRecord._guid = this._guid;
        hyperlinkRecord._linkOpts = this._linkOpts;
        hyperlinkRecord._fileOpts = this._fileOpts;
        hyperlinkRecord._label = this._label;
        hyperlinkRecord._address = this._address;
        hyperlinkRecord._moniker = this._moniker;
        hyperlinkRecord._shortFilename = this._shortFilename;
        hyperlinkRecord._targetFrame = this._targetFrame;
        hyperlinkRecord._textMark = this._textMark;
        hyperlinkRecord._uninterpretedTail = this._uninterpretedTail;
        return hyperlinkRecord;
    }

    static final class GUID {
        private static final int TEXT_FORMAT_LENGTH = 36;
        public static final int ENCODED_SIZE = 16;
        private final int _d1;
        private final int _d2;
        private final int _d3;
        private final long _d4;

        public GUID(LittleEndianInput littleEndianInput) {
            this(littleEndianInput.readInt(), littleEndianInput.readUShort(), littleEndianInput.readUShort(), littleEndianInput.readLong());
        }

        public GUID(int n, int n2, int n3, long l) {
            this._d1 = n;
            this._d2 = n2;
            this._d3 = n3;
            this._d4 = l;
        }

        public void serialize(LittleEndianOutput littleEndianOutput) {
            littleEndianOutput.writeInt(this._d1);
            littleEndianOutput.writeShort(this._d2);
            littleEndianOutput.writeShort(this._d3);
            littleEndianOutput.writeLong(this._d4);
        }

        public boolean equals(Object object) {
            GUID gUID = (GUID)object;
            if (object == null || !(object instanceof GUID)) {
                return false;
            }
            return this._d1 == gUID._d1 && this._d2 == gUID._d2 && this._d3 == gUID._d3 && this._d4 == gUID._d4;
        }

        public long getD4() {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8);
            try {
                new DataOutputStream(byteArrayOutputStream).writeLong(this._d4);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return new LittleEndianByteArrayInputStream(byArray).readLong();
        }

        public String formatAsString() {
            StringBuilder stringBuilder = new StringBuilder(36);
            int n = "0x".length();
            stringBuilder.append(HexDump.intToHex(this._d1), n, 8);
            stringBuilder.append("-");
            stringBuilder.append(HexDump.shortToHex(this._d2), n, 4);
            stringBuilder.append("-");
            stringBuilder.append(HexDump.shortToHex(this._d3), n, 4);
            stringBuilder.append("-");
            char[] cArray = HexDump.longToHex(this.getD4());
            stringBuilder.append(cArray, n, 4);
            stringBuilder.append("-");
            stringBuilder.append(cArray, n + 4, 12);
            return stringBuilder.toString();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(64);
            stringBuilder.append(this.getClass().getName()).append(" [");
            stringBuilder.append(this.formatAsString());
            stringBuilder.append("]");
            return stringBuilder.toString();
        }

        public static GUID parse(String string) {
            char[] cArray = string.toCharArray();
            if (cArray.length != 36) {
                throw new RecordFormatException("supplied text is the wrong length for a GUID");
            }
            int n = (GUID.parseShort(cArray, 0) << 16) + (GUID.parseShort(cArray, 4) << 0);
            int n2 = GUID.parseShort(cArray, 9);
            int n3 = GUID.parseShort(cArray, 14);
            for (int i = 23; i > 19; --i) {
                cArray[i] = cArray[i - 1];
            }
            long l = GUID.parseLELong(cArray, 20);
            return new GUID(n, n2, n3, l);
        }

        private static long parseLELong(char[] cArray, int n) {
            long l = 0L;
            for (int i = n + 14; i >= n; i -= 2) {
                l <<= 4;
                l += (long)GUID.parseHexChar(cArray[i + 0]);
                l <<= 4;
                l += (long)GUID.parseHexChar(cArray[i + 1]);
            }
            return l;
        }

        private static int parseShort(char[] cArray, int n) {
            int n2 = 0;
            for (int i = 0; i < 4; ++i) {
                n2 <<= 4;
                n2 += GUID.parseHexChar(cArray[n + i]);
            }
            return n2;
        }

        private static int parseHexChar(char c) {
            if (c >= '0' && c <= '9') {
                return c - 48;
            }
            if (c >= 'A' && c <= 'F') {
                return c - 65 + 10;
            }
            if (c >= 'a' && c <= 'f') {
                return c - 97 + 10;
            }
            throw new RecordFormatException("Bad hex char '" + c + "'");
        }
    }
}

