/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.tagging.ac.AutoCompletionItem;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingComboBox;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.wikipedia.WikipediaApp;
import org.wikipedia.data.WikidataEntry;
import org.wikipedia.gui.WikiSearchTextResultListPanel;
import org.wikipedia.gui.WikipediaToggleDialog;

public final class WikidataItemSearchDialog
extends ExtendedDialog {
    private final Selector selector = new Selector();
    private final AutoCompletingComboBox targetKey;
    private static final WikidataItemSearchDialog INSTANCE = new WikidataItemSearchDialog();

    private WikidataItemSearchDialog() {
        super(Main.parent, I18n.tr((String)"Search Wikidata items", (Object[])new Object[0]), new String[]{I18n.tr((String)"Add Tag", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])});
        this.selector.setDblClickListener(e -> this.buttonAction(0, null));
        this.targetKey = new AutoCompletingComboBox();
        this.targetKey.setEditable(true);
        this.targetKey.setSelectedItem((Object)new AutoCompletionItem("wikidata"));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)((Object)this.selector), GBC.eop().fill(1));
        panel.add(new JLabel(I18n.tr((String)"Target key: ", (Object[])new Object[0])));
        panel.add((Component)this.targetKey, GBC.eol().fill(2));
        this.setContent(panel, false);
        this.setPreferredSize(new Dimension(600, 300));
    }

    public static synchronized WikidataItemSearchDialog getInstance() {
        return INSTANCE;
    }

    public ExtendedDialog showDialog() {
        this.initTargetKeys();
        this.selector.init();
        super.showDialog();
        this.selector.clearSelection();
        this.selector.requestFocus();
        return this;
    }

    private void initTargetKeys() {
        DataSet editDataSet = MainApplication.getLayerManager().getEditDataSet();
        if (editDataSet == null) {
            return;
        }
        TreeSet<AutoCompletionItem> keys = new TreeSet<AutoCompletionItem>();
        keys.add(new AutoCompletionItem("wikidata"));
        keys.add(new AutoCompletionItem("operator:wikidata"));
        keys.add(new AutoCompletionItem("brand:wikidata"));
        keys.add(new AutoCompletionItem("architect:wikidata"));
        keys.add(new AutoCompletionItem("artist:wikidata"));
        keys.add(new AutoCompletionItem("subject:wikidata"));
        keys.add(new AutoCompletionItem("name:etymology:wikidata"));
        AutoCompletionManager.of((DataSet)editDataSet).getTagKeys().stream().filter(v -> v.getValue().contains("wikidata")).forEach(keys::add);
        this.targetKey.setPossibleAcItems(keys);
    }

    protected void buttonAction(int buttonIndex, ActionEvent evt) {
        super.buttonAction(buttonIndex, evt);
        if (buttonIndex != 0) {
            return;
        }
        WikidataEntry selected = (WikidataEntry)this.selector.getSelectedItem();
        if (selected == null) {
            return;
        }
        String key = Utils.removeWhiteSpaces((String)this.targetKey.getEditor().getItem().toString());
        String value = selected.createWikipediaTag().getValue();
        WikipediaToggleDialog.AddWikipediaTagAction.addTag(new Tag(key, value));
    }

    public static class Action
    extends JosmAction {
        public Action() {
            super(I18n.tr((String)"Search Wikidata items", (Object[])new Object[0]), "dialogs/wikidata", null, null, true, "dialogs/search-wikidata-items", false);
        }

        public void actionPerformed(ActionEvent e) {
            WikidataItemSearchDialog.getInstance().showDialog();
        }
    }

    private static class Selector
    extends WikiSearchTextResultListPanel<WikidataEntry> {
        Selector() {
            this.lsResult.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    WikidataEntry entry = (WikidataEntry)value;
                    String labelText = "<html>" + entry.getLabelText();
                    return super.getListCellRendererComponent(list, labelText, index, isSelected, cellHasFocus);
                }
            });
        }

        protected void filterItems() {
            String query = this.edSearchText.getText();
            this.debouncer.debounce(((Object)((Object)this)).getClass(), () -> {
                List entries = query == null || query.isEmpty() ? Collections.emptyList() : WikipediaApp.getWikidataEntriesForQuery(WikipediaToggleDialog.wikipediaLang.get(), query, Locale.getDefault());
                GuiHelper.runInEDT(() -> this.lsResultModel.setItems(entries));
            }, 200L, TimeUnit.MILLISECONDS);
        }
    }
}

