/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.shared.AlreadyReifiedException;
import com.hp.hpl.jena.shared.CannotReifyException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class ReifierStd {
    private static final Node rdfType = RDF.Nodes.type;
    private static final Node statement = RDF.Nodes.Statement;
    private static final Node subject = RDF.Nodes.subject;
    private static final Node predicate = RDF.Nodes.predicate;
    private static final Node object = RDF.Nodes.object;
    static Filter<Triple> filterReif = new Filter<Triple>(){

        @Override
        public boolean accept(Triple triple) {
            return triple.getPredicate().equals(subject) || triple.getPredicate().equals(predicate) || triple.getPredicate().equals(object) || triple.getPredicate().equals(rdfType) && triple.getObject().equals(statement);
        }
    };

    private ReifierStd() {
    }

    public static ExtendedIterator<Triple> findEither(Graph graph, TripleMatch match, boolean showHidden) {
        if (showHidden) {
            return NullIterator.instance();
        }
        return graph.find(match);
    }

    public static ExtendedIterator<Triple> findExposed(Graph graph, TripleMatch match) {
        ExtendedIterator<Triple> it = graph.find(match);
        it = it.filterKeep(filterReif);
        return WrappedIterator.create(it);
    }

    public static Triple getTriple(Graph graph, Node n) {
        if (!graph.contains(n, rdfType, statement)) {
            return null;
        }
        Node s = ReifierStd.getObject(graph, n, subject);
        if (s == null) {
            return null;
        }
        Node p = ReifierStd.getObject(graph, n, predicate);
        if (p == null) {
            return null;
        }
        Node o = ReifierStd.getObject(graph, n, object);
        if (o == null) {
            return null;
        }
        return new Triple(s, p, o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Node getObject(Graph graph, Node n, Node predicate) {
        try (ExtendedIterator<Triple> iter = graph.find(n, predicate, Node.ANY);){
            if (!iter.hasNext()) {
                Node node = null;
                return node;
            }
            Triple t = (Triple)iter.next();
            if (iter.hasNext()) {
                Node node = null;
                return node;
            }
            Node node = t.getObject();
            return node;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasTriple(Graph graph, Triple t) {
        try (ExtendedIterator<Node> iter = ReifierStd.findNodesForTriple(graph, t, false);){
            boolean bl = iter.hasNext();
            return bl;
        }
    }

    public static boolean hasTriple(Graph graph, Node node) {
        return ReifierStd.getTriple(graph, node) != null;
    }

    public static ExtendedIterator<Node> allNodes(Graph graph) {
        return ReifierStd.allNodes(graph, null);
    }

    public static ExtendedIterator<Node> allNodes(Graph graph, Triple t) {
        return ReifierStd.findNodesForTriple(graph, t, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ExtendedIterator<Node> findNodesForTriple(Graph graph, Triple t, boolean oneWillDo) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        try (ExtendedIterator<Triple> iter = graph.find(Node.ANY, rdfType, statement);){
            while (iter.hasNext()) {
                Triple typeTriple = (Triple)iter.next();
                Node n = typeTriple.getSubject();
                if (t != null && (!ReifierStd.exactlyOne(graph, n, subject, t.getSubject()) || !ReifierStd.exactlyOne(graph, n, predicate, t.getPredicate()) || !ReifierStd.exactlyOne(graph, n, object, t.getObject()))) continue;
                nodes.add(n);
                if (!oneWillDo) continue;
                break;
            }
        }
        return WrappedIterator.createNoRemove(nodes.iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean exactlyOne(Graph graph, Node n, Node predicate, Node object) {
        try (ExtendedIterator<Triple> iter = graph.find(n, predicate, Node.ANY);){
            if (!iter.hasNext()) {
                boolean bl = false;
                return bl;
            }
            while (iter.hasNext()) {
                Node obj = ((Triple)iter.next()).getObject();
                if (obj.equals(object)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    public static Node reifyAs(Graph graph, Node node, Triple triple) {
        if (node == null) {
            node = NodeFactory.createAnon();
        } else {
            Triple t = ReifierStd.getTriple(graph, node);
            if (t != null && !t.equals(triple)) {
                throw new AlreadyReifiedException(node);
            }
            if (t != null) {
                return node;
            }
            if (graph.contains(node, subject, Node.ANY)) {
                throw new CannotReifyException(node);
            }
            if (graph.contains(node, predicate, Node.ANY)) {
                throw new CannotReifyException(node);
            }
            if (graph.contains(node, object, Node.ANY)) {
                throw new CannotReifyException(node);
            }
        }
        graph.add(new Triple(node, rdfType, statement));
        graph.add(new Triple(node, subject, triple.getSubject()));
        graph.add(new Triple(node, predicate, triple.getPredicate()));
        graph.add(new Triple(node, object, triple.getObject()));
        return node;
    }

    public static void remove(Graph graph, Triple triple) {
        for (Node n : ReifierStd.allNodes(graph, triple).toList()) {
            ReifierStd.remove(graph, n, triple);
        }
    }

    public static void remove(Graph graph, Node node, Triple triple) {
        HashSet<Triple> triples = new HashSet<Triple>();
        ReifierStd.triplesToZap(graph, triples, node, rdfType, statement);
        ReifierStd.triplesToZap(graph, triples, node, subject, triple.getSubject());
        ReifierStd.triplesToZap(graph, triples, node, predicate, triple.getPredicate());
        ReifierStd.triplesToZap(graph, triples, node, object, triple.getObject());
        for (Triple t : triples) {
            graph.delete(t);
        }
    }

    private static void triplesToZap(Graph graph, Collection<Triple> acc, Node s, Node p, Node o) {
        ExtendedIterator<Triple> iter = graph.find(s, p, o);
        while (iter.hasNext()) {
            acc.add((Triple)iter.next());
        }
    }
}

