/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.stats;

import it.geosolutions.jaiext.stats.Statistics;

public class Extrema
extends Statistics {
    private double max = Double.NEGATIVE_INFINITY;
    private double min = Double.POSITIVE_INFINITY;

    Extrema() {
        this.type = Statistics.StatsType.EXTREMA;
    }

    private double getMax() {
        return this.max;
    }

    private double getMin() {
        return this.min;
    }

    public void addSample(double sample) {
        if (sample > this.max) {
            this.max = sample;
        }
        if (sample < this.min) {
            this.min = sample;
        }
        ++this.samples;
    }

    protected void accumulateStats(Statistics stats) {
        this.checkSameStats(stats);
        Extrema exStats = (Extrema)stats;
        double maxNew = exStats.getMax();
        double minNew = exStats.getMin();
        if (maxNew > this.max) {
            this.max = maxNew;
        }
        if (minNew < this.min) {
            this.min = minNew;
        }
        this.samples += stats.getNumSamples().longValue();
    }

    public Object getResult() {
        double[] extrema = new double[]{this.min, this.max};
        return extrema;
    }

    public Long getNumSamples() {
        return this.samples;
    }

    protected void clearStats() {
        this.max = Double.NEGATIVE_INFINITY;
        this.min = Double.POSITIVE_INFINITY;
    }
}

