/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tofix;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.json.JsonObject;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.plugins.tofix.oauth.OAuthClient;
import org.openstreetmap.josm.plugins.tofix.oauth.OAuthToken;
import org.openstreetmap.josm.plugins.tofix.oauth.SessionId;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class JDOAuth
extends JDialog {
    private static final long serialVersionUID = 1L;
    private SessionId sessionId;
    private OAuthToken requestToken;
    private String osmOAuthToken = null;
    private String tofixToken = null;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPasswordField jPasswordField1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTabbedPane jTabbedPane1;
    private JTextArea jTextArea1;
    private JTextField jTextField1;

    public JDOAuth(Component parent) {
        super((Window)GuiHelper.getFrameForComponent((Component)parent), I18n.tr((String)"OAuth", (Object[])new Object[0]), Dialog.ModalityType.DOCUMENT_MODAL);
        this.initComponents();
        this.setLocationRelativeTo(parent);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jPasswordField1 = new JPasswordField();
        this.jSeparator1 = new JSeparator();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("OAuth ");
        this.setResizable(false);
        this.jLabel1.setFont(new Font("DejaVu Sans", 0, 24));
        this.jLabel1.setText("Tofix");
        this.jTabbedPane1.setEnabled(false);
        this.jButton1.setText("Autorize now");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDOAuth.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Username:");
        this.jLabel3.setText("Password:");
        this.jTextField1.setEditable(false);
        this.jPasswordField1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDOAuth.this.jPasswordField1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField1).addComponent(this.jPasswordField1))).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 219, Short.MAX_VALUE).addComponent(this.jButton1))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextField1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jPasswordField1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Basic", this.jPanel1);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jButton2.setText("Generate New Access Token");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDOAuth.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton3.setText("Ok");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDOAuth.this.jButton3ActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 326, Short.MAX_VALUE).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton3))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 76, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton2).addComponent(this.jButton3)).addContainerGap()));
        this.jTabbedPane1.addTab("Tokens", this.jPanel2);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jTabbedPane1)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTabbedPane1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.autenticationOSM();
    }

    private void jPasswordField1ActionPerformed(ActionEvent evt) {
        this.jButton1.doClick();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.jPasswordField1.setText("");
        this.jTextArea1.setText("");
        this.jTabbedPane1.setSelectedIndex(0);
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void getTofixAccessToken() {
        try {
            JsonObject json = OAuthClient.authTofixBackend(this.sessionId, this.requestToken);
            if (json != null) {
                String token = json.getString("tfx_token");
                this.jTextArea1.setText(token);
                this.setTofixToken(token);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 0);
        }
    }

    public void autenticationOSM() {
        try {
            OAuthClient c = new OAuthClient();
            this.sessionId = c.authorise(this.jTextField1.getText(), String.copyValueOf(this.jPasswordField1.getPassword()), OAuthClient.getPrivileges());
            this.requestToken = c.getRequestToken();
            c.getOAuthToken(this.sessionId, this.requestToken);
            Logging.info((String)this.sessionId.getToken());
            this.setOsmOAuthToken(this.sessionId.getToken());
            c.logout(this.sessionId);
            this.jTabbedPane1.setSelectedIndex(1);
            this.getTofixAccessToken();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Incorrect credentials : \n" + ex.getMessage(), "Error", 0);
        }
    }

    public void setUserInfo(String usuario, String password, String tfxToken) {
        this.jTextField1.setText(usuario);
        this.jPasswordField1.setText(password);
        this.jTextArea1.setText(tfxToken);
        this.setTofixToken(tfxToken);
        if (!this.getTofixToken().equals("")) {
            this.jTabbedPane1.setSelectedIndex(1);
        }
    }

    public String getOsmOAuthToken() {
        return this.osmOAuthToken;
    }

    public void setOsmOAuthToken(String osmOAuthToken) {
        this.osmOAuthToken = osmOAuthToken;
    }

    public void setTofixToken(String tofixToken) {
        this.tofixToken = tofixToken;
    }

    public String getTofixToken() {
        return this.tofixToken;
    }
}

