/*
 * Decompiled with CFR 0.152.
 */
package com.tilusnet.josm.plugins.alignways;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class AlignWaysSegment
implements MapViewPaintable {
    protected WaySegment segment;
    protected MapView mapview;
    protected Color segmentColor = Color.WHITE;
    protected Collection<Node> segmentEndPoints;

    public AlignWaysSegment(MapView mapview, Point p) throws IllegalArgumentException {
        if (mapview == null) {
            throw new IllegalArgumentException(I18n.tr((String)"Parameter ''{0}'' must not be null", (Object[])new Object[]{"mapview"}));
        }
        if (p == null) {
            throw new IllegalArgumentException(I18n.tr((String)"Parameter ''{0}'' must not be null", (Object[])new Object[]{"p"}));
        }
        this.mapview = mapview;
    }

    void setSegment(WaySegment segment) {
        this.segment = segment;
        if (segment != null) {
            this.setSegmentEndpoints(segment);
            this.mapview.addTemporaryLayer((MapViewPaintable)this);
        }
    }

    void setSegmentEndpoints(WaySegment segment) {
        if (segment != null) {
            try {
                this.segmentEndPoints = new HashSet<Node>();
                this.segmentEndPoints.add(segment.getFirstNode());
                this.segmentEndPoints.add(segment.getSecondNode());
            }
            catch (IndexOutOfBoundsException e) {
                Logging.error((Throwable)e);
            }
        }
    }

    protected WaySegment getNearestWaySegment(Point p) {
        return this.mapview.getNearestWaySegment(p, AbstractPrimitive::isUsable);
    }

    public void destroy() {
        if (this.segment != null) {
            this.mapview.removeTemporaryLayer((MapViewPaintable)this);
        }
    }

    public WaySegment getSegment() {
        return this.segment;
    }

    public Collection<Node> getSegmentEndPoints() {
        return this.segmentEndPoints;
    }

    public void paint(Graphics2D g, MapView mv, Bounds bbox) {
        if (this.segment.way.getNodesCount() <= this.segment.lowerIndex + 1) {
            Logging.warn((String)"Not drawing AlignWays highlighting segment: underlying nodes disappeared");
            return;
        }
        this.highlightSegment(this.segmentColor, g, mv);
    }

    protected void highlightSegment(Color c, Graphics2D g, MapView mv) {
        g.setColor(c);
        g.setStroke(new BasicStroke(6.0f, 1, 1));
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawSegment(g, mv);
    }

    protected void drawSegment(Graphics2D g, MapView mv) {
        try {
            Node n1 = this.segment.getFirstNode();
            Node n2 = this.segment.getSecondNode();
            g.draw(new Line2D.Double(mv.getPoint(n1), mv.getPoint(n2)));
        }
        catch (IndexOutOfBoundsException e) {
            Logging.error((Throwable)e);
        }
    }

    protected boolean containsPrimitive(OsmPrimitive primitive) {
        if (this.segment == null) {
            return false;
        }
        return primitive instanceof Way && this.segment.way.equals((Object)primitive) || primitive instanceof Node && this.segmentEndPoints.contains(primitive);
    }

    public int hashCode() {
        if (this.segment == null) {
            return System.identityHashCode(this);
        }
        return this.segment.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AlignWaysSegment)) {
            return false;
        }
        AlignWaysSegment that = (AlignWaysSegment)o;
        return Objects.equals(this.segment, that.segment);
    }
}

