/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.io.File;
import org.junit.Assert;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.plugins.pt_assistant.AbstractTest;
import org.openstreetmap.josm.plugins.pt_assistant.ImportUtils;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTRouteDataManager;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;
import org.openstreetmap.josm.plugins.pt_assistant.utils.StopToWayAssigner;
import org.openstreetmap.josm.plugins.pt_assistant.validation.PTAssistantValidatorTest;
import org.openstreetmap.josm.plugins.pt_assistant.validation.SegmentChecker;

public class SegmentCheckerTest
extends AbstractTest {
    @org.junit.Test
    public void test() {
        File file = new File("test/data/segment-test.osm");
        DataSet ds = ImportUtils.importOsmFile(file, "testLayer");
        PTAssistantValidatorTest test = new PTAssistantValidatorTest();
        Relation route = null;
        for (Relation r : ds.getRelations()) {
            if (!RouteUtils.isVersionTwoPTRoute(r)) continue;
            route = r;
            break;
        }
        SegmentChecker segmentChecker = new SegmentChecker(route, (Test)test);
        PTRouteDataManager manager = new PTRouteDataManager(route);
        segmentChecker.setManager(manager);
        segmentChecker.setAssigner(new StopToWayAssigner(manager.getPTWays()));
        segmentChecker.performStopByStopTest();
        test.storeCorrectRouteSegments(route, segmentChecker.getManager(), segmentChecker.getAssigner());
        Assert.assertEquals((long)27L, (long)SegmentChecker.getCorrectSegmentCount());
        Assert.assertEquals((long)0L, (long)segmentChecker.getErrors().size());
    }
}

