/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.plugins.pt_assistant.AbstractTest;
import org.openstreetmap.josm.plugins.pt_assistant.ImportUtils;
import org.openstreetmap.josm.plugins.pt_assistant.validation.PTAssistantValidatorTest;
import org.openstreetmap.josm.plugins.pt_assistant.validation.WayChecker;

public class DirecionTestTest
extends AbstractTest {
    @org.junit.Test
    public void testOnewayTrue() {
        File file = new File("test/data/oneway-wrong-direction.osm");
        DataSet ds = ImportUtils.importOsmFile(file, "testLayer");
        PTAssistantValidatorTest test = new PTAssistantValidatorTest();
        ArrayList<TestError> errors = new ArrayList<TestError>();
        for (Relation r : ds.getRelations()) {
            WayChecker wayChecker = new WayChecker(r, (Test)test);
            wayChecker.performDirectionTest();
            errors.addAll(wayChecker.getErrors());
        }
        Assert.assertEquals((long)errors.size(), (long)2L);
        int onewayErrorCaught = 0;
        for (TestError e : errors) {
            if (e.getCode() != 3731) continue;
            ++onewayErrorCaught;
        }
        Assert.assertEquals((long)onewayErrorCaught, (long)2L);
        boolean detectedErrorsAreCorrect = true;
        for (TestError e : errors) {
            if (e.getCode() != 3731) continue;
            Collection highlighted = e.getHighlighted();
            for (OsmPrimitive highlightedPrimitive : highlighted) {
                if (highlightedPrimitive.getId() == 225732678L || highlightedPrimitive.getId() == 24215210L) continue;
                detectedErrorsAreCorrect = false;
            }
        }
        Assert.assertTrue((boolean)detectedErrorsAreCorrect);
    }
}

