/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.actions;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.relation.sort.RelationSorter;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class EdgeSelectionAction
extends MapMode {
    private static final String MAP_MODE_NAME = "Edge Selection";
    private static final long serialVersionUID = 2414977774504904238L;
    private transient Set<Way> highlighted = new HashSet<Way>();
    private Cursor selectionCursor = ImageProvider.getCursor((String)"normal", (String)"selection");
    private Cursor waySelectCursor = ImageProvider.getCursor((String)"normal", (String)"select_way");

    public EdgeSelectionAction() {
        super(I18n.tr((String)MAP_MODE_NAME, (Object[])new Object[0]), "edgeSelection", I18n.tr((String)MAP_MODE_NAME, (Object[])new Object[0]), Shortcut.registerShortcut((String)"mapmode:edge_selection", (String)I18n.tr((String)"Mode: {0}", (Object[])new Object[]{I18n.tr((String)MAP_MODE_NAME, (Object[])new Object[0])}), (int)75, (int)5006), ImageProvider.getCursor((String)"normal", (String)"selection"));
    }

    private List<Way> getEdgeFromWay(Way initial, String modeOfTravel) {
        List options;
        List<Way> edge = new ArrayList<Way>();
        if (!this.isWaySuitableForMode(initial, modeOfTravel).booleanValue()) {
            return edge;
        }
        Way curr = initial;
        while (true) {
            options = curr.firstNode(true).getParentWays();
            options.remove(curr);
            curr = this.chooseBestWay(options, modeOfTravel);
            if (curr == null || edge.contains(curr)) break;
            edge.add(curr);
        }
        curr = initial;
        while (true) {
            options = curr.lastNode(true).getParentWays();
            options.remove(curr);
            curr = this.chooseBestWay(options, modeOfTravel);
            if (curr == null || edge.contains(curr)) break;
            edge.add(curr);
        }
        edge.add(initial);
        edge = this.sortEdgeWays(edge);
        return edge;
    }

    private List<Way> sortEdgeWays(List<Way> edge) {
        List members = edge.stream().map(w -> new RelationMember("", (OsmPrimitive)w)).collect(Collectors.toList());
        List sorted = new RelationSorter().sortMembers(members);
        return sorted.stream().map(RelationMember::getWay).collect(Collectors.toList());
    }

    private Boolean isWaySuitableForMode(Way toCheck, String modeOfTravel) {
        if ("bus".equals(modeOfTravel)) {
            return RouteUtils.isWaySuitableForBuses(toCheck);
        }
        return RouteUtils.isWaySuitableForPublicTransport(toCheck);
    }

    private Way chooseBestWay(List<Way> ways, String modeOfTravel) {
        ways.removeIf(w -> this.isWaySuitableForMode((Way)w, modeOfTravel) == false);
        if (ways.isEmpty()) {
            return null;
        }
        if (ways.size() == 1) {
            return ways.get(0);
        }
        Way theChoosenOne = null;
        "bus".equals(modeOfTravel);
        "tram".equals(modeOfTravel);
        return theChoosenOne;
    }

    private String getModeOfTravel() {
        return "bus";
    }

    public void mouseClicked(MouseEvent e) {
        DataSet ds = MainApplication.getLayerManager().getEditDataSet();
        Way initial = MainApplication.getMap().mapView.getNearestWay(e.getPoint(), AbstractPrimitive::isUsable);
        if (initial != null) {
            List<Way> edge = this.getEdgeFromWay(initial, this.getModeOfTravel());
            ds.setSelected(edge);
            AutoScaleAction.zoomTo((Collection)edge.stream().map(w -> w).collect(Collectors.toList()));
        } else {
            ds.clearSelection();
        }
    }

    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
        for (Way way : this.highlighted) {
            way.setHighlighted(false);
        }
        this.highlighted.clear();
        Way initial = MainApplication.getMap().mapView.getNearestWay(e.getPoint(), AbstractPrimitive::isUsable);
        if (initial == null) {
            MainApplication.getMap().mapView.setCursor(this.selectionCursor);
        } else {
            MainApplication.getMap().mapView.setCursor(this.waySelectCursor);
            this.highlighted.addAll(this.getEdgeFromWay(initial, this.getModeOfTravel()));
        }
        for (Way way : this.highlighted) {
            way.setHighlighted(true);
        }
    }

    public void enterMode() {
        super.enterMode();
        MainApplication.getMap().mapView.addMouseListener((MouseListener)((Object)this));
        MainApplication.getMap().mapView.addMouseMotionListener((MouseMotionListener)((Object)this));
    }

    public void exitMode() {
        super.exitMode();
        MainApplication.getMap().mapView.removeMouseListener((MouseListener)((Object)this));
        MainApplication.getMap().mapView.removeMouseMotionListener((MouseMotionListener)((Object)this));
    }
}

