/*
 * Decompiled with CFR 0.152.
 */
package at.dallermassl.josm.plugin.surveyor;

import at.dallermassl.josm.plugin.surveyor.ButtonType;
import at.dallermassl.josm.plugin.surveyor.GpsDataSource;
import at.dallermassl.josm.plugin.surveyor.MetaAction;
import at.dallermassl.josm.plugin.surveyor.SurveyorActionDescription;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ComponentInputMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ActionMapUIResource;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ButtonDescription {
    private String label;
    private String hotkey;
    private String iconName;
    private ButtonType type;
    private List<SurveyorActionDescription> actions;
    private GpsDataSource gpsDataSource;

    public ButtonDescription() {
    }

    public ButtonDescription(String label, String hotkey, String iconName, String buttonAction, ButtonType type) {
        this(label, hotkey, iconName, ButtonDescription.createFromOneElement(new SurveyorActionDescription(buttonAction)), type);
    }

    public ButtonDescription(String label, String hotkey, String iconName, SurveyorActionDescription actionDescription, ButtonType type) {
        this(label, hotkey, iconName, ButtonDescription.createFromOneElement(actionDescription), type);
    }

    private static List<SurveyorActionDescription> createFromOneElement(SurveyorActionDescription actionDescription) {
        ArrayList<SurveyorActionDescription> list = new ArrayList<SurveyorActionDescription>();
        list.add(actionDescription);
        return list;
    }

    public ButtonDescription(String label, String hotkey, String iconName, List<SurveyorActionDescription> actions, ButtonType type) {
        this.label = label;
        this.hotkey = hotkey;
        this.iconName = iconName;
        this.type = type == null ? ButtonType.SINGLE : type;
        this.actions = actions;
    }

    public List<SurveyorActionDescription> getActions() {
        return this.actions;
    }

    public void setActions(List<SurveyorActionDescription> actions) {
        this.actions = actions;
    }

    public String getHotkey() {
        return this.hotkey;
    }

    public void setHotkey(String hotkey) {
        this.hotkey = hotkey;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public ButtonType getButtonType() {
        return this.type;
    }

    public void setType(String type) {
        try {
            this.type = ButtonType.valueOf(type.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            System.err.println("Unknown button type '" + type + "' given. Allowed values are " + Arrays.toString((Object[])ButtonType.values()));
        }
    }

    public void setButtonType(ButtonType type) {
        this.type = type;
    }

    public void setIcon(String icon) {
        this.iconName = icon;
    }

    public JComponent createComponent() {
        AbstractButton button;
        String actionName = I18n.tr((String)this.getLabel(), (Object[])new Object[0]) + " (" + this.hotkey + ")";
        ImageIcon icon = ImageProvider.getIfAvailable(null, (String)this.iconName);
        if (icon == null) {
            icon = ImageProvider.getIfAvailable((String)"markers", (String)this.iconName);
        }
        if (icon == null) {
            icon = ImageProvider.getIfAvailable((String)"symbols", (String)this.iconName);
        }
        if (icon == null) {
            icon = ImageProvider.getIfAvailable((String)"nodes", (String)this.iconName);
        }
        MetaAction action = new MetaAction(actionName, icon);
        action.setActions(this.actions);
        action.setGpsDataSource(this.gpsDataSource);
        if (this.type == ButtonType.TOGGLE) {
            button = new JToggleButton(action);
            ButtonDescription.connectActionAndButton(action, button);
        } else {
            button = new JButton(action);
        }
        button.setActionCommand(this.label);
        ActionMapUIResource actionMap = new ActionMapUIResource();
        actionMap.put(actionName, action);
        ComponentInputMap keyMap = new ComponentInputMap(button);
        ((InputMap)keyMap).put(KeyStroke.getKeyStroke(this.hotkey), actionName);
        SwingUtilities.replaceUIActionMap(button, actionMap);
        SwingUtilities.replaceUIInputMap(button, 2, keyMap);
        return button;
    }

    private static void connectActionAndButton(Action action, AbstractButton button) {
        SelectionStateAdapter adapter = new SelectionStateAdapter(action, button);
        adapter.configure();
    }

    public void setGpsDataSource(GpsDataSource gpsDataSource) {
        this.gpsDataSource = gpsDataSource;
    }

    private static class SelectionStateAdapter
    implements PropertyChangeListener,
    ItemListener {
        private Action action;
        private AbstractButton button;

        SelectionStateAdapter(Action theAction, AbstractButton theButton) {
            this.action = theAction;
            this.button = theButton;
        }

        protected void configure() {
            this.action.addPropertyChangeListener(this);
            this.button.addItemListener(this);
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            boolean value = e.getStateChange() == 1;
            Boolean valueObj = value;
            this.action.putValue("actionConstants.selected", valueObj);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("actionConstants.selected")) {
                Boolean newSelectedState = (Boolean)evt.getNewValue();
                this.button.setSelected(newSelectedState);
            }
        }
    }
}

