/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.indoorhelper;

import controller.IndoorHelperController;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.autofilter.AutoFilter;
import org.openstreetmap.josm.gui.autofilter.AutoFilterManager;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;

public class IndoorHelperPlugin
extends Plugin
implements MapViewPaintable.PaintableInvalidationListener,
MainLayerManager.ActiveLayerChangeListener {
    private IndoorHelperController controller;
    String sep = System.getProperty("file.separator");

    public IndoorHelperPlugin(PluginInformation info) throws Exception {
        super(info);
        MainApplication.getLayerManager().addAndFireActiveLayerChangeListener((MainLayerManager.ActiveLayerChangeListener)this);
        this.exportValidator("/data/indoorhelper.validator.mapcss");
        this.exportStyleFile("sit.mapcss");
        this.exportStyleFile("entrance_door_icon.png");
        this.exportStyleFile("entrance_icon.png");
        this.exportStyleFile("elevator_icon.png");
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        super.mapFrameInitialized(oldFrame, newFrame);
        if (oldFrame == null && newFrame != null) {
            this.controller = new IndoorHelperController();
        }
    }

    private void exportValidator(String resourceName) throws Exception {
        FileOutputStream resStreamOut = null;
        try (InputStream stream = null;){
            int readBytes;
            stream = IndoorHelperPlugin.class.getResourceAsStream(resourceName);
            if (stream == null) {
                System.out.println("Validator: stream is null");
                throw new Exception("Cannot get resource \"" + resourceName + "\" from Jar file.");
            }
            byte[] buffer = new byte[4096];
            String valDirPath = Main.pref.getDirs().getUserDataDirectory(true) + this.sep + "validator";
            File valDir = new File(valDirPath);
            valDir.mkdirs();
            String outPath = String.valueOf(valDir.getAbsolutePath()) + this.sep + "indoorhelper.validator.mapcss";
            System.out.println("Validator:" + outPath);
            resStreamOut = new FileOutputStream(outPath);
            while ((readBytes = stream.read(buffer)) > 0) {
                ((OutputStream)resStreamOut).write(buffer, 0, readBytes);
            }
            ((OutputStream)resStreamOut).close();
        }
    }

    private void exportStyleFile(String resourceName) throws Exception {
        Throwable throwable = null;
        Object var3_5 = null;
        try (InputStream stream = IndoorHelperPlugin.class.getResourceAsStream("/data/" + resourceName);){
            if (stream == null) {
                System.out.println("MapPaint: stream is null");
                throw new Exception("Cannot get resource \"" + resourceName + "\" from Jar file.");
            }
            byte[] buffer = new byte[4096];
            String valDirPath = Main.pref.getDirs().getUserDataDirectory(true) + this.sep + "styles";
            File valDir = new File(valDirPath);
            valDir.mkdirs();
            String outPath = String.valueOf(valDir.getAbsolutePath()) + this.sep + resourceName;
            Throwable throwable2 = null;
            Object var11_14 = null;
            try (FileOutputStream resStreamOut = new FileOutputStream(outPath);){
                int readBytes;
                while ((readBytes = stream.read(buffer)) > 0) {
                    ((OutputStream)resStreamOut).write(buffer, 0, readBytes);
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        OsmDataLayer editLayer = MainApplication.getLayerManager().getEditLayer();
        if (editLayer != null) {
            editLayer.addInvalidationListener((MapViewPaintable.PaintableInvalidationListener)this);
        }
    }

    public void paintableInvalidated(MapViewPaintable.PaintableInvalidationEvent event) {
        AutoFilter currentAutoFilter = AutoFilterManager.getInstance().getCurrentAutoFilter();
        String currentFilterValue = new String();
        if (currentAutoFilter != null) {
            currentFilterValue = currentAutoFilter.getFilter().text.split("=")[1];
            this.controller.setIndoorLevel(currentFilterValue);
            this.controller.getIndoorLevel(currentFilterValue);
            this.controller.unsetSpecificKeyFilter("repeat_on");
        } else {
            currentFilterValue = "";
            this.controller.setIndoorLevel(currentFilterValue);
            this.controller.getIndoorLevel(currentFilterValue);
        }
    }
}

