/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function.color;

import java.awt.Color;
import org.geotools.filter.FunctionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.function.color.HSLColor;
import org.opengis.filter.capability.FunctionName;

public class SpinFunction
extends FunctionImpl {
    public static FunctionName NAME = new FunctionNameImpl("spin", FunctionNameImpl.parameter("result", Color.class), FunctionNameImpl.parameter("color", Color.class), FunctionNameImpl.parameter("amount", Double.class));

    public SpinFunction() {
        this.functionName = NAME;
    }

    @Override
    public Object evaluate(Object object) {
        Color color = (Color)this.getParameterValue(object, 0);
        double amount = (Double)this.getParameterValue(object, 1);
        HSLColor hsl = new HSLColor(color);
        double hue = (hsl.getHue() + amount) % 360.0;
        if (hue < 0.0) {
            hue += 360.0;
        }
        hsl.setHue(hue);
        return hsl.toRGB();
    }
}

