/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.ss.formula.Formula;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianOutput;
import org.apache.poi.util.StringUtil;

public final class NameRecord
extends StandardRecord {
    public static final short sid = 24;
    public static final byte BUILTIN_CONSOLIDATE_AREA = 1;
    public static final byte BUILTIN_AUTO_OPEN = 2;
    public static final byte BUILTIN_AUTO_CLOSE = 3;
    public static final byte BUILTIN_DATABASE = 4;
    public static final byte BUILTIN_CRITERIA = 5;
    public static final byte BUILTIN_PRINT_AREA = 6;
    public static final byte BUILTIN_PRINT_TITLE = 7;
    public static final byte BUILTIN_RECORDER = 8;
    public static final byte BUILTIN_DATA_FORM = 9;
    public static final byte BUILTIN_AUTO_ACTIVATE = 10;
    public static final byte BUILTIN_AUTO_DEACTIVATE = 11;
    public static final byte BUILTIN_SHEET_TITLE = 12;
    public static final byte BUILTIN_FILTER_DB = 13;
    private short field_1_option_flag;
    private byte field_2_keyboard_shortcut;
    private short field_5_externSheetIndex_plus1;
    private int field_6_sheetNumber;
    private boolean field_11_nameIsMultibyte;
    private byte field_12_built_in_code;
    private String field_12_name_text;
    private Formula field_13_name_definition;
    private String field_14_custom_menu_text;
    private String field_15_description_text;
    private String field_16_help_topic_text;
    private String field_17_status_bar_text;

    public NameRecord() {
        this.field_13_name_definition = Formula.create(Ptg.EMPTY_PTG_ARRAY);
        this.field_12_name_text = "";
        this.field_14_custom_menu_text = "";
        this.field_15_description_text = "";
        this.field_16_help_topic_text = "";
        this.field_17_status_bar_text = "";
    }

    public NameRecord(byte by, int n) {
        this();
        this.field_12_built_in_code = by;
        this.setOptionFlag((short)(this.field_1_option_flag | 0x20));
        this.field_6_sheetNumber = n;
    }

    public void setOptionFlag(short s) {
        this.field_1_option_flag = s;
    }

    public short getOptionFlag() {
        return this.field_1_option_flag;
    }

    public byte getKeyboardShortcut() {
        return this.field_2_keyboard_shortcut;
    }

    private int getNameTextLength() {
        if (this.isBuiltInName()) {
            return 1;
        }
        return this.field_12_name_text.length();
    }

    public boolean isBuiltInName() {
        return (this.field_1_option_flag & 0x20) != 0;
    }

    public String getNameText() {
        return this.isBuiltInName() ? NameRecord.translateBuiltInName(this.getBuiltInName()) : this.field_12_name_text;
    }

    public byte getBuiltInName() {
        return this.field_12_built_in_code;
    }

    public String getCustomMenuText() {
        return this.field_14_custom_menu_text;
    }

    public String getDescriptionText() {
        return this.field_15_description_text;
    }

    public String getHelpTopicText() {
        return this.field_16_help_topic_text;
    }

    public String getStatusBarText() {
        return this.field_17_status_bar_text;
    }

    @Override
    public void serialize(LittleEndianOutput littleEndianOutput) {
        int n = this.field_14_custom_menu_text.length();
        int n2 = this.field_15_description_text.length();
        int n3 = this.field_16_help_topic_text.length();
        int n4 = this.field_17_status_bar_text.length();
        littleEndianOutput.writeShort(this.getOptionFlag());
        littleEndianOutput.writeByte(this.getKeyboardShortcut());
        littleEndianOutput.writeByte(this.getNameTextLength());
        littleEndianOutput.writeShort(this.field_13_name_definition.getEncodedTokenSize());
        littleEndianOutput.writeShort(this.field_5_externSheetIndex_plus1);
        littleEndianOutput.writeShort(this.field_6_sheetNumber);
        littleEndianOutput.writeByte(n);
        littleEndianOutput.writeByte(n2);
        littleEndianOutput.writeByte(n3);
        littleEndianOutput.writeByte(n4);
        littleEndianOutput.writeByte(this.field_11_nameIsMultibyte ? 1 : 0);
        if (this.isBuiltInName()) {
            littleEndianOutput.writeByte(this.field_12_built_in_code);
        } else {
            String string = this.field_12_name_text;
            if (this.field_11_nameIsMultibyte) {
                StringUtil.putUnicodeLE(string, littleEndianOutput);
            } else {
                StringUtil.putCompressedUnicode(string, littleEndianOutput);
            }
        }
        this.field_13_name_definition.serializeTokens(littleEndianOutput);
        this.field_13_name_definition.serializeArrayConstantData(littleEndianOutput);
        StringUtil.putCompressedUnicode(this.getCustomMenuText(), littleEndianOutput);
        StringUtil.putCompressedUnicode(this.getDescriptionText(), littleEndianOutput);
        StringUtil.putCompressedUnicode(this.getHelpTopicText(), littleEndianOutput);
        StringUtil.putCompressedUnicode(this.getStatusBarText(), littleEndianOutput);
    }

    private int getNameRawSize() {
        if (this.isBuiltInName()) {
            return 1;
        }
        int n = this.field_12_name_text.length();
        if (this.field_11_nameIsMultibyte) {
            return 2 * n;
        }
        return n;
    }

    @Override
    protected int getDataSize() {
        return 13 + this.getNameRawSize() + this.field_14_custom_menu_text.length() + this.field_15_description_text.length() + this.field_16_help_topic_text.length() + this.field_17_status_bar_text.length() + this.field_13_name_definition.getEncodedSize();
    }

    public NameRecord(RecordInputStream recordInputStream) {
        RecordInputStream recordInputStream2 = recordInputStream;
        this.field_1_option_flag = recordInputStream2.readShort();
        this.field_2_keyboard_shortcut = recordInputStream2.readByte();
        int n = recordInputStream2.readUByte();
        short s = recordInputStream2.readShort();
        this.field_5_externSheetIndex_plus1 = recordInputStream2.readShort();
        this.field_6_sheetNumber = recordInputStream2.readUShort();
        int n2 = recordInputStream2.readUByte();
        int n3 = recordInputStream2.readUByte();
        int n4 = recordInputStream2.readUByte();
        int n5 = recordInputStream2.readUByte();
        boolean bl = this.field_11_nameIsMultibyte = recordInputStream2.readByte() != 0;
        if (this.isBuiltInName()) {
            this.field_12_built_in_code = recordInputStream2.readByte();
        } else {
            this.field_12_name_text = this.field_11_nameIsMultibyte ? StringUtil.readUnicodeLE(recordInputStream2, n) : StringUtil.readCompressedUnicode(recordInputStream2, n);
        }
        int n6 = recordInputStream2.available() - (n2 + n3 + n4 + n5);
        this.field_13_name_definition = Formula.read(s, recordInputStream2, n6);
        this.field_14_custom_menu_text = StringUtil.readCompressedUnicode(recordInputStream2, n2);
        this.field_15_description_text = StringUtil.readCompressedUnicode(recordInputStream2, n3);
        this.field_16_help_topic_text = StringUtil.readCompressedUnicode(recordInputStream2, n4);
        this.field_17_status_bar_text = StringUtil.readCompressedUnicode(recordInputStream2, n5);
    }

    @Override
    public short getSid() {
        return 24;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[NAME]\n");
        stringBuffer.append("    .option flags           = ").append(HexDump.shortToHex(this.field_1_option_flag)).append("\n");
        stringBuffer.append("    .keyboard shortcut      = ").append(HexDump.byteToHex(this.field_2_keyboard_shortcut)).append("\n");
        stringBuffer.append("    .length of the name     = ").append(this.getNameTextLength()).append("\n");
        stringBuffer.append("    .extSheetIx(1-based, 0=Global)= ").append(this.field_5_externSheetIndex_plus1).append("\n");
        stringBuffer.append("    .sheetTabIx             = ").append(this.field_6_sheetNumber).append("\n");
        stringBuffer.append("    .Menu text length       = ").append(this.field_14_custom_menu_text.length()).append("\n");
        stringBuffer.append("    .Description text length= ").append(this.field_15_description_text.length()).append("\n");
        stringBuffer.append("    .Help topic text length = ").append(this.field_16_help_topic_text.length()).append("\n");
        stringBuffer.append("    .Status bar text length = ").append(this.field_17_status_bar_text.length()).append("\n");
        stringBuffer.append("    .NameIsMultibyte        = ").append(this.field_11_nameIsMultibyte).append("\n");
        stringBuffer.append("    .Name (Unicode text)    = ").append(this.getNameText()).append("\n");
        Ptg[] ptgArray = this.field_13_name_definition.getTokens();
        stringBuffer.append("    .Formula (nTokens=").append(ptgArray.length).append("):").append("\n");
        for (int i = 0; i < ptgArray.length; ++i) {
            Ptg ptg = ptgArray[i];
            stringBuffer.append("       " + ptg.toString()).append(ptg.getRVAType()).append("\n");
        }
        stringBuffer.append("    .Menu text       = ").append(this.field_14_custom_menu_text).append("\n");
        stringBuffer.append("    .Description text= ").append(this.field_15_description_text).append("\n");
        stringBuffer.append("    .Help topic text = ").append(this.field_16_help_topic_text).append("\n");
        stringBuffer.append("    .Status bar text = ").append(this.field_17_status_bar_text).append("\n");
        stringBuffer.append("[/NAME]\n");
        return stringBuffer.toString();
    }

    private static String translateBuiltInName(byte by) {
        switch (by) {
            case 10: {
                return "Auto_Activate";
            }
            case 3: {
                return "Auto_Close";
            }
            case 11: {
                return "Auto_Deactivate";
            }
            case 2: {
                return "Auto_Open";
            }
            case 1: {
                return "Consolidate_Area";
            }
            case 5: {
                return "Criteria";
            }
            case 4: {
                return "Database";
            }
            case 9: {
                return "Data_Form";
            }
            case 6: {
                return "Print_Area";
            }
            case 7: {
                return "Print_Titles";
            }
            case 8: {
                return "Recorder";
            }
            case 12: {
                return "Sheet_Title";
            }
            case 13: {
                return "_FilterDatabase";
            }
        }
        return "Unknown";
    }

    private static final class Option {
        public static final int OPT_BUILTIN = 32;

        private Option() {
        }
    }
}

