/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.gui2.BugTreeModel;
import edu.umd.cs.findbugs.gui2.Debug;
import edu.umd.cs.findbugs.gui2.FilterMatcher;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.gui2.Sortables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.event.TreeModelEvent;

@Deprecated
public class StackedFilterMatcher
extends FilterMatcher {
    private static final long serialVersionUID = 3958267780332359162L;
    private final FilterMatcher[] filters;

    @Override
    Sortables getFilterBy() {
        throw new UnsupportedOperationException("Stacked filter matchers do not filter out a single Sortables, use getFilters()");
    }

    @Override
    String getValue() {
        throw new UnsupportedOperationException("Stacked filter matchers do not filter out a single Sortables's value, use getFilters and getValue individually on returned filters.");
    }

    public StackedFilterMatcher(FilterMatcher ... filters) {
        super(null, null);
        this.filters = filters;
    }

    @Override
    public void setActive(boolean active) {
        TreeModelEvent event = null;
        if (active != this.active) {
            if (!active) {
                this.active = active;
            }
            StackedFilterMatcher theSame = this;
            FilterMatcher[] filtersInStack = theSame.getFilters();
            ArrayList<Sortables> order = MainFrame.getInstance().getSorter().getOrder();
            int sizeToCheck = filtersInStack.length;
            if (order.contains(Sortables.DIVIDER) && order.indexOf(Sortables.DIVIDER) < filtersInStack.length) {
                ++sizeToCheck;
            }
            List<Sortables> sortablesToCheck = order.subList(0, Math.min(sizeToCheck, order.size()));
            Debug.println("Size to check" + sizeToCheck + " checking list" + sortablesToCheck);
            Debug.println("checking filters");
            ArrayList<String> almostPath = new ArrayList<String>();
            ArrayList<Sortables> almostPathSortables = new ArrayList<Sortables>();
            for (int x = 0; x < sortablesToCheck.size(); ++x) {
                Sortables s = sortablesToCheck.get(x);
                for (FilterMatcher fm : filtersInStack) {
                    if (!s.equals(fm.getFilterBy())) continue;
                    almostPath.add(fm.getValue());
                    almostPathSortables.add(fm.getFilterBy());
                }
            }
            ArrayList<String> finalPath = new ArrayList<String>();
            for (int x = 0; x < almostPath.size(); ++x) {
                Sortables s = (Sortables)almostPathSortables.get(x);
                if (!MainFrame.getInstance().getSorter().getOrderBeforeDivider().contains(s)) continue;
                finalPath.add((String)almostPath.get(x));
            }
            try {
                BugTreeModel.TreeModification whatToDo;
                if (finalPath.size() == filtersInStack.length) {
                    if (active) {
                        event = MainFrame.getInstance().getBugTreeModel().removeBranch(finalPath);
                        whatToDo = BugTreeModel.TreeModification.REMOVE;
                    } else {
                        event = MainFrame.getInstance().getBugTreeModel().insertBranch(finalPath);
                        whatToDo = BugTreeModel.TreeModification.INSERT;
                    }
                } else {
                    event = MainFrame.getInstance().getBugTreeModel().restructureBranch(finalPath, active);
                    whatToDo = active ? BugTreeModel.TreeModification.REMOVERESTRUCTURE : BugTreeModel.TreeModification.INSERTRESTRUCTURE;
                }
                if (active) {
                    this.active = active;
                }
                MainFrame.getInstance().getBugTreeModel().sendEvent(event, whatToDo);
            }
            catch (BugTreeModel.BranchOperationException e) {
                this.active = active;
            }
        }
    }

    public FilterMatcher[] getFilters() {
        return this.filters;
    }

    @Override
    public boolean match(BugInstance bugInstance) {
        if (!this.isActive()) {
            return true;
        }
        for (FilterMatcher i : this.filters) {
            if (!i.match(bugInstance)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.filters.length - 1; ++i) {
            result.append(this.filters[i].toString() + (i == this.filters.length - 2 ? " " : ", "));
        }
        if (this.filters.length > 1) {
            result.append("and ");
        }
        if (this.filters.length > 0) {
            result.append(this.filters[this.filters.length - 1]);
        }
        return result.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof StackedFilterMatcher)) {
            return false;
        }
        Object[] mine = new FilterMatcher[this.filters.length];
        System.arraycopy(this.filters, 0, mine, 0, mine.length);
        Arrays.sort(mine);
        Object[] others = new FilterMatcher[((StackedFilterMatcher)o).filters.length];
        System.arraycopy(((StackedFilterMatcher)o).filters, 0, others, 0, others.length);
        Arrays.sort(others);
        return Arrays.equals(mine, others);
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (FilterMatcher f : this.filters) {
            hash += f.hashCode();
        }
        return hash;
    }

    public static void main(String[] args) {
        System.out.println(new StackedFilterMatcher(new FilterMatcher[0]).equals(new StackedFilterMatcher(new FilterMatcher[0])));
    }
}

