/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.graph;

import edu.umd.cs.findbugs.graph.Graph;
import edu.umd.cs.findbugs.graph.GraphEdge;
import edu.umd.cs.findbugs.graph.GraphToolkit;
import edu.umd.cs.findbugs.graph.GraphVertex;
import edu.umd.cs.findbugs.graph.VertexCombinator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class MergeVertices<GraphType extends Graph<EdgeType, VertexType>, EdgeType extends GraphEdge<EdgeType, VertexType>, VertexType extends GraphVertex<VertexType>> {
    public void mergeVertices(Set<VertexType> vertexSet, GraphType g, VertexCombinator<VertexType> combinator, GraphToolkit<GraphType, EdgeType, VertexType> toolkit) {
        if (vertexSet.size() <= 1) {
            return;
        }
        TreeSet<GraphEdge> edgeSet = new TreeSet<GraphEdge>();
        Iterator i = g.edgeIterator();
        while (i.hasNext()) {
            GraphEdge e = (GraphEdge)i.next();
            if (!vertexSet.contains(e.getSource()) && !vertexSet.contains(e.getTarget())) continue;
            edgeSet.add(e);
        }
        VertexType compositeVertex = combinator.combineVertices(vertexSet);
        for (GraphEdge e : edgeSet) {
            VertexType target;
            VertexType source = vertexSet.contains(e.getSource()) ? compositeVertex : e.getSource();
            VertexType VertexType = target = vertexSet.contains(e.getTarget()) ? compositeVertex : e.getTarget();
            if (source == compositeVertex && target == compositeVertex && e.getSource() != e.getTarget() || g.lookupEdge(source, target) != null) continue;
            Object compositeEdge = g.createEdge(source, target);
            toolkit.copyEdge(e, (GraphEdge)compositeEdge);
        }
        for (GraphVertex aVertexSet : vertexSet) {
            g.removeVertex((GraphVertex)aVertexSet);
        }
    }
}

