/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.Method;

public class StringConcatenation
extends BytecodeScanningDetector
implements StatelessDetector {
    private static final boolean DEBUG = SystemProperties.getBoolean("sbsc.debug");
    static final int SEEN_NOTHING = 0;
    static final int SEEN_NEW = 1;
    static final int SEEN_APPEND1 = 2;
    static final int SEEN_APPEND2 = 3;
    static final int CONSTRUCTED_STRING_ON_STACK = 4;
    static final int POSSIBLE_CASE = 5;
    private final BugReporter bugReporter;
    private boolean reportedThisMethod;
    private int registerOnStack = -1;
    private int stringSource = -1;
    private int createPC = -1;
    private int state = 0;
    private Map<Integer, Integer> clobberedRegisters = new HashMap<Integer, Integer>();

    public StringConcatenation(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visit(Method obj) {
        if (DEBUG) {
            System.out.println("------------------- Analyzing " + obj.getName() + " ----------------");
        }
        this.reset();
        this.clobberedRegisters = new HashMap<Integer, Integer>();
        this.reportedThisMethod = false;
        super.visit(obj);
    }

    private void reset() {
        this.state = 0;
        this.createPC = -1;
        this.registerOnStack = -1;
        this.stringSource = -1;
        if (DEBUG) {
            System.out.println("Reset from: " + new Throwable().getStackTrace()[1]);
        }
    }

    private boolean storeIntoRegister(int seen, int reg) {
        switch (seen) {
            case 75: {
                return reg == 0;
            }
            case 76: {
                return reg == 1;
            }
            case 77: {
                return reg == 2;
            }
            case 78: {
                return reg == 3;
            }
            case 58: {
                return reg == this.getRegisterOperand();
            }
        }
        return false;
    }

    @Override
    public void sawOpcode(int seen) {
        if (this.reportedThisMethod) {
            return;
        }
        int oldState = this.state;
        if (DEBUG) {
            System.out.print("Opcode: ");
            this.printOpCode(seen);
        }
        int storeTo = -1;
        switch (seen) {
            case 75: {
                storeTo = 0;
                break;
            }
            case 76: {
                storeTo = 1;
                break;
            }
            case 77: {
                storeTo = 2;
                break;
            }
            case 78: {
                storeTo = 3;
                break;
            }
            case 58: {
                storeTo = this.getRegisterOperand();
                break;
            }
        }
        if (storeTo >= 0 && this.state != 4) {
            this.clobberedRegisters.put(storeTo, this.getPC());
        }
        switch (this.state) {
            case 0: {
                if (seen != 187 || !this.getClassConstantOperand().startsWith("java/lang/StringBu")) break;
                this.state = 1;
                this.createPC = this.getPC();
                break;
            }
            case 1: {
                if (seen == 183 && "<init>".equals(this.getNameConstantOperand()) && "(Ljava/lang/String;)V".equals(this.getSigConstantOperand()) && this.getClassConstantOperand().startsWith("java/lang/StringBu") && this.registerOnStack >= 0) {
                    this.state = 2;
                    this.stringSource = this.registerOnStack;
                    break;
                }
                if (seen != 182 || !"append".equals(this.getNameConstantOperand()) || !this.getClassConstantOperand().startsWith("java/lang/StringBu")) break;
                if (DEBUG) {
                    System.out.println("Saw string being appended from register " + this.registerOnStack);
                }
                if (this.getSigConstantOperand().startsWith("(Ljava/lang/String;)") && this.registerOnStack >= 0) {
                    if (DEBUG) {
                        System.out.println("Saw string being appended, source = " + this.registerOnStack);
                    }
                    this.state = 2;
                    this.stringSource = this.registerOnStack;
                    break;
                }
                this.reset();
                break;
            }
            case 2: {
                if (this.storeIntoRegister(seen, this.stringSource)) {
                    this.reset();
                    break;
                }
                if (seen != 182 || !"append".equals(this.getNameConstantOperand()) || !this.getClassConstantOperand().startsWith("java/lang/StringBu")) break;
                this.state = 3;
                break;
            }
            case 3: {
                if (this.storeIntoRegister(seen, this.stringSource)) {
                    this.reset();
                    break;
                }
                if (seen != 182 || !"toString".equals(this.getNameConstantOperand()) || !this.getClassConstantOperand().startsWith("java/lang/StringBu")) break;
                this.state = 4;
                break;
            }
            case 4: {
                if (this.storeIntoRegister(seen, this.stringSource)) {
                    this.state = 5;
                    break;
                }
                this.reset();
                break;
            }
            case 5: {
                if (DismantleBytecode.isBranch(seen) && this.getPC() - this.getBranchTarget() < 300 && this.getBranchTarget() <= this.createPC) {
                    boolean clobberedInLoop = false;
                    for (Map.Entry<Integer, Integer> entry : this.clobberedRegisters.entrySet()) {
                        int pc;
                        int reg = entry.getKey();
                        if (reg != this.stringSource || (pc = entry.getValue().intValue()) < this.getBranchTarget()) continue;
                        clobberedInLoop = true;
                        break;
                    }
                    if (clobberedInLoop) {
                        this.reset();
                        break;
                    }
                    this.bugReporter.reportBug(new BugInstance(this, "SBSC_USE_STRINGBUFFER_CONCATENATION", 2).addClassAndMethod(this).addSourceLine(this, this.createPC));
                    this.reset();
                    this.reportedThisMethod = true;
                    break;
                }
                if (seen == 187 && this.getClassConstantOperand().startsWith("java/lang/StringBu")) {
                    this.state = 1;
                    this.createPC = this.getPC();
                    break;
                }
                if (!DEBUG || !DismantleBytecode.isBranch(seen)) break;
                System.out.println("Rejecting branch:");
                System.out.println("  spread: " + (this.getPC() - this.getBranchTarget()));
                System.out.println("  getBranchTarget(): " + this.getBranchTarget());
                System.out.println("  createPC: " + this.createPC);
                break;
            }
        }
        if (!(seen == 184 && "valueOf".equals(this.getNameConstantOperand()) && "java/lang/String".equals(this.getClassConstantOperand()) && "(Ljava/lang/Object;)Ljava/lang/String;".equals(this.getSigConstantOperand()))) {
            this.registerOnStack = -1;
            switch (seen) {
                case 42: {
                    this.registerOnStack = 0;
                    break;
                }
                case 43: {
                    this.registerOnStack = 1;
                    break;
                }
                case 44: {
                    this.registerOnStack = 2;
                    break;
                }
                case 45: {
                    this.registerOnStack = 3;
                    break;
                }
                case 25: {
                    this.registerOnStack = this.getRegisterOperand();
                    break;
                }
            }
        }
        if (DEBUG && this.state != oldState) {
            System.out.println("At PC " + this.getPC() + " changing from state " + oldState + " to state " + this.state + ", regOnStack = " + this.registerOnStack);
        }
    }
}

