/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.public_transport.dialogs;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.plugins.public_transport.TransText;
import org.openstreetmap.josm.plugins.public_transport.actions.StopImporterAction;
import org.openstreetmap.josm.plugins.public_transport.dialogs.AbstractImporterDialog;
import org.openstreetmap.josm.plugins.public_transport.models.TrackStoplistTableModel;
import org.openstreetmap.josm.plugins.public_transport.models.WaypointTableModel;
import org.openstreetmap.josm.plugins.public_transport.refs.TrackReference;
import org.openstreetmap.josm.tools.I18n;

public class StopImporterDialog
extends AbstractImporterDialog<StopImporterAction> {
    private JList<TrackReference> tracksList = null;
    private final JTable stoplistTable = new JTable();
    private final JTable waypointTable = new JTable();

    public StopImporterDialog(StopImporterAction controller) {
        super(controller, I18n.tr((String)"Create Stops from GPX", (Object[])new Object[0]), "stopImporter");
    }

    @Override
    protected void initDialog(StopImporterAction controller) {
        JPanel tabTracks = new JPanel();
        this.tabbedPane.addTab(I18n.tr((String)"Tracks", (Object[])new Object[0]), tabTracks);
        JPanel tabSettings = new JPanel();
        this.tabbedPane.addTab(I18n.tr((String)"Settings", (Object[])new Object[0]), tabSettings);
        JPanel tabStops = new JPanel();
        this.tabbedPane.addTab(I18n.tr((String)"Stops", (Object[])new Object[0]), tabStops);
        JPanel tabWaypoints = new JPanel();
        this.tabbedPane.addTab(I18n.tr((String)"Waypoints", (Object[])new Object[0]), tabWaypoints);
        this.tabbedPane.setEnabledAt(0, true);
        this.tabbedPane.setEnabledAt(1, true);
        this.tabbedPane.setEnabledAt(2, false);
        this.tabbedPane.setEnabledAt(3, true);
        JPanel contentPane = tabTracks;
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints layoutCons = new GridBagConstraints();
        contentPane.setLayout(gridbag);
        JLabel label = new JLabel(I18n.tr((String)"Tracks in this GPX file:", (Object[])new Object[0]));
        layoutCons.gridx = 0;
        layoutCons.gridy = 0;
        layoutCons.gridwidth = 3;
        layoutCons.weightx = 0.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(label, layoutCons);
        contentPane.add(label);
        DefaultListModel<TrackReference> tracksListModel = controller.getTracksListModel();
        this.tracksList = new JList<TrackReference>(tracksListModel);
        JScrollPane rpListSP = new JScrollPane(this.tracksList);
        Object[] data = new String[]{"1", "2", "3", "4", "5", "6"};
        tracksListModel.copyInto(data);
        this.tracksList.setSelectionMode(0);
        this.tracksList.addListSelectionListener(new TracksLSL(controller));
        layoutCons.gridx = 0;
        layoutCons.gridy = 1;
        layoutCons.gridwidth = 3;
        layoutCons.weightx = 1.0;
        layoutCons.weighty = 1.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(rpListSP, layoutCons);
        contentPane.add(rpListSP);
        contentPane = tabSettings;
        gridbag = new GridBagLayout();
        layoutCons = new GridBagConstraints();
        contentPane.setLayout(gridbag);
        label = new JLabel(I18n.tr((String)"Type of stops to add", (Object[])new Object[0]));
        layoutCons.gridx = 0;
        layoutCons.gridy = 0;
        layoutCons.gridwidth = 2;
        layoutCons.weightx = 0.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(label, layoutCons);
        contentPane.add(label);
        layoutCons.gridx = 0;
        layoutCons.gridy = 1;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 0.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(this.cbStoptype, layoutCons);
        contentPane.add(this.cbStoptype);
        label = new JLabel(I18n.tr((String)"Time on your GPS device", (Object[])new Object[0]));
        layoutCons.gridx = 0;
        layoutCons.gridy = 2;
        layoutCons.gridwidth = 2;
        layoutCons.weightx = 0.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(label, layoutCons);
        contentPane.add(label);
        layoutCons.gridx = 0;
        layoutCons.gridy = 3;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 0.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(this.tfGPSTimeStart, layoutCons);
        contentPane.add(this.tfGPSTimeStart);
        label = new JLabel(I18n.tr((String)"HH:MM:SS.sss", (Object[])new Object[0]));
        layoutCons.gridx = 1;
        layoutCons.gridy = 3;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 0.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(label, layoutCons);
        contentPane.add(label);
        label = new JLabel(I18n.tr((String)"Time on your stopwatch", (Object[])new Object[0]));
        layoutCons.gridx = 0;
        layoutCons.gridy = 4;
        layoutCons.gridwidth = 2;
        layoutCons.weightx = 0.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(label, layoutCons);
        contentPane.add(label);
        layoutCons.gridx = 0;
        layoutCons.gridy = 5;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 0.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(this.tfStopwatchStart, layoutCons);
        contentPane.add(this.tfStopwatchStart);
        label = new JLabel(I18n.tr((String)"HH:MM:SS.sss", (Object[])new Object[0]));
        layoutCons.gridx = 1;
        layoutCons.gridy = 5;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 0.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(label, layoutCons);
        contentPane.add(label);
        label = new JLabel(I18n.tr((String)"Time window", (Object[])new Object[0]));
        layoutCons.gridx = 0;
        layoutCons.gridy = 6;
        layoutCons.gridwidth = 2;
        layoutCons.weightx = 0.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(label, layoutCons);
        contentPane.add(label);
        layoutCons.gridx = 0;
        layoutCons.gridy = 7;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 0.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(this.tfTimeWindow, layoutCons);
        contentPane.add(this.tfTimeWindow);
        label = new JLabel(I18n.tr((String)"seconds", (Object[])new Object[0]));
        layoutCons.gridx = 1;
        layoutCons.gridy = 7;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 0.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(label, layoutCons);
        contentPane.add(label);
        label = new JLabel(I18n.tr((String)"Move Threshold", (Object[])new Object[0]));
        layoutCons.gridx = 0;
        layoutCons.gridy = 8;
        layoutCons.gridwidth = 2;
        layoutCons.weightx = 0.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(label, layoutCons);
        contentPane.add(label);
        layoutCons.gridx = 0;
        layoutCons.gridy = 9;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 0.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(this.tfThreshold, layoutCons);
        contentPane.add(this.tfThreshold);
        label = new JLabel(I18n.tr((String)"meters", (Object[])new Object[0]));
        layoutCons.gridx = 1;
        layoutCons.gridy = 9;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 0.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(label, layoutCons);
        contentPane.add(label);
        JButton bSuggestStops = new JButton(I18n.tr((String)"Suggest Stops", (Object[])new Object[0]));
        bSuggestStops.setActionCommand("stopImporter.settingsSuggestStops");
        bSuggestStops.addActionListener((ActionListener)((Object)controller));
        layoutCons.gridx = 0;
        layoutCons.gridy = 10;
        layoutCons.gridwidth = 3;
        layoutCons.weightx = 1.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(bSuggestStops, layoutCons);
        contentPane.add(bSuggestStops);
        contentPane = tabStops;
        gridbag = new GridBagLayout();
        layoutCons = new GridBagConstraints();
        contentPane.setLayout(gridbag);
        contentPane.getInputMap(1).put(KeyStroke.getKeyStroke("alt N"), "stopImporter.focusName");
        contentPane.getActionMap().put("stopImporter.focusName", controller.getFocusTrackStoplistNameAction());
        contentPane.getInputMap(1).put(KeyStroke.getKeyStroke("alt S"), "stopImporter.focusShelterYes");
        contentPane.getActionMap().put("stopImporter.focusShelterYes", controller.getFocusTrackStoplistShelterAction("yes"));
        contentPane.getInputMap(1).put(KeyStroke.getKeyStroke("alt T"), "stopImporter.focusShelterNo");
        contentPane.getActionMap().put("stopImporter.focusShelterNo", controller.getFocusTrackStoplistShelterAction("no"));
        contentPane.getInputMap(1).put(KeyStroke.getKeyStroke("alt U"), "stopImporter.focusShelterImplicit");
        contentPane.getActionMap().put("stopImporter.focusShelterImplicit", controller.getFocusTrackStoplistShelterAction("implicit"));
        contentPane.getInputMap(1).put(KeyStroke.getKeyStroke("alt D"), "stopImporter.stoplistDelete");
        contentPane.getActionMap().put("stopImporter.stoplistDelete", controller.getFocusStoplistDeleteAction());
        JScrollPane tableSP = new JScrollPane(this.stoplistTable);
        layoutCons.gridx = 0;
        layoutCons.gridy = 0;
        layoutCons.gridwidth = 4;
        layoutCons.weightx = 1.0;
        layoutCons.weighty = 1.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(tableSP, layoutCons);
        contentPane.add(tableSP);
        JButton bFind = new JButton(I18n.tr((String)"Find", (Object[])new Object[0]));
        bFind.setActionCommand("stopImporter.stoplistFind");
        bFind.addActionListener((ActionListener)((Object)controller));
        layoutCons.gridx = 0;
        layoutCons.gridy = 1;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 1.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(bFind, layoutCons);
        contentPane.add(bFind);
        JButton bShow = new JButton(I18n.tr((String)"Show", (Object[])new Object[0]));
        bShow.setActionCommand("stopImporter.stoplistShow");
        bShow.addActionListener((ActionListener)((Object)controller));
        layoutCons.gridx = 0;
        layoutCons.gridy = 2;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 1.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(bShow, layoutCons);
        contentPane.add(bShow);
        JButton bMark = new JButton(I18n.tr((String)"Mark", (Object[])new Object[0]));
        bMark.setActionCommand("stopImporter.stoplistMark");
        bMark.addActionListener((ActionListener)((Object)controller));
        layoutCons.gridx = 1;
        layoutCons.gridy = 1;
        layoutCons.gridheight = 1;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 1.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(bMark, layoutCons);
        contentPane.add(bMark);
        JButton bDetach = new JButton(I18n.tr((String)"Detach", (Object[])new Object[0]));
        bDetach.setActionCommand("stopImporter.stoplistDetach");
        bDetach.addActionListener((ActionListener)((Object)controller));
        layoutCons.gridx = 1;
        layoutCons.gridy = 2;
        layoutCons.gridheight = 1;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 1.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(bDetach, layoutCons);
        contentPane.add(bDetach);
        JButton bAdd = new JButton(I18n.tr((String)"Add", (Object[])new Object[0]));
        bAdd.setActionCommand("stopImporter.stoplistAdd");
        bAdd.addActionListener((ActionListener)((Object)controller));
        layoutCons.gridx = 2;
        layoutCons.gridy = 1;
        layoutCons.gridheight = 1;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 1.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(bAdd, layoutCons);
        contentPane.add(bAdd);
        JButton bDelete = new JButton(I18n.tr((String)"Delete", (Object[])new Object[0]));
        bDelete.setActionCommand("stopImporter.stoplistDelete");
        bDelete.addActionListener((ActionListener)((Object)controller));
        layoutCons.gridx = 2;
        layoutCons.gridy = 2;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 1.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(bDelete, layoutCons);
        contentPane.add(bDelete);
        JButton bSort = new JButton(I18n.tr((String)"Sort", (Object[])new Object[0]));
        bSort.setActionCommand("stopImporter.stoplistSort");
        bSort.addActionListener((ActionListener)((Object)controller));
        layoutCons.gridx = 3;
        layoutCons.gridy = 1;
        layoutCons.gridheight = 2;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 1.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(bSort, layoutCons);
        contentPane.add(bSort);
        contentPane = tabWaypoints;
        gridbag = new GridBagLayout();
        layoutCons = new GridBagConstraints();
        contentPane.setLayout(gridbag);
        contentPane.getInputMap(1).put(KeyStroke.getKeyStroke("alt N"), "stopImporter.focusName");
        contentPane.getActionMap().put("stopImporter.focusName", controller.getFocusWaypointNameAction());
        contentPane.getInputMap(1).put(KeyStroke.getKeyStroke("alt S"), "stopImporter.focusShelterYes");
        contentPane.getActionMap().put("stopImporter.focusShelterYes", controller.getFocusWaypointShelterAction("yes"));
        contentPane.getInputMap(1).put(KeyStroke.getKeyStroke("alt T"), "stopImporter.focusShelterNo");
        contentPane.getActionMap().put("stopImporter.focusShelterNo", controller.getFocusWaypointShelterAction("no"));
        contentPane.getInputMap(1).put(KeyStroke.getKeyStroke("alt U"), "stopImporter.focusShelterImplicit");
        contentPane.getActionMap().put("stopImporter.focusShelterImplicit", controller.getFocusWaypointShelterAction("implicit"));
        contentPane.getInputMap(1).put(KeyStroke.getKeyStroke("alt D"), "stopImporter.waypointsDelete");
        contentPane.getActionMap().put("stopImporter.waypointsDelete", controller.getFocusWaypointDeleteAction());
        tableSP = new JScrollPane(this.waypointTable);
        layoutCons.gridx = 0;
        layoutCons.gridy = 0;
        layoutCons.gridwidth = 3;
        layoutCons.weightx = 1.0;
        layoutCons.weighty = 1.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(tableSP, layoutCons);
        contentPane.add(tableSP);
        bFind = new JButton(I18n.tr((String)"Find", (Object[])new Object[0]));
        bFind.setActionCommand("stopImporter.waypointsFind");
        bFind.addActionListener((ActionListener)((Object)controller));
        layoutCons.gridx = 0;
        layoutCons.gridy = 1;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 1.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(bFind, layoutCons);
        contentPane.add(bFind);
        bShow = new JButton(I18n.tr((String)"Show", (Object[])new Object[0]));
        bShow.setActionCommand("stopImporter.waypointsShow");
        bShow.addActionListener((ActionListener)((Object)controller));
        layoutCons.gridx = 0;
        layoutCons.gridy = 2;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 1.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(bShow, layoutCons);
        contentPane.add(bShow);
        bMark = new JButton(I18n.tr((String)"Mark", (Object[])new Object[0]));
        bMark.setActionCommand("stopImporter.waypointsMark");
        bMark.addActionListener((ActionListener)((Object)controller));
        layoutCons.gridx = 1;
        layoutCons.gridy = 1;
        layoutCons.gridheight = 1;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 1.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(bMark, layoutCons);
        contentPane.add(bMark);
        bDetach = new JButton(I18n.tr((String)"Detach", (Object[])new Object[0]));
        bDetach.setActionCommand("stopImporter.waypointsDetach");
        bDetach.addActionListener((ActionListener)((Object)controller));
        layoutCons.gridx = 1;
        layoutCons.gridy = 2;
        layoutCons.gridheight = 1;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 1.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(bDetach, layoutCons);
        contentPane.add(bDetach);
        bAdd = new JButton(I18n.tr((String)"Enable", (Object[])new Object[0]));
        bAdd.setActionCommand("stopImporter.waypointsAdd");
        bAdd.addActionListener((ActionListener)((Object)controller));
        layoutCons.gridx = 2;
        layoutCons.gridy = 1;
        layoutCons.gridheight = 1;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 1.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(bAdd, layoutCons);
        contentPane.add(bAdd);
        bDelete = new JButton(I18n.tr((String)"Disable", (Object[])new Object[0]));
        bDelete.setActionCommand("stopImporter.waypointsDelete");
        bDelete.addActionListener((ActionListener)((Object)controller));
        layoutCons.gridx = 2;
        layoutCons.gridy = 2;
        layoutCons.gridwidth = 1;
        layoutCons.weightx = 1.0;
        layoutCons.weighty = 0.0;
        layoutCons.fill = 1;
        gridbag.setConstraints(bDelete, layoutCons);
        contentPane.add(bDelete);
    }

    public JTable getStoplistTable() {
        return this.stoplistTable;
    }

    public void setStoplistTableModel(TrackStoplistTableModel model) {
        this.stoplistTable.setModel(model);
        JComboBox<TransText> comboBox = new JComboBox<TransText>();
        comboBox.addItem(new TransText(null));
        comboBox.addItem(new TransText(I18n.marktr((String)"yes")));
        comboBox.addItem(new TransText(I18n.marktr((String)"no")));
        comboBox.addItem(new TransText(I18n.marktr((String)"implicit")));
        this.stoplistTable.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(comboBox));
        int width = this.stoplistTable.getPreferredSize().width;
        this.stoplistTable.getColumnModel().getColumn(0).setPreferredWidth((int)((double)width * 0.4));
        this.stoplistTable.getColumnModel().getColumn(1).setPreferredWidth((int)((double)width * 0.5));
        this.stoplistTable.getColumnModel().getColumn(2).setPreferredWidth((int)((double)width * 0.1));
    }

    public JTable getWaypointsTable() {
        return this.waypointTable;
    }

    public void setWaypointsTableModel(WaypointTableModel model) {
        this.waypointTable.setModel(model);
        JComboBox<TransText> comboBox = new JComboBox<TransText>();
        comboBox.addItem(new TransText(null));
        comboBox.addItem(new TransText(I18n.marktr((String)"yes")));
        comboBox.addItem(new TransText(I18n.marktr((String)"no")));
        comboBox.addItem(new TransText(I18n.marktr((String)"implicit")));
        this.waypointTable.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(comboBox));
        int width = this.waypointTable.getPreferredSize().width;
        this.waypointTable.getColumnModel().getColumn(0).setPreferredWidth((int)((double)width * 0.4));
        this.waypointTable.getColumnModel().getColumn(1).setPreferredWidth((int)((double)width * 0.5));
        this.waypointTable.getColumnModel().getColumn(2).setPreferredWidth((int)((double)width * 0.1));
    }

    private class TracksLSL
    implements ListSelectionListener {
        StopImporterAction root = null;

        TracksLSL(StopImporterAction sia) {
            this.root = sia;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int selectedPos = StopImporterDialog.this.tracksList.getAnchorSelectionIndex();
            if (StopImporterDialog.this.tracksList.isSelectedIndex(selectedPos)) {
                this.root.tracksSelectionChanged(selectedPos);
            } else {
                this.root.tracksSelectionChanged(-1);
            }
        }
    }
}

