/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.embedded.x;

import java.awt.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.player.embedded.FullScreenStrategy;
import uk.co.caprica.vlcj.runtime.x.LibXUtil;

public class XFullScreenStrategy
implements FullScreenStrategy {
    private final Logger logger = LoggerFactory.getLogger(XFullScreenStrategy.class);
    private final Window window;
    private boolean isFullScreenMode;

    public XFullScreenStrategy(Window window) {
        this.logger.debug("DefaultFullScreenStrategy(window={})", (Object)window);
        if (window == null) {
            throw new IllegalArgumentException("Window must not be null");
        }
        this.window = window;
    }

    @Override
    public final void enterFullScreenMode() {
        this.logger.debug("enterFullScreenMode()");
        this.onBeforeEnterFullScreenMode();
        LibXUtil.setFullScreenWindow(this.window, true);
        this.isFullScreenMode = true;
    }

    @Override
    public final void exitFullScreenMode() {
        this.logger.debug("exitFullScreenMode()");
        LibXUtil.setFullScreenWindow(this.window, false);
        this.isFullScreenMode = false;
        this.onAfterExitFullScreenMode();
    }

    @Override
    public final boolean isFullScreenMode() {
        this.logger.debug("isFullScreenMode()");
        return this.isFullScreenMode;
    }

    protected void onBeforeEnterFullScreenMode() {
    }

    protected void onAfterExitFullScreenMode() {
    }
}

