/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.embedded.windows;

import java.awt.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.player.embedded.FullScreenStrategy;
import uk.co.caprica.vlcj.player.embedded.windows.Win32FullScreenHandler;

public class Win32FullScreenStrategy
implements FullScreenStrategy {
    private final Logger logger = LoggerFactory.getLogger(Win32FullScreenStrategy.class);
    private final Win32FullScreenHandler handler;
    private boolean isFullScreenMode;

    public Win32FullScreenStrategy(Window window) {
        if (window == null) {
            throw new IllegalArgumentException("Window must not be null");
        }
        this.handler = new Win32FullScreenHandler(window);
    }

    @Override
    public final void enterFullScreenMode() {
        this.logger.debug("enterFullScreenMode()");
        if (!this.isFullScreenMode) {
            this.onBeforeEnterFullScreenMode();
            this.handler.setFullScreen(true);
            this.isFullScreenMode = true;
        }
    }

    @Override
    public final void exitFullScreenMode() {
        this.logger.debug("exitFullScreenMode()");
        if (this.isFullScreenMode) {
            this.handler.setFullScreen(false);
            this.isFullScreenMode = false;
            this.onAfterExitFullScreenMode();
        }
    }

    @Override
    public final boolean isFullScreenMode() {
        this.logger.debug("isFullScreenMode()");
        return this.isFullScreenMode;
    }

    protected void onBeforeEnterFullScreenMode() {
    }

    protected void onAfterExitFullScreenMode() {
    }
}

