/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player;

import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_audio_output_device_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_audio_track_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_callback_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_chapter_description_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_equalizer_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_manager_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_event_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_logo_position_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_marquee_position_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_list_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_parse_flag_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_player_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_stats_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_track_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_type_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_navigate_mode_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_position_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_state_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_subtitle_track_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_title_description_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_track_description_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_track_type_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_adjust_option_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_logo_option_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_marquee_option_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_video_track_t;
import uk.co.caprica.vlcj.medialist.MediaList;
import uk.co.caprica.vlcj.player.AbstractMediaPlayer;
import uk.co.caprica.vlcj.player.AudioDevice;
import uk.co.caprica.vlcj.player.AudioTrackInfo;
import uk.co.caprica.vlcj.player.ChapterDescription;
import uk.co.caprica.vlcj.player.DefaultMediaMeta;
import uk.co.caprica.vlcj.player.DeinterlaceMode;
import uk.co.caprica.vlcj.player.Equalizer;
import uk.co.caprica.vlcj.player.EqualizerListener;
import uk.co.caprica.vlcj.player.LibVlcMediaListIterator;
import uk.co.caprica.vlcj.player.Logo;
import uk.co.caprica.vlcj.player.Marquee;
import uk.co.caprica.vlcj.player.MediaDetails;
import uk.co.caprica.vlcj.player.MediaMeta;
import uk.co.caprica.vlcj.player.MediaMetaData;
import uk.co.caprica.vlcj.player.MediaPlayer;
import uk.co.caprica.vlcj.player.MediaPlayerEventAdapter;
import uk.co.caprica.vlcj.player.MediaPlayerEventListener;
import uk.co.caprica.vlcj.player.MediaPlayerLatch;
import uk.co.caprica.vlcj.player.MediaResourceLocator;
import uk.co.caprica.vlcj.player.NativeString;
import uk.co.caprica.vlcj.player.TextTrackInfo;
import uk.co.caprica.vlcj.player.TitleDescription;
import uk.co.caprica.vlcj.player.TrackDescription;
import uk.co.caprica.vlcj.player.TrackInfo;
import uk.co.caprica.vlcj.player.TrackType;
import uk.co.caprica.vlcj.player.UnknownTrackInfo;
import uk.co.caprica.vlcj.player.VideoTrackInfo;
import uk.co.caprica.vlcj.player.WaitForSnapshot;
import uk.co.caprica.vlcj.player.condition.BeforeConditionAbortedException;
import uk.co.caprica.vlcj.player.events.MediaPlayerEvent;
import uk.co.caprica.vlcj.player.events.MediaPlayerEventFactory;
import uk.co.caprica.vlcj.player.events.MediaPlayerEventType;
import uk.co.caprica.vlcj.player.media.Media;
import uk.co.caprica.vlcj.player.media.callback.CallbackMedia;
import uk.co.caprica.vlcj.player.media.simple.SimpleMedia;
import uk.co.caprica.vlcj.version.LibVlcVersion;
import uk.co.caprica.vlcj.version.Version;

public abstract class DefaultMediaPlayer
extends AbstractMediaPlayer
implements MediaPlayer,
EqualizerListener {
    private final Logger logger = LoggerFactory.getLogger(DefaultMediaPlayer.class);
    private final CopyOnWriteArrayList<MediaPlayerEventListener> eventListenerList = new CopyOnWriteArrayList();
    private final MediaPlayerEventFactory eventFactory = new MediaPlayerEventFactory(this);
    private final ExecutorService listenersService = Executors.newSingleThreadExecutor();
    private libvlc_media_player_t mediaPlayerInstance;
    private libvlc_event_manager_t mediaPlayerEventManager;
    private libvlc_callback_t callback;
    private libvlc_media_t mediaInstance;
    private long eventMask = MediaPlayerEventType.ALL.value();
    private String[] standardMediaOptions;
    private libvlc_media_stats_t libvlcMediaStats;
    private boolean repeat;
    private boolean playSubItems;
    private int subItemIndex;
    private String snapshotDirectoryName;
    private Equalizer equalizer;
    private libvlc_equalizer_t equalizerInstance;
    private Object userData;
    private final AtomicBoolean released = new AtomicBoolean();
    private Media lastPlayedMedia;

    public DefaultMediaPlayer(LibVlc libvlc, libvlc_instance_t instance) {
        super(libvlc, instance);
        this.logger.debug("DefaultMediaPlayer(libvlc={}, instance={})", (Object)libvlc, (Object)instance);
        this.createInstance();
    }

    @Override
    public void addMediaPlayerEventListener(MediaPlayerEventListener listener) {
        this.logger.debug("addMediaPlayerEventListener(listener={})", (Object)listener);
        if (listener == null) {
            throw new IllegalArgumentException("listener can not be null");
        }
        this.eventListenerList.add(listener);
    }

    @Override
    public void removeMediaPlayerEventListener(MediaPlayerEventListener listener) {
        this.logger.debug("removeMediaPlayerEventListener(listener={})", (Object)listener);
        if (listener == null) {
            throw new IllegalArgumentException("listener can not be null");
        }
        this.eventListenerList.remove(listener);
    }

    @Override
    public void enableEvents(long eventMask) {
        this.logger.debug("enableEvents(eventMask={})", (Object)eventMask);
        this.eventMask = eventMask;
    }

    @Override
    public void setStandardMediaOptions(String ... options) {
        this.logger.debug("setStandardMediaOptions(options={})", (Object)Arrays.toString(options));
        this.standardMediaOptions = options;
    }

    @Override
    public boolean playMedia(String mrl, String ... mediaOptions) {
        this.logger.debug("playMedia(mrl={},mediaOptions={})", (Object)mrl, (Object)Arrays.toString(mediaOptions));
        return this.playMedia(new SimpleMedia(mrl, mediaOptions));
    }

    @Override
    public boolean playMedia(Media media) {
        this.logger.debug("playMedia(media={})", (Object)media);
        if (this.prepareMedia(media)) {
            this.play();
            return true;
        }
        return false;
    }

    @Override
    public boolean prepareMedia(String mrl, String ... mediaOptions) {
        this.logger.debug("prepareMedia(mrl={},mediaOptions={})", (Object)mrl, (Object)Arrays.toString(mediaOptions));
        return this.prepareMedia(new SimpleMedia(mrl, mediaOptions));
    }

    @Override
    public boolean prepareMedia(Media media) {
        this.logger.debug("prepareMedia(media={})", (Object)media);
        return this.setMedia(media);
    }

    @Override
    public boolean startMedia(String mrl, String ... mediaOptions) {
        this.logger.debug("startMedia(mrl={}, mediaOptions={})", (Object)mrl, (Object)Arrays.toString(mediaOptions));
        return this.startMedia(new SimpleMedia(mrl, mediaOptions));
    }

    @Override
    public boolean startMedia(Media media) {
        this.logger.debug("startMedia(media={})", (Object)media);
        if (this.prepareMedia(media)) {
            return new MediaPlayerLatch(this).play();
        }
        return false;
    }

    @Override
    public void parseMedia() {
        this.logger.debug("parseMedia()");
        if (this.mediaInstance == null) {
            throw new IllegalStateException("No media");
        }
        this.libvlc.libvlc_media_parse(this.mediaInstance);
    }

    @Override
    public void requestParseMedia() {
        this.logger.debug("requestParseMedia()");
        if (this.mediaInstance == null) {
            throw new IllegalStateException("No media");
        }
        this.libvlc.libvlc_media_parse_async(this.mediaInstance);
    }

    @Override
    public boolean requestParseMediaWithOptions(libvlc_media_parse_flag_t ... options) {
        this.logger.debug("requestParseMediaWithOptions(options={})", (Object)(options != null ? Arrays.toString((Object[])options) : ""));
        if (LibVlcVersion.getVersion().atLeast(LibVlcVersion.LIBVLC_300)) {
            int flags = 0;
            for (libvlc_media_parse_flag_t option : options) {
                flags |= option.intValue();
            }
            return this.libvlc.libvlc_media_parse_with_options(this.mediaInstance, flags) == 0;
        }
        return false;
    }

    @Override
    public boolean isMediaParsed() {
        this.logger.debug("isMediaParsed()");
        if (this.mediaInstance != null) {
            return 0 != this.libvlc.libvlc_media_is_parsed(this.mediaInstance);
        }
        throw new IllegalStateException("No media");
    }

    @Override
    public MediaMeta getMediaMeta() {
        this.logger.debug("getMediaMeta()");
        return this.getMediaMeta(this.mediaInstance);
    }

    @Override
    public MediaMeta getMediaMeta(libvlc_media_t media) {
        this.logger.debug("getMediaMeta(media={})", (Object)media);
        if (media != null) {
            return new DefaultMediaMeta(this.libvlc, media);
        }
        throw new IllegalStateException("No media");
    }

    @Override
    public List<MediaMeta> getSubItemMediaMeta() {
        this.logger.debug("getSubItemMediaMeta()");
        return this.handleSubItems(new SubItemsHandler<List<MediaMeta>>(){

            @Override
            public List<MediaMeta> subItems(int count, libvlc_media_list_t subItems) {
                ArrayList<MediaMeta> result = new ArrayList<MediaMeta>(count);
                for (libvlc_media_t subItem : new LibVlcMediaListIterator(DefaultMediaPlayer.this.libvlc, subItems)) {
                    result.add(DefaultMediaPlayer.this.getMediaMeta(subItem));
                }
                return result;
            }
        });
    }

    @Override
    public MediaMetaData getMediaMetaData() {
        this.logger.debug("getMediaMetaData()");
        return this.getMediaMeta().asMediaMetaData();
    }

    @Override
    public List<MediaMetaData> getSubItemMediaMetaData() {
        ArrayList<MediaMetaData> result;
        this.logger.debug("getSubItemMediaMetaData()");
        List<MediaMeta> metas = this.getSubItemMediaMeta();
        if (metas != null) {
            result = new ArrayList<MediaMetaData>(metas.size());
            for (MediaMeta meta : this.getSubItemMediaMeta()) {
                result.add(meta.asMediaMetaData());
            }
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public void addMediaOptions(String ... mediaOptions) {
        this.logger.debug("addMediaOptions(mediaOptions={})", (Object)Arrays.toString(mediaOptions));
        if (this.mediaInstance != null) {
            for (String mediaOption : mediaOptions) {
                this.logger.debug("mediaOption={}", (Object)mediaOption);
                this.libvlc.libvlc_media_add_option(this.mediaInstance, mediaOption);
            }
        } else {
            throw new IllegalStateException("No media");
        }
    }

    @Override
    public void setRepeat(boolean repeat) {
        this.logger.debug("setRepeat(repeat={})", (Object)repeat);
        this.repeat = repeat;
    }

    @Override
    public boolean getRepeat() {
        this.logger.debug("getRepeat()");
        return this.repeat;
    }

    @Override
    public void setPlaySubItems(boolean playSubItems) {
        this.logger.debug("setPlaySubItems(playSubItems={})", (Object)playSubItems);
        this.playSubItems = playSubItems;
    }

    @Override
    public int subItemCount() {
        this.logger.debug("subItemCount()");
        return this.handleSubItems(new SubItemsHandler<Integer>(){

            @Override
            public Integer subItems(int count, libvlc_media_list_t subItems) {
                return count;
            }
        });
    }

    @Override
    public int subItemIndex() {
        return this.subItemIndex;
    }

    @Override
    public List<String> subItems() {
        this.logger.debug("subItems()");
        return this.handleSubItems(new SubItemsHandler<List<String>>(){

            @Override
            public List<String> subItems(int count, libvlc_media_list_t subItems) {
                ArrayList<String> result = new ArrayList<String>(count);
                for (libvlc_media_t subItem : new LibVlcMediaListIterator(DefaultMediaPlayer.this.libvlc, subItems)) {
                    result.add(NativeString.getNativeString(DefaultMediaPlayer.this.libvlc, DefaultMediaPlayer.this.libvlc.libvlc_media_get_mrl(subItem)));
                }
                return result;
            }
        });
    }

    @Override
    public List<libvlc_media_t> subItemsMedia() {
        this.logger.debug("subItemsMedia()");
        return this.handleSubItems(new SubItemsHandler<List<libvlc_media_t>>(){

            @Override
            public List<libvlc_media_t> subItems(int count, libvlc_media_list_t subItems) {
                ArrayList<libvlc_media_t> result = new ArrayList<libvlc_media_t>(count);
                for (libvlc_media_t subItem : new LibVlcMediaListIterator(DefaultMediaPlayer.this.libvlc, subItems)) {
                    result.add(subItem);
                }
                return result;
            }
        });
    }

    @Override
    public MediaList subItemsMediaList() {
        MediaList result;
        this.logger.debug("subItemsMediaList()");
        if (this.mediaInstance != null) {
            libvlc_media_list_t mediaListInstance = this.libvlc.libvlc_media_subitems(this.mediaInstance);
            result = new MediaList(this.libvlc, this.instance, mediaListInstance);
            this.libvlc.libvlc_media_list_release(mediaListInstance);
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public boolean playNextSubItem(String ... mediaOptions) {
        this.logger.debug("playNextSubItem(mediaOptions={})", (Object)Arrays.toString(mediaOptions));
        return this.playSubItem(this.subItemIndex + 1, mediaOptions);
    }

    @Override
    public boolean playSubItem(final int index, final String ... mediaOptions) {
        this.logger.debug("playSubItem(index={},mediaOptions={})", (Object)index, (Object)Arrays.toString(mediaOptions));
        return this.handleSubItems(new SubItemsHandler<Boolean>(){

            @Override
            public Boolean subItems(int count, libvlc_media_list_t subItems) {
                if (subItems != null) {
                    DefaultMediaPlayer.this.logger.debug("Handling media sub-item...");
                    DefaultMediaPlayer.this.logger.debug("count={}", (Object)count);
                    DefaultMediaPlayer.this.subItemIndex = index;
                    DefaultMediaPlayer.this.logger.debug("subItemIndex={}", (Object)DefaultMediaPlayer.this.subItemIndex);
                    if (DefaultMediaPlayer.this.subItemIndex >= count) {
                        DefaultMediaPlayer.this.logger.debug("End of sub-items reached");
                        if (!DefaultMediaPlayer.this.repeat) {
                            DefaultMediaPlayer.this.logger.debug("Do not repeat sub-items");
                            DefaultMediaPlayer.this.subItemIndex = -1;
                            DefaultMediaPlayer.this.logger.debug("Raising events for end of sub-items");
                            DefaultMediaPlayer.this.raiseEvent(DefaultMediaPlayer.this.eventFactory.createMediaEndOfSubItemsEvent(DefaultMediaPlayer.this.eventMask));
                        } else {
                            DefaultMediaPlayer.this.logger.debug("Repeating sub-items");
                            DefaultMediaPlayer.this.subItemIndex = 0;
                        }
                    }
                    if (DefaultMediaPlayer.this.subItemIndex != -1) {
                        libvlc_media_t subItem = DefaultMediaPlayer.this.libvlc.libvlc_media_list_item_at_index(subItems, DefaultMediaPlayer.this.subItemIndex);
                        DefaultMediaPlayer.this.logger.debug("subItem={}", (Object)subItem);
                        if (subItem != null) {
                            DefaultMediaPlayer.this.logger.debug("subItemMrl={}", (Object)DefaultMediaPlayer.this.mrl(subItem));
                            DefaultMediaPlayer.this.libvlc.libvlc_media_player_set_media(DefaultMediaPlayer.this.mediaPlayerInstance, subItem);
                            if (DefaultMediaPlayer.this.standardMediaOptions != null) {
                                for (String standardMediaOption : DefaultMediaPlayer.this.standardMediaOptions) {
                                    DefaultMediaPlayer.this.logger.debug("standardMediaOption={}", (Object)standardMediaOption);
                                    DefaultMediaPlayer.this.libvlc.libvlc_media_add_option(subItem, standardMediaOption);
                                }
                            }
                            if (mediaOptions != null) {
                                for (String mediaOption : mediaOptions) {
                                    DefaultMediaPlayer.this.logger.debug("mediaOption={}", (Object)mediaOption);
                                    DefaultMediaPlayer.this.libvlc.libvlc_media_add_option(subItem, mediaOption);
                                }
                            }
                            DefaultMediaPlayer.this.libvlc.libvlc_media_player_play(DefaultMediaPlayer.this.mediaPlayerInstance);
                            DefaultMediaPlayer.this.libvlc.libvlc_media_release(subItem);
                            DefaultMediaPlayer.this.logger.debug("Raising played event for sub-item {}", (Object)DefaultMediaPlayer.this.subItemIndex);
                            DefaultMediaPlayer.this.raiseEvent(DefaultMediaPlayer.this.eventFactory.createMediaSubItemPlayedEvent(DefaultMediaPlayer.this.subItemIndex, DefaultMediaPlayer.this.eventMask));
                            return true;
                        }
                    }
                }
                return false;
            }
        });
    }

    @Override
    public boolean isPlayable() {
        this.logger.trace("isPlayable()");
        return this.libvlc.libvlc_media_player_will_play(this.mediaPlayerInstance) == 1;
    }

    @Override
    public boolean isPlaying() {
        this.logger.trace("isPlaying()");
        return this.libvlc.libvlc_media_player_is_playing(this.mediaPlayerInstance) == 1;
    }

    @Override
    public boolean isSeekable() {
        this.logger.trace("isSeekable()");
        return this.libvlc.libvlc_media_player_is_seekable(this.mediaPlayerInstance) == 1;
    }

    @Override
    public boolean canPause() {
        this.logger.trace("canPause()");
        return this.libvlc.libvlc_media_player_can_pause(this.mediaPlayerInstance) == 1;
    }

    @Override
    public boolean programScrambled() {
        this.logger.trace("programScrambled()");
        return this.libvlc.libvlc_media_player_program_scrambled(this.mediaPlayerInstance) == 1;
    }

    @Override
    public long getLength() {
        this.logger.trace("getLength()");
        return this.libvlc.libvlc_media_player_get_length(this.mediaPlayerInstance);
    }

    @Override
    public long getTime() {
        this.logger.trace("getTime()");
        return this.libvlc.libvlc_media_player_get_time(this.mediaPlayerInstance);
    }

    @Override
    public float getPosition() {
        this.logger.trace("getPosition()");
        return this.libvlc.libvlc_media_player_get_position(this.mediaPlayerInstance);
    }

    @Override
    public float getFps() {
        this.logger.trace("getFps()");
        return this.libvlc.libvlc_media_player_get_fps(this.mediaPlayerInstance);
    }

    @Override
    public float getRate() {
        this.logger.trace("getRate()");
        return this.libvlc.libvlc_media_player_get_rate(this.mediaPlayerInstance);
    }

    @Override
    public int getVideoOutputs() {
        this.logger.trace("getVideoOutputs()");
        return this.libvlc.libvlc_media_player_has_vout(this.mediaPlayerInstance);
    }

    @Override
    public Dimension getVideoDimension() {
        this.logger.debug("getVideoDimension()");
        if (this.getVideoOutputs() > 0) {
            IntByReference px = new IntByReference();
            IntByReference py = new IntByReference();
            int result = this.libvlc.libvlc_video_get_size(this.mediaPlayerInstance, 0, px, py);
            if (result == 0) {
                return new Dimension(px.getValue(), py.getValue());
            }
            this.logger.warn("Video size is not available");
            return null;
        }
        this.logger.warn("Can't get video dimension if no video output has been started");
        return null;
    }

    @Override
    public MediaDetails getMediaDetails() {
        this.logger.debug("getMediaDetails()");
        if (this.isPlaying()) {
            MediaDetails mediaDetails = new MediaDetails();
            mediaDetails.setTitleCount(this.getTitleCount());
            mediaDetails.setVideoTrackCount(this.getVideoTrackCount());
            mediaDetails.setAudioTrackCount(this.getAudioTrackCount());
            mediaDetails.setSpuCount(this.getSpuCount());
            mediaDetails.setTitleDescriptions(this.getTitleDescriptions());
            mediaDetails.setVideoDescriptions(this.getVideoDescriptions());
            mediaDetails.setAudioDescriptions(this.getAudioDescriptions());
            mediaDetails.setSpuDescriptions(this.getSpuDescriptions());
            mediaDetails.setChapterDescriptions(this.getAllChapterDescriptions());
            return mediaDetails;
        }
        this.logger.warn("Can't get media meta data if media is not playing");
        return null;
    }

    @Override
    public String getAspectRatio() {
        this.logger.debug("getAspectRatio()");
        return NativeString.getNativeString(this.libvlc, this.libvlc.libvlc_video_get_aspect_ratio(this.mediaPlayerInstance));
    }

    @Override
    public float getScale() {
        this.logger.debug("getScale()");
        return this.libvlc.libvlc_video_get_scale(this.mediaPlayerInstance);
    }

    @Override
    public String getCropGeometry() {
        this.logger.debug("getCropGeometry()");
        return NativeString.getNativeString(this.libvlc, this.libvlc.libvlc_video_get_crop_geometry(this.mediaPlayerInstance));
    }

    @Override
    public libvlc_media_stats_t getMediaStatistics() {
        this.logger.trace("getMediaStatistics()");
        return this.getMediaStatistics(this.mediaInstance);
    }

    @Override
    public libvlc_media_stats_t getMediaStatistics(libvlc_media_t media) {
        this.logger.trace("getMediaStatistics(media={})", (Object)media);
        if (this.isPlaying() && media != null) {
            this.libvlc.libvlc_media_get_stats(media, this.libvlcMediaStats);
        }
        return this.libvlcMediaStats;
    }

    @Override
    public libvlc_state_t getMediaState() {
        this.logger.debug("getMediaState()");
        libvlc_state_t state = null;
        if (this.mediaInstance != null) {
            state = libvlc_state_t.state(this.libvlc.libvlc_media_get_state(this.mediaInstance));
        }
        return state;
    }

    @Override
    public libvlc_state_t getMediaPlayerState() {
        this.logger.debug("getMediaPlayerState()");
        return libvlc_state_t.state(this.libvlc.libvlc_media_player_get_state(this.mediaPlayerInstance));
    }

    @Override
    public int getTitleCount() {
        this.logger.debug("getTitleCount()");
        return this.libvlc.libvlc_media_player_get_title_count(this.mediaPlayerInstance);
    }

    @Override
    public int getTitle() {
        this.logger.debug("getTitle()");
        return this.libvlc.libvlc_media_player_get_title(this.mediaPlayerInstance);
    }

    @Override
    public void setTitle(int title) {
        this.logger.debug("setTitle(title={})", (Object)title);
        this.libvlc.libvlc_media_player_set_title(this.mediaPlayerInstance, title);
    }

    @Override
    public int getVideoTrackCount() {
        this.logger.debug("getVideoTrackCount()");
        return this.libvlc.libvlc_video_get_track_count(this.mediaPlayerInstance);
    }

    @Override
    public int getVideoTrack() {
        this.logger.debug("getVideoTrack()");
        return this.libvlc.libvlc_video_get_track(this.mediaPlayerInstance);
    }

    @Override
    public int setVideoTrack(int track) {
        this.logger.debug("setVideoTrack(track={})", (Object)track);
        this.libvlc.libvlc_video_set_track(this.mediaPlayerInstance, track);
        return this.getVideoTrack();
    }

    @Override
    public int getAudioTrackCount() {
        this.logger.debug("getVideoTrackCount()");
        return this.libvlc.libvlc_audio_get_track_count(this.mediaPlayerInstance);
    }

    @Override
    public int getAudioTrack() {
        this.logger.debug("getAudioTrack()");
        return this.libvlc.libvlc_audio_get_track(this.mediaPlayerInstance);
    }

    @Override
    public int setAudioTrack(int track) {
        this.logger.debug("setAudioTrack(track={})", (Object)track);
        this.libvlc.libvlc_audio_set_track(this.mediaPlayerInstance, track);
        return this.getAudioTrack();
    }

    @Override
    public void play() {
        this.logger.debug("play()");
        this.onBeforePlay();
        this.libvlc.libvlc_media_player_play(this.mediaPlayerInstance);
        this.logger.debug("after play");
    }

    @Override
    public boolean start() {
        return new MediaPlayerLatch(this).play();
    }

    @Override
    public void stop() {
        this.logger.debug("stop()");
        this.libvlc.libvlc_media_player_stop(this.mediaPlayerInstance);
    }

    @Override
    public void setPause(boolean pause) {
        this.logger.debug("setPause(pause={})", (Object)pause);
        this.libvlc.libvlc_media_player_set_pause(this.mediaPlayerInstance, pause ? 1 : 0);
    }

    @Override
    public void pause() {
        this.logger.debug("pause()");
        this.libvlc.libvlc_media_player_pause(this.mediaPlayerInstance);
    }

    @Override
    public void nextFrame() {
        this.logger.debug("nextFrame()");
        this.libvlc.libvlc_media_player_next_frame(this.mediaPlayerInstance);
    }

    @Override
    public void skip(long delta) {
        this.logger.debug("skip(delta={})", (Object)delta);
        long current = this.getTime();
        this.logger.debug("current={}", (Object)current);
        if (current != -1L) {
            this.setTime(current + delta);
        }
    }

    @Override
    public void skipPosition(float delta) {
        this.logger.debug("skipPosition(delta={})", (Object)Float.valueOf(delta));
        float current = this.getPosition();
        this.logger.debug("current={}", (Object)Float.valueOf(current));
        if (current != -1.0f) {
            this.setPosition(current + delta);
        }
    }

    @Override
    public void setTime(long time) {
        this.logger.debug("setTime(time={})", (Object)time);
        this.libvlc.libvlc_media_player_set_time(this.mediaPlayerInstance, Math.max(time, 0L));
    }

    @Override
    public void setPosition(float position) {
        this.logger.debug("setPosition(position={})", (Object)Float.valueOf(position));
        this.libvlc.libvlc_media_player_set_position(this.mediaPlayerInstance, Math.max(position, 0.0f));
    }

    @Override
    public int setRate(float rate) {
        this.logger.debug("setRate(rate={})", (Object)Float.valueOf(rate));
        return this.libvlc.libvlc_media_player_set_rate(this.mediaPlayerInstance, rate);
    }

    @Override
    public void setAspectRatio(String aspectRatio) {
        this.logger.debug("setAspectRatio(aspectRatio={})", (Object)aspectRatio);
        this.libvlc.libvlc_video_set_aspect_ratio(this.mediaPlayerInstance, aspectRatio);
    }

    @Override
    public void setScale(float factor) {
        this.logger.debug("setScale(factor={})", (Object)Float.valueOf(factor));
        this.libvlc.libvlc_video_set_scale(this.mediaPlayerInstance, factor);
    }

    @Override
    public void setCropGeometry(String cropGeometry) {
        this.logger.debug("setCropGeometry(cropGeometry={})", (Object)cropGeometry);
        this.libvlc.libvlc_video_set_crop_geometry(this.mediaPlayerInstance, cropGeometry);
    }

    @Override
    public boolean setAudioOutput(String output) {
        this.logger.debug("setAudioOutput(output={})", (Object)output);
        return 0 == this.libvlc.libvlc_audio_output_set(this.mediaPlayerInstance, output);
    }

    @Override
    public void setAudioOutputDevice(String output, String outputDeviceId) {
        this.logger.debug("setAudioOutputDevice(output={},outputDeviceId={})", (Object)output, (Object)outputDeviceId);
        this.libvlc.libvlc_audio_output_device_set(this.mediaPlayerInstance, output, outputDeviceId);
    }

    @Override
    public String getAudioOutputDevice() {
        this.logger.debug("getAudioOutputDevice()");
        if (LibVlcVersion.getVersion().atLeast(LibVlcVersion.LIBVLC_300)) {
            return NativeString.getNativeString(this.libvlc, this.libvlc.libvlc_audio_output_device_get(this.mediaPlayerInstance));
        }
        return null;
    }

    @Override
    public List<AudioDevice> getAudioOutputDevices() {
        this.logger.debug("getAudioOutputDevices()");
        if (LibVlcVersion.getVersion().atLeast(LibVlcVersion.LIBVLC_220)) {
            ArrayList<AudioDevice> result = new ArrayList<AudioDevice>();
            libvlc_audio_output_device_t audioDevices = this.libvlc.libvlc_audio_output_device_enum(this.mediaPlayerInstance);
            if (audioDevices != null) {
                audioDevices.setAutoSynch(false);
                libvlc_audio_output_device_t audioDevice = audioDevices;
                while (audioDevice != null) {
                    String device = NativeString.copyNativeString(this.libvlc, audioDevice.psz_device);
                    String description = NativeString.copyNativeString(this.libvlc, audioDevice.psz_description);
                    result.add(new AudioDevice(device, description));
                    audioDevice = audioDevice.p_next;
                }
                this.libvlc.libvlc_audio_output_device_list_release(audioDevices);
            }
            return result;
        }
        this.logger.warn("Audio output device enumeration requires libvlc 2.2.0 or later");
        return null;
    }

    @Override
    public boolean mute() {
        this.logger.debug("mute()");
        this.libvlc.libvlc_audio_toggle_mute(this.mediaPlayerInstance);
        return this.isMute();
    }

    @Override
    public void mute(boolean mute) {
        this.logger.debug("mute(mute={})", (Object)mute);
        this.libvlc.libvlc_audio_set_mute(this.mediaPlayerInstance, mute ? 1 : 0);
    }

    @Override
    public boolean isMute() {
        this.logger.debug("isMute()");
        return this.libvlc.libvlc_audio_get_mute(this.mediaPlayerInstance) != 0;
    }

    @Override
    public int getVolume() {
        this.logger.debug("getVolume()");
        return this.libvlc.libvlc_audio_get_volume(this.mediaPlayerInstance);
    }

    @Override
    public void setVolume(int volume) {
        this.logger.debug("setVolume(volume={})", (Object)volume);
        this.libvlc.libvlc_audio_set_volume(this.mediaPlayerInstance, volume);
    }

    @Override
    public int getAudioChannel() {
        this.logger.debug("getAudioChannel()");
        return this.libvlc.libvlc_audio_get_channel(this.mediaPlayerInstance);
    }

    @Override
    public void setAudioChannel(int channel) {
        this.logger.debug("setAudioChannel(channel={})", (Object)channel);
        this.libvlc.libvlc_audio_set_channel(this.mediaPlayerInstance, channel);
    }

    @Override
    public long getAudioDelay() {
        this.logger.debug("getAudioDelay()");
        return this.libvlc.libvlc_audio_get_delay(this.mediaPlayerInstance);
    }

    @Override
    public void setAudioDelay(long delay) {
        this.logger.debug("setAudioDelay(delay={})", (Object)delay);
        this.libvlc.libvlc_audio_set_delay(this.mediaPlayerInstance, delay);
    }

    @Override
    public int getChapterCount() {
        this.logger.trace("getChapterCount()");
        return this.libvlc.libvlc_media_player_get_chapter_count(this.mediaPlayerInstance);
    }

    @Override
    public int getChapter() {
        this.logger.trace("getChapter()");
        return this.libvlc.libvlc_media_player_get_chapter(this.mediaPlayerInstance);
    }

    @Override
    public void setChapter(int chapterNumber) {
        this.logger.debug("setChapter(chapterNumber={})", (Object)chapterNumber);
        this.libvlc.libvlc_media_player_set_chapter(this.mediaPlayerInstance, chapterNumber);
    }

    @Override
    public void nextChapter() {
        this.logger.debug("nextChapter()");
        this.libvlc.libvlc_media_player_next_chapter(this.mediaPlayerInstance);
    }

    @Override
    public void previousChapter() {
        this.logger.debug("previousChapter()");
        this.libvlc.libvlc_media_player_previous_chapter(this.mediaPlayerInstance);
    }

    @Override
    public void menuActivate() {
        this.logger.debug("menuActivate()");
        this.libvlc.libvlc_media_player_navigate(this.mediaPlayerInstance, libvlc_navigate_mode_e.libvlc_navigate_activate.intValue());
    }

    @Override
    public void menuUp() {
        this.logger.debug("menuUp()");
        this.libvlc.libvlc_media_player_navigate(this.mediaPlayerInstance, libvlc_navigate_mode_e.libvlc_navigate_up.intValue());
    }

    @Override
    public void menuDown() {
        this.logger.debug("menuDown()");
        this.libvlc.libvlc_media_player_navigate(this.mediaPlayerInstance, libvlc_navigate_mode_e.libvlc_navigate_down.intValue());
    }

    @Override
    public void menuLeft() {
        this.logger.debug("menuLeft()");
        this.libvlc.libvlc_media_player_navigate(this.mediaPlayerInstance, libvlc_navigate_mode_e.libvlc_navigate_left.intValue());
    }

    @Override
    public void menuRight() {
        this.logger.debug("menuRight()");
        this.libvlc.libvlc_media_player_navigate(this.mediaPlayerInstance, libvlc_navigate_mode_e.libvlc_navigate_right.intValue());
    }

    @Override
    public int getSpuCount() {
        this.logger.debug("getSpuCount()");
        return this.libvlc.libvlc_video_get_spu_count(this.mediaPlayerInstance);
    }

    @Override
    public int getSpu() {
        this.logger.debug("getSpu()");
        return this.libvlc.libvlc_video_get_spu(this.mediaPlayerInstance);
    }

    @Override
    public int setSpu(int spu) {
        this.logger.debug("setSpu(spu={})", (Object)spu);
        this.libvlc.libvlc_video_set_spu(this.mediaPlayerInstance, spu);
        return this.getSpu();
    }

    @Override
    public long getSpuDelay() {
        this.logger.debug("getSpuDelay()");
        return this.libvlc.libvlc_video_get_spu_delay(this.mediaPlayerInstance);
    }

    @Override
    public void setSpuDelay(long delay) {
        this.logger.debug("setSpuDelay(delay={})", (Object)delay);
        this.libvlc.libvlc_video_set_spu_delay(this.mediaPlayerInstance, delay);
    }

    @Override
    public void setSubTitleFile(String subTitleFileName) {
        this.logger.debug("setSubTitleFile(subTitleFileName={})", (Object)subTitleFileName);
        this.libvlc.libvlc_video_set_subtitle_file(this.mediaPlayerInstance, subTitleFileName);
    }

    @Override
    public void setSubTitleFile(File subTitleFile) {
        this.logger.debug("setSubTitleFile(subTitleFile={})", (Object)subTitleFile);
        this.setSubTitleFile(subTitleFile.getAbsolutePath());
    }

    @Override
    public int getTeletextPage() {
        this.logger.debug("getTeletextPage()");
        return this.libvlc.libvlc_video_get_teletext(this.mediaPlayerInstance);
    }

    @Override
    public void setTeletextPage(int pageNumber) {
        this.logger.debug("setTeletextPage(pageNumber={})", (Object)pageNumber);
        this.libvlc.libvlc_video_set_teletext(this.mediaPlayerInstance, pageNumber);
    }

    @Override
    public void toggleTeletext() {
        this.logger.debug("toggleTeletext()");
        this.libvlc.libvlc_toggle_teletext(this.mediaPlayerInstance);
    }

    @Override
    public List<TrackDescription> getTitleDescriptions() {
        this.logger.debug("getTitleDescriptions()");
        libvlc_track_description_t trackDescriptions = this.libvlc.libvlc_video_get_title_description(this.mediaPlayerInstance);
        return this.getTrackDescriptions(trackDescriptions);
    }

    @Override
    public List<TrackDescription> getVideoDescriptions() {
        this.logger.debug("getVideoDescriptions()");
        libvlc_track_description_t trackDescriptions = this.libvlc.libvlc_video_get_track_description(this.mediaPlayerInstance);
        return this.getTrackDescriptions(trackDescriptions);
    }

    @Override
    public List<TrackDescription> getAudioDescriptions() {
        this.logger.debug("getAudioDescriptions()");
        libvlc_track_description_t trackDescriptions = this.libvlc.libvlc_audio_get_track_description(this.mediaPlayerInstance);
        return this.getTrackDescriptions(trackDescriptions);
    }

    @Override
    public List<TrackDescription> getSpuDescriptions() {
        this.logger.debug("getSpuDescriptions()");
        libvlc_track_description_t trackDescriptions = this.libvlc.libvlc_video_get_spu_description(this.mediaPlayerInstance);
        return this.getTrackDescriptions(trackDescriptions);
    }

    @Override
    public List<String> getChapterDescriptions(int title) {
        ArrayList<String> trackDescriptionList;
        this.logger.debug("getChapterDescriptions(title={})", (Object)title);
        if (title >= 0 && title < this.getTitleCount()) {
            libvlc_track_description_t trackDescriptions;
            trackDescriptionList = new ArrayList<String>();
            libvlc_track_description_t trackDescription = trackDescriptions = this.libvlc.libvlc_video_get_chapter_description(this.mediaPlayerInstance, title);
            while (trackDescription != null) {
                trackDescriptionList.add(trackDescription.psz_name);
                trackDescription = trackDescription.p_next;
            }
            if (trackDescriptions != null) {
                this.libvlc.libvlc_track_description_list_release(trackDescriptions.getPointer());
            }
        } else {
            trackDescriptionList = null;
        }
        return trackDescriptionList;
    }

    @Override
    public List<String> getChapterDescriptions() {
        this.logger.debug("getChapterDescriptions()");
        return this.getChapterDescriptions(this.getTitle());
    }

    @Override
    public List<List<String>> getAllChapterDescriptions() {
        this.logger.debug("getAllChapterDescriptions()");
        int titleCount = this.getTitleCount();
        ArrayList<List<String>> result = new ArrayList<List<String>>(Math.max(titleCount, 0));
        for (int i = 0; i < titleCount; ++i) {
            result.add(this.getChapterDescriptions(i));
        }
        return result;
    }

    @Override
    public List<TitleDescription> getExtendedTitleDescriptions() {
        ArrayList<TitleDescription> result;
        this.logger.debug("getExtendedTitleDescriptions()");
        if (LibVlcVersion.getVersion().atLeast(LibVlcVersion.LIBVLC_300)) {
            PointerByReference titles = new PointerByReference();
            int titleCount = this.libvlc.libvlc_media_player_get_full_title_descriptions(this.mediaPlayerInstance, titles);
            if (titleCount != -1) {
                Pointer[] pointers;
                result = new ArrayList(titleCount);
                for (Pointer pointer : pointers = titles.getValue().getPointerArray(0L, titleCount)) {
                    libvlc_title_description_t titleDescription = (libvlc_title_description_t)Structure.newInstance(libvlc_title_description_t.class, (Pointer)pointer);
                    titleDescription.read();
                    result.add(new TitleDescription(titleDescription.i_duration, NativeString.copyNativeString(this.libvlc, titleDescription.psz_name), titleDescription.b_menu != 0));
                }
                this.libvlc.libvlc_title_descriptions_release(titles.getValue(), titleCount);
            } else {
                result = new ArrayList(0);
            }
        } else {
            result = new ArrayList<TitleDescription>(0);
        }
        return result;
    }

    @Override
    public List<ChapterDescription> getExtendedChapterDescriptions() {
        this.logger.debug("getExtendedChapterDescriptions()");
        return this.getExtendedChapterDescriptions(this.getTitle());
    }

    @Override
    public List<ChapterDescription> getExtendedChapterDescriptions(int title) {
        ArrayList<ChapterDescription> result;
        this.logger.debug("getExtendedChapterDescriptions(title={})", (Object)title);
        if (LibVlcVersion.getVersion().atLeast(LibVlcVersion.LIBVLC_300)) {
            PointerByReference chapters = new PointerByReference();
            int chapterCount = this.libvlc.libvlc_media_player_get_full_chapter_descriptions(this.mediaPlayerInstance, title, chapters);
            if (chapterCount != -1) {
                Pointer[] pointers;
                result = new ArrayList(chapterCount);
                for (Pointer pointer : pointers = chapters.getValue().getPointerArray(0L, chapterCount)) {
                    libvlc_chapter_description_t chapterDescription = (libvlc_chapter_description_t)Structure.newInstance(libvlc_chapter_description_t.class, (Pointer)pointer);
                    chapterDescription.read();
                    result.add(new ChapterDescription(chapterDescription.i_time_offset, chapterDescription.i_duration, NativeString.getNativeString(this.libvlc, chapterDescription.psz_name)));
                }
                this.libvlc.libvlc_chapter_descriptions_release(chapters.getValue(), chapterCount);
            } else {
                result = new ArrayList(0);
            }
        } else {
            result = new ArrayList<ChapterDescription>(0);
        }
        return result;
    }

    @Override
    public List<TrackInfo> getTrackInfo(TrackType ... types) {
        this.logger.debug("getTrackInfo(types={})", (Object)Arrays.toString((Object[])types));
        return this.getTrackInfo(this.mediaInstance, types);
    }

    @Override
    public List<TrackInfo> getTrackInfo(libvlc_media_t media, TrackType ... types) {
        this.logger.debug("getTrackInfo(media={},types={})", (Object)media, (Object)Arrays.toString((Object[])types));
        List<TrackInfo> result = null;
        if (media != null) {
            HashSet<TrackType> requestedTypes;
            if (types == null || types.length == 0) {
                requestedTypes = null;
            } else {
                requestedTypes = new HashSet<TrackType>(types.length);
                for (TrackType type : types) {
                    requestedTypes.add(type);
                }
            }
            result = this.getTrackInfo(media, requestedTypes);
        }
        return result;
    }

    private List<TrackInfo> getTrackInfo(libvlc_media_t media, Set<TrackType> types) {
        this.logger.debug("newGetTrackInfo(media={},types={})", (Object)media, (Object)types);
        PointerByReference tracksPointer = new PointerByReference();
        int numberOfTracks = this.libvlc.libvlc_media_tracks_get(media, tracksPointer);
        this.logger.debug("numberOfTracks={}", (Object)numberOfTracks);
        ArrayList<TrackInfo> result = new ArrayList<TrackInfo>(numberOfTracks);
        if (numberOfTracks > 0) {
            Pointer[] tracks;
            block6: for (Pointer track : tracks = tracksPointer.getValue().getPointerArray(0L, numberOfTracks)) {
                libvlc_media_track_t trackInfo = new libvlc_media_track_t(track);
                switch (libvlc_track_type_t.valueOf(trackInfo.i_type)) {
                    case libvlc_track_unknown: {
                        if (types != null && !types.contains((Object)TrackType.UNKNOWN)) continue block6;
                        result.add(new UnknownTrackInfo(trackInfo.i_codec, trackInfo.i_original_fourcc, trackInfo.i_id, trackInfo.i_profile, trackInfo.i_level, trackInfo.i_bitrate, NativeString.copyNativeString(this.libvlc, trackInfo.psz_language), NativeString.copyNativeString(this.libvlc, trackInfo.psz_description), this.getCodecDescription(libvlc_track_type_t.libvlc_track_unknown, trackInfo.i_codec)));
                        continue block6;
                    }
                    case libvlc_track_video: {
                        if (types != null && !types.contains((Object)TrackType.VIDEO)) continue block6;
                        trackInfo.u.setType(libvlc_video_track_t.class);
                        trackInfo.u.read();
                        result.add(new VideoTrackInfo(trackInfo.i_codec, trackInfo.i_original_fourcc, trackInfo.i_id, trackInfo.i_profile, trackInfo.i_level, trackInfo.i_bitrate, NativeString.copyNativeString(this.libvlc, trackInfo.psz_language), NativeString.copyNativeString(this.libvlc, trackInfo.psz_description), trackInfo.u.video.i_width, trackInfo.u.video.i_height, trackInfo.u.video.i_sar_num, trackInfo.u.video.i_sar_den, trackInfo.u.video.i_frame_rate_num, trackInfo.u.video.i_frame_rate_den, this.getCodecDescription(libvlc_track_type_t.libvlc_track_video, trackInfo.i_codec)));
                        continue block6;
                    }
                    case libvlc_track_audio: {
                        if (types != null && !types.contains((Object)TrackType.AUDIO)) continue block6;
                        trackInfo.u.setType(libvlc_audio_track_t.class);
                        trackInfo.u.read();
                        result.add(new AudioTrackInfo(trackInfo.i_codec, trackInfo.i_original_fourcc, trackInfo.i_id, trackInfo.i_profile, trackInfo.i_level, trackInfo.i_bitrate, NativeString.copyNativeString(this.libvlc, trackInfo.psz_language), NativeString.copyNativeString(this.libvlc, trackInfo.psz_description), trackInfo.u.audio.i_channels, trackInfo.u.audio.i_rate, this.getCodecDescription(libvlc_track_type_t.libvlc_track_audio, trackInfo.i_codec)));
                        continue block6;
                    }
                    case libvlc_track_text: {
                        if (types != null && !types.contains((Object)TrackType.TEXT)) continue block6;
                        trackInfo.u.setType(libvlc_subtitle_track_t.class);
                        trackInfo.u.read();
                        result.add(new TextTrackInfo(trackInfo.i_codec, trackInfo.i_original_fourcc, trackInfo.i_id, trackInfo.i_profile, trackInfo.i_level, trackInfo.i_bitrate, NativeString.copyNativeString(this.libvlc, trackInfo.psz_language), NativeString.copyNativeString(this.libvlc, trackInfo.psz_description), NativeString.copyNativeString(this.libvlc, trackInfo.u.subtitle.psz_encoding), this.getCodecDescription(libvlc_track_type_t.libvlc_track_text, trackInfo.i_codec)));
                    }
                }
            }
            this.libvlc.libvlc_media_tracks_release(tracksPointer.getValue(), numberOfTracks);
        }
        return result;
    }

    @Override
    public libvlc_media_type_e getMediaType() {
        this.logger.debug("getMediaType()");
        return this.getMediaType(this.mediaInstance);
    }

    @Override
    public libvlc_media_type_e getMediaType(libvlc_media_t media) {
        this.logger.debug("getMediaType(media={})", (Object)media);
        if (media != null) {
            return libvlc_media_type_e.mediaType(this.libvlc.libvlc_media_get_type(media));
        }
        return null;
    }

    @Override
    public String getCodecDescription(libvlc_track_type_t type, int codec) {
        this.logger.debug("getCodecDescription(type={},codec={})", (Object)type, (Object)codec);
        if (LibVlcVersion.getVersion().atLeast(LibVlcVersion.LIBVLC_300)) {
            return this.libvlc.libvlc_media_get_codec_description(type.intValue(), codec);
        }
        return "";
    }

    @Override
    public List<List<TrackInfo>> getSubItemTrackInfo(TrackType ... types) {
        this.logger.debug("getSubItemTrackInfo(types={})", (Object)Arrays.toString((Object[])types));
        return this.handleSubItems(new SubItemsHandler<List<List<TrackInfo>>>(){

            @Override
            public List<List<TrackInfo>> subItems(int count, libvlc_media_list_t subItems) {
                ArrayList<List<TrackInfo>> result = new ArrayList<List<TrackInfo>>(count);
                for (libvlc_media_t subItem : new LibVlcMediaListIterator(DefaultMediaPlayer.this.libvlc, subItems)) {
                    result.add(DefaultMediaPlayer.this.getTrackInfo(subItem, new TrackType[0]));
                }
                return result;
            }
        });
    }

    private List<TrackDescription> getTrackDescriptions(libvlc_track_description_t trackDescriptions) {
        this.logger.debug("getTrackDescriptions()");
        ArrayList<TrackDescription> trackDescriptionList = new ArrayList<TrackDescription>();
        libvlc_track_description_t trackDescription = trackDescriptions;
        while (trackDescription != null) {
            trackDescriptionList.add(new TrackDescription(trackDescription.i_id, trackDescription.psz_name));
            trackDescription = trackDescription.p_next;
        }
        if (trackDescriptions != null) {
            this.libvlc.libvlc_track_description_list_release(trackDescriptions.getPointer());
        }
        return trackDescriptionList;
    }

    @Override
    public void setSnapshotDirectory(String snapshotDirectoryName) {
        this.logger.debug("setSnapshotDirectory(snapshotDirectoryName={})", (Object)snapshotDirectoryName);
        this.snapshotDirectoryName = snapshotDirectoryName;
    }

    @Override
    public boolean saveSnapshot() {
        this.logger.debug("saveSnapshot()");
        return this.saveSnapshot(0, 0);
    }

    @Override
    public boolean saveSnapshot(int width, int height) {
        this.logger.debug("saveSnapshot(width={},height={})", (Object)width, (Object)height);
        File snapshotDirectory = new File(this.snapshotDirectoryName == null ? System.getProperty("user.home") : this.snapshotDirectoryName);
        File snapshotFile = new File(snapshotDirectory, "vlcj-snapshot-" + System.currentTimeMillis() + ".png");
        return this.saveSnapshot(snapshotFile, width, height);
    }

    @Override
    public boolean saveSnapshot(File file) {
        this.logger.debug("saveSnapshot(file={})", (Object)file);
        return this.saveSnapshot(file, 0, 0);
    }

    @Override
    public boolean saveSnapshot(File file, int width, int height) {
        this.logger.debug("saveSnapshot(file={},width={},height={})", file, width, height);
        File snapshotDirectory = file.getParentFile();
        if (snapshotDirectory == null) {
            snapshotDirectory = new File(".");
            this.logger.debug("No directory specified for snapshot, snapshot will be saved to {}", (Object)snapshotDirectory.getAbsolutePath());
        }
        if (!snapshotDirectory.exists()) {
            snapshotDirectory.mkdirs();
        }
        if (snapshotDirectory.exists()) {
            boolean snapshotTaken = this.libvlc.libvlc_video_take_snapshot(this.mediaPlayerInstance, 0, file.getAbsolutePath(), width, height) == 0;
            this.logger.debug("snapshotTaken={}", (Object)snapshotTaken);
            return snapshotTaken;
        }
        throw new RuntimeException("Directory does not exist and could not be created for '" + file.getAbsolutePath() + "'");
    }

    @Override
    public BufferedImage getSnapshot() {
        this.logger.debug("getSnapshot()");
        return this.getSnapshot(0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage getSnapshot(int width, int height) {
        this.logger.debug("getSnapshot(width={},height={})", (Object)width, (Object)height);
        File file = null;
        try {
            file = File.createTempFile("vlcj-snapshot-", ".png");
            this.logger.debug("file={}", (Object)file.getAbsolutePath());
            BufferedImage bufferedImage = ImageIO.read(new File((String)new WaitForSnapshot(this, file, width, height).await()));
            return bufferedImage;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get snapshot image", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to get snapshot image", e);
        }
        catch (BeforeConditionAbortedException e) {
            this.logger.debug("Failed to take snapshot");
            BufferedImage bufferedImage = null;
            return bufferedImage;
        }
        finally {
            if (file != null) {
                boolean deleted = file.delete();
                this.logger.debug("deleted={}", (Object)deleted);
            }
        }
    }

    @Override
    public void enableLogo(boolean enable) {
        this.logger.debug("enableLogo(enable={})", (Object)enable);
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_enable.intValue(), enable ? 1 : 0);
    }

    @Override
    public void setLogoOpacity(int opacity) {
        this.logger.debug("setLogoOpacity(opacity={})", (Object)opacity);
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_opacity.intValue(), opacity);
    }

    @Override
    public void setLogoOpacity(float opacity) {
        this.logger.debug("setLogoOpacity(opacity={})", (Object)Float.valueOf(opacity));
        int opacityValue = Math.round(opacity * 255.0f);
        this.logger.debug("opacityValue={}", (Object)opacityValue);
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_opacity.intValue(), opacityValue);
    }

    @Override
    public void setLogoLocation(int x, int y) {
        this.logger.debug("setLogoLocation(x={},y={})", (Object)x, (Object)y);
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_x.intValue(), x);
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_y.intValue(), y);
    }

    @Override
    public void setLogoPosition(libvlc_logo_position_e position) {
        this.logger.debug("setLogoPosition(position={})", (Object)position);
        this.libvlc.libvlc_video_set_logo_int(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_position.intValue(), position.intValue());
    }

    @Override
    public void setLogoFile(String logoFile) {
        this.logger.debug("setLogoFile(logoFile={})", (Object)logoFile);
        this.libvlc.libvlc_video_set_logo_string(this.mediaPlayerInstance, libvlc_video_logo_option_t.libvlc_logo_file.intValue(), logoFile);
    }

    @Override
    public void setLogoImage(RenderedImage logoImage) {
        this.logger.debug("setLogoImage(logoImage={})", (Object)logoImage);
        File file = null;
        try {
            file = File.createTempFile("vlcj-logo-", ".png");
            ImageIO.write(logoImage, "png", file);
            if (file.exists()) {
                this.setLogoFile(file.getAbsolutePath());
                file.deleteOnExit();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to set logo image", e);
        }
    }

    @Override
    public void setLogo(Logo logo) {
        this.logger.debug("setLogo(logo={})", (Object)logo);
        logo.apply(this);
    }

    @Override
    public void enableMarquee(boolean enable) {
        this.logger.debug("enableMarquee(enable={})", (Object)enable);
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Enable.intValue(), enable ? 1 : 0);
    }

    @Override
    public void setMarqueeText(String text) {
        this.logger.debug("setMarqueeText(text={})", (Object)text);
        this.libvlc.libvlc_video_set_marquee_string(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Text.intValue(), text);
    }

    @Override
    public void setMarqueeColour(Color colour) {
        this.logger.debug("setMarqueeColour(colour={})", (Object)colour);
        this.setMarqueeColour(colour.getRGB() & 0xFFFFFF);
    }

    @Override
    public void setMarqueeColour(int colour) {
        this.logger.debug("setMarqueeColour(colour={})", (Object)colour);
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Color.intValue(), colour);
    }

    @Override
    public void setMarqueeOpacity(int opacity) {
        this.logger.debug("setMarqueeOpacity(opacity={})", (Object)opacity);
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Opacity.intValue(), opacity);
    }

    @Override
    public void setMarqueeOpacity(float opacity) {
        this.logger.debug("setMarqueeOpacity(opacity={})", (Object)Float.valueOf(opacity));
        int opacityValue = Math.round(opacity * 255.0f);
        this.logger.debug("opacityValue={}", (Object)opacityValue);
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Opacity.intValue(), opacityValue);
    }

    @Override
    public void setMarqueeSize(int size) {
        this.logger.debug("setMarqueeSize(size={})", (Object)size);
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Size.intValue(), size);
    }

    @Override
    public void setMarqueeTimeout(int timeout) {
        this.logger.debug("setMarqueeTimeout(timeout={})", (Object)timeout);
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Timeout.intValue(), timeout);
    }

    @Override
    public void setMarqueeLocation(int x, int y) {
        this.logger.debug("setMarqueeLocation(x={},y={})", (Object)x, (Object)y);
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_X.intValue(), x);
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Y.intValue(), y);
    }

    @Override
    public void setMarqueePosition(libvlc_marquee_position_e position) {
        this.logger.debug("setMarqueePosition(position={})", (Object)position);
        this.libvlc.libvlc_video_set_marquee_int(this.mediaPlayerInstance, libvlc_video_marquee_option_t.libvlc_marquee_Position.intValue(), position.intValue());
    }

    @Override
    public void setMarquee(Marquee marquee) {
        this.logger.debug("setMarquee(marquee={})", (Object)marquee);
        marquee.apply(this);
    }

    @Override
    public void setDeinterlace(DeinterlaceMode deinterlaceMode) {
        this.logger.debug("setDeinterlace(deinterlaceMode={})", (Object)deinterlaceMode);
        this.libvlc.libvlc_video_set_deinterlace(this.mediaPlayerInstance, deinterlaceMode != null ? deinterlaceMode.mode() : null);
    }

    @Override
    public void setAdjustVideo(boolean adjustVideo) {
        this.logger.debug("setAdjustVideo(adjustVideo={})", (Object)adjustVideo);
        this.libvlc.libvlc_video_set_adjust_int(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Enable.intValue(), adjustVideo ? 1 : 0);
    }

    @Override
    public boolean isAdjustVideo() {
        this.logger.debug("isAdjustVideo()");
        return this.libvlc.libvlc_video_get_adjust_int(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Enable.intValue()) == 1;
    }

    @Override
    public float getContrast() {
        this.logger.debug("getContrast()");
        return this.libvlc.libvlc_video_get_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Contrast.intValue());
    }

    @Override
    public void setContrast(float contrast) {
        this.logger.debug("setContrast(contrast={})", (Object)Float.valueOf(contrast));
        this.libvlc.libvlc_video_set_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Contrast.intValue(), contrast);
    }

    @Override
    public float getBrightness() {
        this.logger.debug("getBrightness()");
        return this.libvlc.libvlc_video_get_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Brightness.intValue());
    }

    @Override
    public void setBrightness(float brightness) {
        this.logger.debug("setBrightness(brightness={})", (Object)Float.valueOf(brightness));
        this.libvlc.libvlc_video_set_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Brightness.intValue(), brightness);
    }

    @Override
    public int getHue() {
        this.logger.debug("getHue()");
        return this.libvlc.libvlc_video_get_adjust_int(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Hue.intValue());
    }

    @Override
    public void setHue(int hue) {
        this.logger.debug("setHue(hue={})", (Object)hue);
        this.libvlc.libvlc_video_set_adjust_int(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Hue.intValue(), hue);
    }

    @Override
    public float getSaturation() {
        this.logger.debug("getSaturation()");
        return this.libvlc.libvlc_video_get_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Saturation.intValue());
    }

    @Override
    public void setSaturation(float saturation) {
        this.logger.debug("setSaturation(saturation={})", (Object)Float.valueOf(saturation));
        this.libvlc.libvlc_video_set_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Saturation.intValue(), saturation);
    }

    @Override
    public float getGamma() {
        this.logger.debug("getGamma()");
        return this.libvlc.libvlc_video_get_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Gamma.intValue());
    }

    @Override
    public void setGamma(float gamma) {
        this.logger.debug("setGamma(gamma={})", (Object)Float.valueOf(gamma));
        this.libvlc.libvlc_video_set_adjust_float(this.mediaPlayerInstance, libvlc_video_adjust_option_t.libvlc_adjust_Gamma.intValue(), gamma);
    }

    @Override
    public void setVideoTitleDisplay(libvlc_position_e position, int timeout) {
        this.logger.debug("setVideoTitleDisplay(position={},timeout={})", (Object)position, (Object)timeout);
        this.libvlc.libvlc_media_player_set_video_title_display(this.mediaPlayerInstance, position.intValue(), timeout);
    }

    @Override
    public Equalizer getEqualizer() {
        this.logger.debug("getEqualizer()");
        return this.equalizer;
    }

    @Override
    public void setEqualizer(Equalizer equalizer) {
        this.logger.debug("setEqualizer(equalizer={})", (Object)equalizer);
        if (this.equalizer != null) {
            this.equalizer.removeEqualizerListener(this);
            this.libvlc.libvlc_audio_equalizer_release(this.equalizerInstance);
            this.equalizerInstance = null;
        }
        this.equalizer = equalizer;
        if (this.equalizer != null) {
            this.equalizerInstance = this.libvlc.libvlc_audio_equalizer_new();
            this.equalizer.addEqualizerListener(this);
        }
        this.applyEqualizer();
    }

    private void applyEqualizer() {
        this.logger.trace("applyEqualizer()");
        this.logger.trace("equalizerInstance={}", (Object)this.equalizerInstance);
        if (this.equalizerInstance != null) {
            this.logger.trace("Set equalizer");
            this.libvlc.libvlc_audio_equalizer_set_preamp(this.equalizerInstance, this.equalizer.getPreamp());
            for (int i = 0; i < this.libvlc.libvlc_audio_equalizer_get_band_count(); ++i) {
                this.libvlc.libvlc_audio_equalizer_set_amp_at_index(this.equalizerInstance, this.equalizer.getAmp(i), i);
            }
            this.libvlc.libvlc_media_player_set_equalizer(this.mediaPlayerInstance, this.equalizerInstance);
        } else {
            this.logger.trace("Disable equalizer");
            this.libvlc.libvlc_media_player_set_equalizer(this.mediaPlayerInstance, null);
        }
    }

    @Override
    public String mrl() {
        this.logger.debug("mrl()");
        if (this.mediaInstance != null) {
            return NativeString.getNativeString(this.libvlc, this.libvlc.libvlc_media_get_mrl(this.mediaInstance));
        }
        return null;
    }

    @Override
    public String mrl(libvlc_media_t mediaInstance) {
        this.logger.debug("mrl(mediaInstance={})", (Object)mediaInstance);
        return NativeString.getNativeString(this.libvlc, this.libvlc.libvlc_media_get_mrl(mediaInstance));
    }

    @Override
    public Object userData() {
        this.logger.debug("userData()");
        return this.userData;
    }

    @Override
    public void userData(Object userData) {
        this.logger.debug("userData(userData={})", userData);
        this.userData = userData;
    }

    @Override
    public final void release() {
        this.logger.debug("release()");
        if (this.released.compareAndSet(false, true)) {
            this.destroyInstance();
            this.onAfterRelease();
        }
    }

    @Override
    public final libvlc_media_player_t mediaPlayerInstance() {
        return this.mediaPlayerInstance;
    }

    protected void onBeforePlay() {
    }

    protected void onAfterRelease() {
    }

    private void createInstance() {
        this.logger.debug("createInstance()");
        this.mediaPlayerInstance = this.libvlc.libvlc_media_player_new(this.instance);
        this.logger.debug("mediaPlayerInstance={}", (Object)this.mediaPlayerInstance);
        this.mediaPlayerEventManager = this.libvlc.libvlc_media_player_event_manager(this.mediaPlayerInstance);
        this.logger.debug("mediaPlayerEventManager={}", (Object)this.mediaPlayerEventManager);
        this.registerEventListener();
        this.eventListenerList.add(new NewMediaEventHandler());
        this.eventListenerList.add(new RepeatPlayEventHandler());
        this.eventListenerList.add(new SubItemEventHandler());
        this.eventListenerList.add(new ResetMediaHandler());
    }

    private void destroyInstance() {
        this.logger.debug("destroyInstance()");
        this.logger.debug("Detach media events...");
        this.deregisterMediaEventListener();
        this.logger.debug("Media events detached.");
        if (this.mediaInstance != null) {
            this.logger.debug("Release media...");
            this.libvlc.libvlc_media_release(this.mediaInstance);
            this.logger.debug("Media released.");
        }
        this.logger.debug("Detach media player events...");
        this.deregisterEventListener();
        this.logger.debug("Media player events detached.");
        this.eventListenerList.clear();
        if (this.mediaPlayerInstance != null) {
            this.logger.debug("Release media player...");
            this.libvlc.libvlc_media_player_release(this.mediaPlayerInstance);
            this.logger.debug("Media player released.");
        }
        if (this.equalizer != null) {
            this.equalizer.removeEqualizerListener(this);
            this.equalizer = null;
        }
        if (this.equalizerInstance != null) {
            this.libvlc.libvlc_audio_equalizer_release(this.equalizerInstance);
            this.equalizerInstance = null;
        }
        this.logger.debug("Shut down listeners...");
        this.listenersService.shutdown();
        this.logger.debug("Listeners shut down.");
    }

    private void registerEventListener() {
        this.logger.debug("registerEventListener()");
        this.callback = new EventCallback();
        libvlc_event_e lastKnownEvent = this.lastKnownEvent();
        for (libvlc_event_e event : libvlc_event_e.values()) {
            if (event.intValue() < libvlc_event_e.libvlc_MediaPlayerMediaChanged.intValue() || event.intValue() > lastKnownEvent.intValue()) continue;
            this.logger.debug("event={}", (Object)event);
            int result = this.libvlc.libvlc_event_attach(this.mediaPlayerEventManager, event.intValue(), this.callback, null);
            this.logger.debug("result={}", (Object)result);
        }
    }

    private void deregisterEventListener() {
        this.logger.debug("deregisterEventListener()");
        if (this.callback != null) {
            libvlc_event_e lastKnownEvent = this.lastKnownEvent();
            for (libvlc_event_e event : libvlc_event_e.values()) {
                if (event.intValue() < libvlc_event_e.libvlc_MediaPlayerMediaChanged.intValue() || event.intValue() > lastKnownEvent.intValue()) continue;
                this.logger.debug("event={}", (Object)event);
                this.libvlc.libvlc_event_detach(this.mediaPlayerEventManager, event.intValue(), this.callback, null);
            }
            this.callback = null;
        }
    }

    private libvlc_event_e lastKnownEvent() {
        Version version = new Version(this.libvlc.libvlc_get_version());
        libvlc_event_e result = version.atLeast(new Version("3.0.0")) ? libvlc_event_e.libvlc_MediaPlayerChapterChanged : (version.atLeast(new Version("2.2.0")) ? libvlc_event_e.libvlc_MediaPlayerScrambledChanged : libvlc_event_e.libvlc_MediaPlayerVout);
        return result;
    }

    private void registerMediaEventListener() {
        this.logger.debug("registerMediaEventListener()");
        if (this.mediaInstance != null) {
            libvlc_event_manager_t mediaEventManager = this.libvlc.libvlc_media_event_manager(this.mediaInstance);
            libvlc_event_e lastKnownMediaEvent = this.lastKnownMediaEvent();
            for (libvlc_event_e event : libvlc_event_e.values()) {
                if (event.intValue() < libvlc_event_e.libvlc_MediaMetaChanged.intValue() || event.intValue() > lastKnownMediaEvent.intValue()) continue;
                this.logger.debug("event={}", (Object)event);
                int result = this.libvlc.libvlc_event_attach(mediaEventManager, event.intValue(), this.callback, null);
                this.logger.debug("result={}", (Object)result);
            }
        }
    }

    private void deregisterMediaEventListener() {
        this.logger.debug("deregisterMediaEventListener()");
        if (this.mediaInstance != null) {
            libvlc_event_manager_t mediaEventManager = this.libvlc.libvlc_media_event_manager(this.mediaInstance);
            libvlc_event_e lastKnownMediaEvent = this.lastKnownMediaEvent();
            for (libvlc_event_e event : libvlc_event_e.values()) {
                if (event.intValue() < libvlc_event_e.libvlc_MediaMetaChanged.intValue() || event.intValue() > lastKnownMediaEvent.intValue()) continue;
                this.logger.debug("event={}", (Object)event);
                this.libvlc.libvlc_event_detach(mediaEventManager, event.intValue(), this.callback, null);
            }
        }
    }

    private libvlc_event_e lastKnownMediaEvent() {
        Version version = new Version(this.libvlc.libvlc_get_version());
        libvlc_event_e result = version.atLeast(new Version("2.1.5")) ? libvlc_event_e.libvlc_MediaSubItemTreeAdded : libvlc_event_e.libvlc_MediaStateChanged;
        return result;
    }

    private void raiseEvent(MediaPlayerEvent mediaPlayerEvent) {
        this.logger.trace("raiseEvent(mediaPlayerEvent={}", (Object)mediaPlayerEvent);
        if (mediaPlayerEvent != null) {
            this.listenersService.submit(new NotifyEventListenersRunnable(mediaPlayerEvent));
        }
    }

    private boolean setMedia(Media media) {
        this.logger.debug("setMedia(media={})", (Object)media);
        this.lastPlayedMedia = media;
        if (this.mediaInstance != null) {
            this.deregisterMediaEventListener();
            this.libvlc.libvlc_media_release(this.mediaInstance);
            this.mediaInstance = null;
        }
        this.subItemIndex = -1;
        this.mediaInstance = this.createMediaInstance(media);
        this.logger.debug("mediaInstance={}", (Object)this.mediaInstance);
        if (this.mediaInstance != null) {
            if (this.standardMediaOptions != null) {
                for (String standardMediaOption : this.standardMediaOptions) {
                    this.logger.debug("standardMediaOption={}", (Object)standardMediaOption);
                    this.libvlc.libvlc_media_add_option(this.mediaInstance, standardMediaOption);
                }
            }
            if (media.mediaOptions() != null) {
                for (String mediaOption : media.mediaOptions()) {
                    this.logger.debug("mediaOption={}", (Object)mediaOption);
                    this.libvlc.libvlc_media_add_option(this.mediaInstance, mediaOption);
                }
            }
            this.registerMediaEventListener();
            this.libvlc.libvlc_media_player_set_media(this.mediaPlayerInstance, this.mediaInstance);
        } else {
            this.logger.error("Failed to create native media resource for '{}'", (Object)media);
        }
        this.libvlcMediaStats = new libvlc_media_stats_t();
        boolean result = this.mediaInstance != null;
        this.logger.debug("result={}", (Object)result);
        return result;
    }

    private libvlc_media_t createMediaInstance(Media media) {
        libvlc_media_t result;
        this.logger.debug("createMediaInstance(media={})", (Object)media);
        if (media instanceof SimpleMedia) {
            String mrl = ((SimpleMedia)media).mrl();
            if (MediaResourceLocator.isLocation(mrl)) {
                this.logger.debug("Treating mrl as a location");
                result = this.libvlc.libvlc_media_new_location(this.instance, mrl);
            } else {
                this.logger.debug("Treating mrl as a path");
                result = this.libvlc.libvlc_media_new_path(this.instance, mrl);
            }
        } else if (media instanceof CallbackMedia) {
            CallbackMedia callbackMedia = (CallbackMedia)((Object)media);
            result = this.libvlc.libvlc_media_new_callbacks(this.instance, callbackMedia.getOpen(), callbackMedia.getRead(), callbackMedia.getSeek(), callbackMedia.getClose(), callbackMedia.getOpaque());
        } else {
            throw new IllegalStateException("Don't know about media type " + media);
        }
        return result;
    }

    private <T> T handleSubItems(SubItemsHandler<T> subItemsHandler) {
        block5: {
            T t;
            block6: {
                this.logger.debug("handleSubItems()");
                libvlc_media_list_t subItemList = null;
                try {
                    if (this.mediaInstance == null) break block5;
                    subItemList = this.libvlc.libvlc_media_subitems(this.mediaInstance);
                    this.logger.debug("subItemList={}", (Object)subItemList);
                    if (subItemList != null) {
                        this.libvlc.libvlc_media_list_lock(subItemList);
                    }
                    t = subItemsHandler.subItems(subItemList != null ? this.libvlc.libvlc_media_list_count(subItemList) : 0, subItemList);
                    if (subItemList == null) break block6;
                    this.libvlc.libvlc_media_list_unlock(subItemList);
                    this.libvlc.libvlc_media_list_release(subItemList);
                }
                catch (Throwable throwable) {
                    if (subItemList != null) {
                        this.libvlc.libvlc_media_list_unlock(subItemList);
                        this.libvlc.libvlc_media_list_release(subItemList);
                    }
                    throw throwable;
                }
            }
            return t;
        }
        throw new IllegalStateException("No media");
    }

    private void resetMedia() {
        this.logger.debug("resetMedia()");
        this.setMedia(this.lastPlayedMedia);
    }

    @Override
    public final void equalizerChanged(Equalizer equalizer) {
        this.logger.trace("equalizerChanged(equalizer={})", (Object)equalizer);
        this.applyEqualizer();
    }

    private static interface SubItemsHandler<T> {
        public T subItems(int var1, libvlc_media_list_t var2);
    }

    private final class ResetMediaHandler
    extends MediaPlayerEventAdapter {
        private ResetMediaHandler() {
        }

        @Override
        public void finished(MediaPlayer mediaPlayer) {
            if (DefaultMediaPlayer.this.subItemCount() == 0) {
                DefaultMediaPlayer.this.resetMedia();
            }
        }
    }

    private final class SubItemEventHandler
    extends MediaPlayerEventAdapter {
        private SubItemEventHandler() {
        }

        @Override
        public void finished(MediaPlayer mediaPlayer) {
            DefaultMediaPlayer.this.logger.debug("finished(mediaPlayer={})", (Object)mediaPlayer);
            if (DefaultMediaPlayer.this.subItemIndex != -1) {
                DefaultMediaPlayer.this.logger.debug("Raising finished event for sub-item {}", (Object)DefaultMediaPlayer.this.subItemIndex);
                DefaultMediaPlayer.this.raiseEvent(DefaultMediaPlayer.this.eventFactory.createMediaSubItemFinishedEvent(DefaultMediaPlayer.this.subItemIndex, DefaultMediaPlayer.this.eventMask));
            }
            if (DefaultMediaPlayer.this.playSubItems) {
                DefaultMediaPlayer.this.playNextSubItem(new String[0]);
            }
        }
    }

    private final class RepeatPlayEventHandler
    extends MediaPlayerEventAdapter {
        private RepeatPlayEventHandler() {
        }

        @Override
        public void finished(MediaPlayer mediaPlayer) {
            DefaultMediaPlayer.this.logger.debug("finished(mediaPlayer={})", (Object)mediaPlayer);
            if (DefaultMediaPlayer.this.repeat && DefaultMediaPlayer.this.mediaInstance != null) {
                int subItemCount = DefaultMediaPlayer.this.subItemCount();
                DefaultMediaPlayer.this.logger.debug("subitemCount={}", (Object)subItemCount);
                if (subItemCount == 0) {
                    String mrl = NativeString.getNativeString(DefaultMediaPlayer.this.libvlc, DefaultMediaPlayer.this.libvlc.libvlc_media_get_mrl(DefaultMediaPlayer.this.mediaInstance));
                    DefaultMediaPlayer.this.logger.debug("auto repeat mrl={}", (Object)mrl);
                    mediaPlayer.playMedia(mrl, new String[0]);
                } else {
                    DefaultMediaPlayer.this.logger.debug("Sub-items handling repeat");
                }
            } else {
                DefaultMediaPlayer.this.logger.debug("No repeat");
            }
        }
    }

    private final class NewMediaEventHandler
    extends MediaPlayerEventAdapter {
        private NewMediaEventHandler() {
        }

        @Override
        public void mediaChanged(MediaPlayer mediaPlayer, libvlc_media_t media, String mrl) {
            DefaultMediaPlayer.this.logger.debug("mediaChanged(mediaPlayer={},media={},mrl={})", new Object[]{mediaPlayer, media, mrl});
            if (DefaultMediaPlayer.this.subItemIndex() == -1) {
                DefaultMediaPlayer.this.logger.debug("Raising event for new media");
                DefaultMediaPlayer.this.raiseEvent(DefaultMediaPlayer.this.eventFactory.createMediaNewEvent(DefaultMediaPlayer.this.eventMask));
            }
        }
    }

    private final class NotifyEventListenersRunnable
    implements Runnable {
        private final MediaPlayerEvent mediaPlayerEvent;

        private NotifyEventListenersRunnable(MediaPlayerEvent mediaPlayerEvent) {
            this.mediaPlayerEvent = mediaPlayerEvent;
        }

        @Override
        public void run() {
            DefaultMediaPlayer.this.logger.trace("run()");
            for (int i = DefaultMediaPlayer.this.eventListenerList.size() - 1; i >= 0; --i) {
                MediaPlayerEventListener listener = (MediaPlayerEventListener)DefaultMediaPlayer.this.eventListenerList.get(i);
                try {
                    this.mediaPlayerEvent.notify(listener);
                    continue;
                }
                catch (Exception e) {
                    DefaultMediaPlayer.this.logger.warn("Event listener {} threw an exception {}", (Object)listener, (Object)e.getMessage());
                }
            }
            DefaultMediaPlayer.this.logger.trace("runnable exits");
        }
    }

    private final class EventCallback
    implements libvlc_callback_t {
        private EventCallback() {
        }

        @Override
        public void callback(libvlc_event_t event, Pointer userData) {
            DefaultMediaPlayer.this.logger.trace("callback(event={},userData={})", (Object)event, (Object)userData);
            MediaPlayerEvent mediaPlayerEvent = DefaultMediaPlayer.this.eventFactory.createEvent(event, DefaultMediaPlayer.this.eventMask);
            if (event != null) {
                DefaultMediaPlayer.this.raiseEvent(mediaPlayerEvent);
            }
        }
    }
}

