/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph;

import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.NodeVisitor;
import com.hp.hpl.jena.graph.Node_ANY;
import com.hp.hpl.jena.graph.Node_Blank;
import com.hp.hpl.jena.graph.Node_Literal;
import com.hp.hpl.jena.graph.Node_NULL;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.graph.Node_Variable;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;

public abstract class Node {
    protected final Object label;
    static final int THRESHOLD = 10000;
    public static final Node ANY = new Node_ANY();
    static final String RDFprefix = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    static final NodeMaker makeAnon = new NodeMaker(){

        @Override
        Node construct(Object x) {
            return new Node_Blank(x);
        }
    };
    static final NodeMaker makeLiteral = new NodeMaker(){

        @Override
        Node construct(Object x) {
            return new Node_Literal(x);
        }
    };
    static final NodeMaker makeURI = new NodeMaker(){

        @Override
        Node construct(Object x) {
            return new Node_URI(x);
        }
    };
    static final NodeMaker makeVariable = new NodeMaker(){

        @Override
        Node construct(Object x) {
            return new Node_Variable(x);
        }
    };
    @Deprecated
    public static final Node NULL = new Node_NULL();

    @Deprecated
    public static RDFDatatype getType(String s) {
        return NodeFactory.getType(s);
    }

    @Deprecated
    public static Node createAnon() {
        return NodeFactory.createAnon();
    }

    @Deprecated
    public static Node createAnon(AnonId id) {
        return NodeFactory.createAnon(id);
    }

    @Deprecated
    public static Node createLiteral(LiteralLabel lit) {
        return NodeFactory.createLiteral(lit);
    }

    @Deprecated
    public static Node createURI(String uri) {
        return NodeFactory.createURI(uri);
    }

    @Deprecated
    public static Node createVariable(String name) {
        return NodeFactory.createVariable(name);
    }

    @Deprecated
    public static Node createLiteral(String value) {
        return NodeFactory.createLiteral(value);
    }

    @Deprecated
    public static Node createLiteral(String lit, String lang, boolean isXml) {
        return NodeFactory.createLiteral(lit, lang, isXml);
    }

    @Deprecated
    public static Node createLiteral(String lex, String lang, RDFDatatype dtype) throws DatatypeFormatException {
        return NodeFactory.createLiteral(lex, lang, dtype);
    }

    @Deprecated
    public static Node createLiteral(String lex, RDFDatatype dtype) throws DatatypeFormatException {
        return NodeFactory.createLiteral(lex, dtype);
    }

    @Deprecated
    public static Node createUncachedLiteral(Object value, String lang, RDFDatatype dtype) throws DatatypeFormatException {
        return NodeFactory.createUncachedLiteral(value, lang, dtype);
    }

    @Deprecated
    public static Node createUncachedLiteral(Object value, RDFDatatype dtype) throws DatatypeFormatException {
        return NodeFactory.createUncachedLiteral(value, dtype);
    }

    public abstract Object visitWith(NodeVisitor var1);

    public abstract boolean isConcrete();

    public boolean isLiteral() {
        return false;
    }

    public boolean isBlank() {
        return false;
    }

    public boolean isURI() {
        return false;
    }

    public boolean isVariable() {
        return false;
    }

    public AnonId getBlankNodeId() {
        throw new UnsupportedOperationException(this + " is not a blank node");
    }

    public String getBlankNodeLabel() {
        return this.getBlankNodeId().getLabelString();
    }

    public LiteralLabel getLiteral() {
        throw new UnsupportedOperationException(this + " is not a literal node");
    }

    public Object getLiteralValue() {
        throw new NotLiteral(this);
    }

    public String getLiteralLexicalForm() {
        throw new NotLiteral(this);
    }

    public String getLiteralLanguage() {
        throw new NotLiteral(this);
    }

    public String getLiteralDatatypeURI() {
        throw new NotLiteral(this);
    }

    public RDFDatatype getLiteralDatatype() {
        throw new NotLiteral(this);
    }

    public boolean getLiteralIsXML() {
        throw new NotLiteral(this);
    }

    public Object getIndexingValue() {
        return this;
    }

    public String getURI() {
        throw new UnsupportedOperationException(this + " is not a URI node");
    }

    public String getNameSpace() {
        throw new UnsupportedOperationException(this + " is not a URI node");
    }

    public String getLocalName() {
        throw new UnsupportedOperationException(this + " is not a URI node");
    }

    public String getName() {
        throw new UnsupportedOperationException("this (" + this.getClass() + ") is not a variable node");
    }

    public boolean hasURI(String uri) {
        return false;
    }

    Node(Object label) {
        this.label = label;
    }

    public static Node create(NodeMaker maker, Object label) {
        if (label == null) {
            throw new JenaException("Node.make: null label");
        }
        return maker.construct(label);
    }

    public abstract boolean equals(Object var1);

    public boolean sameValueAs(Object o) {
        return this.equals(o);
    }

    public int hashCode() {
        return this.label.hashCode() * 31;
    }

    public boolean matches(Node other) {
        return this.equals(other);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(boolean quoting) {
        return this.toString(null, quoting);
    }

    public String toString(PrefixMapping pm) {
        return this.toString(pm, true);
    }

    public String toString(PrefixMapping pm, boolean quoting) {
        return this.label.toString();
    }

    static abstract class NodeMaker {
        NodeMaker() {
        }

        abstract Node construct(Object var1);
    }

    public static class NotLiteral
    extends JenaException {
        public NotLiteral(Node it) {
            super(it + " is not a literal node");
        }
    }
}

