/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanestagging;

import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.util.Collection;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.plugins.turnlanestagging.TurnLanesEditorDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class LaunchAction
extends JosmAction
implements SelectionChangedListener {
    private boolean isLaunch = false;

    public LaunchAction() {
        super(I18n.tr((String)"Turn lanes tagging - editor", (Object[])new Object[0]), "turnlanes-tagging", I18n.tr((String)"Turn lanes tagging - Editor", (Object[])new Object[0]), Shortcut.registerShortcut((String)"edit:turnlanestaggingeditor", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"turn lanes tagging - editor", (Object[])new Object[0])}), (int)50, (int)5007), true);
        DataSet.addSelectionListener((SelectionChangedListener)this);
        this.setEnabled(false);
        this.getLayerManager().addLayerChangeListener(new LayerManager.LayerChangeListener(){

            public void layerAdded(LayerManager.LayerAddEvent lae) {
            }

            public void layerRemoving(LayerManager.LayerRemoveEvent lre) {
                LaunchAction.this.isLaunch = false;
                LaunchAction.this.setEnabled(false);
                if (!GraphicsEnvironment.isHeadless()) {
                    TurnLanesEditorDialog.getInstance().setVisible(false);
                }
            }

            public void layerOrderChanged(LayerManager.LayerOrderChangeEvent loce) {
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        this.isLaunch = true;
        this.launchEditor();
    }

    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        this.setEnabled(newSelection != null && newSelection.size() == 1 && this.isRoad());
        TurnLanesEditorDialog.getInstance().setEnableOK(true);
        if (this.isLaunch && TurnLanesEditorDialog.getInstance().isVisible()) {
            this.launchEditor();
        }
        if (!this.isRoad() || newSelection.size() > 1) {
            TurnLanesEditorDialog.getInstance().setEnableOK(false);
        }
    }

    protected void launchEditor() {
        if (!this.isEnabled()) {
            return;
        }
        TurnLanesEditorDialog dialog = TurnLanesEditorDialog.getInstance();
        dialog.startEditSession();
        dialog.setVisible(true);
    }

    public boolean isRoad() {
        DataSet ds = this.getLayerManager().getEditDataSet();
        if (ds != null) {
            Collection selection = ds.getSelected();
            for (OsmPrimitive element : selection) {
                for (String key : element.keySet()) {
                    if (!key.equals("highway")) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

