/*
 * Decompiled with CFR 0.152.
 */
package ext_tools;

import ext_tools.ExtTool;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

class ExtToolAction
extends MapMode {
    protected MapMode oldMapMode;
    protected ExtTool tool;

    public ExtToolAction(ExtTool tool) {
        super(I18n.tr((String)tool.name, (Object[])new Object[0]), "empty", tool.description, Shortcut.registerShortcut((String)I18n.tr((String)"exttool:{0}", (Object[])new Object[]{tool.name}), (String)I18n.tr((String)"External Tool: {0}", (Object[])new Object[]{tool.name}), (int)65535, (int)5000), ImageProvider.getCursor((String)"crosshair", null));
        this.tool = tool;
        this.setEnabled(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (!MainApplication.isDisplayingMapView()) {
            return;
        }
        this.oldMapMode = MainApplication.getMap().mapMode;
        super.actionPerformed(e);
    }

    public void enterMode() {
        super.enterMode();
        MainApplication.getMap().mapView.addMouseListener((MouseListener)((Object)this));
    }

    public void exitMode() {
        super.exitMode();
        MainApplication.getMap().mapView.removeMouseListener((MouseListener)((Object)this));
    }

    public void mouseClicked(MouseEvent e) {
        if (!MainApplication.isDisplayingMapView()) {
            return;
        }
        this.tool.runTool(MainApplication.getMap().mapView.getLatLon(e.getX(), e.getY()));
        MainApplication.getMap().selectMapMode(this.oldMapMode);
    }

    public boolean layerIsSupported(Layer l) {
        return l instanceof OsmDataLayer;
    }
}

