/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.elevation.gui;

import java.awt.Color;
import org.openstreetmap.josm.plugins.elevation.ElevationHelper;

public final class ElevationColors {
    public static Color EPDarkBlue = new Color(21, 59, 99);
    public static Color EPMidBlue = new Color(115, 140, 180);
    public static Color EPLightBlue = new Color(176, 187, 208);
    public static Color EPOrange = new Color(180, 140, 115);
    public static Color EPLightBeige = new Color(235, 235, 215);
    public static Color EPMidBeige = new Color(227, 222, 215);
    private static ColorMapEntry[] colors = new ColorMapEntry[]{new ColorMapEntry(new Color(0, 128, 0), 0), new ColorMapEntry(new Color(156, 187, 105), 1), new ColorMapEntry(new Color(193, 208, 107), 100), new ColorMapEntry(new Color(244, 224, 100), 200), new ColorMapEntry(new Color(242, 216, 149), 500), new ColorMapEntry(new Color(234, 191, 104), 1000), new ColorMapEntry(new Color(207, 169, 96), 2000)};

    private ElevationColors() {
    }

    public static Color getElevationColor(double ele) {
        if (!ElevationHelper.isValidElevation(ele)) {
            return Color.white;
        }
        Color col = Color.green;
        if (ele < 0.0) {
            col = Color.blue;
        }
        if (ele > 200.0) {
            col = colors[1].getColor();
        }
        if (ele > 300.0) {
            col = colors[2].getColor();
        }
        if (ele > 400.0) {
            col = colors[3].getColor();
        }
        if (ele > 500.0) {
            col = Color.yellow;
        }
        if (ele > 750.0) {
            col = Color.orange;
        }
        if (ele > 1000.0) {
            col = Color.lightGray;
        }
        if (ele > 2000.0) {
            col = Color.darkGray;
        }
        return col;
    }

    static class ColorMapEntry {
        private final int ele;
        private final Color color;

        ColorMapEntry(Color color, int ele) {
            this.color = color;
            this.ele = ele;
        }

        public int getEle() {
            return this.ele;
        }

        public Color getColor() {
            return this.color;
        }
    }
}

