/*
 * Decompiled with CFR 0.152.
 */
package at.dallermassl.josm.plugin.colorscheme;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.preferences.ColorInfo;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.display.ColorPreference;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class ColorSchemePreference
implements SubPreferenceSetting {
    private static final String PREF_KEY_SCHEMES_PREFIX = "colorschemes.";
    private static final String PREF_KEY_SCHEMES_NAMES = "colorschemes.names";
    public static final String PREF_KEY_COLOR_PREFIX = "color.";
    private JList<String> schemesList;
    private DefaultListModel<String> listModel;
    private List<String> colorKeys;
    private ColorPreference colorPreference;

    public void addGui(PreferenceTabbedPane gui) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Map colorMap = Main.pref.getAllPrefix(PREF_KEY_COLOR_PREFIX);
        this.colorKeys = new ArrayList(colorMap.keySet());
        Collections.sort(this.colorKeys);
        this.listModel = new DefaultListModel();
        this.schemesList = new JList<String>(this.listModel);
        String schemes = Main.pref.get(PREF_KEY_SCHEMES_NAMES);
        StringTokenizer st = new StringTokenizer(schemes, ";");
        while (st.hasMoreTokens()) {
            String schemeName = st.nextToken();
            this.listModel.addElement(schemeName);
        }
        JButton useScheme = new JButton(I18n.tr((String)"Use", (Object[])new Object[0]));
        useScheme.addActionListener(e -> {
            if (this.schemesList.getSelectedIndex() == -1) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select a scheme to use.", (Object[])new Object[0]));
            } else {
                String schemeName1 = this.listModel.get(this.schemesList.getSelectedIndex());
                this.getColorPreference(gui).setColors(this.getColorMap(schemeName1));
            }
        });
        JButton addScheme = new JButton(I18n.tr((String)"Add", (Object[])new Object[0]));
        addScheme.addActionListener(e -> {
            String schemeName1 = JOptionPane.showInputDialog(Main.parent, (Object)I18n.tr((String)"Color Scheme", (Object[])new Object[0]));
            if (schemeName1 == null) {
                return;
            }
            schemeName1 = schemeName1.replaceAll("\\.", "_");
            this.setColorScheme(schemeName1, this.getColorPreference(gui).getColors());
            this.listModel.addElement(schemeName1);
            this.saveSchemeNamesToPref();
        });
        JButton deleteScheme = new JButton(I18n.tr((String)"Delete", (Object[])new Object[0]));
        deleteScheme.addActionListener(e -> {
            if (this.schemesList.getSelectedIndex() == -1) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select the scheme to delete.", (Object[])new Object[0]));
            } else {
                String schemeName1 = this.listModel.get(this.schemesList.getSelectedIndex());
                this.removeColorSchemeFromPreferences(schemeName1);
                this.listModel.remove(this.schemesList.getSelectedIndex());
                this.saveSchemeNamesToPref();
            }
        });
        this.schemesList.setVisibleRowCount(3);
        useScheme.setToolTipText(I18n.tr((String)"Use the selected scheme from the list.", (Object[])new Object[0]));
        addScheme.setToolTipText(I18n.tr((String)"Use the current colors as a new color scheme.", (Object[])new Object[0]));
        deleteScheme.setToolTipText(I18n.tr((String)"Delete the selected scheme from the list.", (Object[])new Object[0]));
        panel.add((Component)new JLabel(I18n.tr((String)"Color Schemes", (Object[])new Object[0])), GBC.eol().insets(0, 5, 0, 0));
        panel.add((Component)new JScrollPane(this.schemesList), GBC.eol().fill(1));
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        panel.add((Component)buttonPanel, GBC.eol().fill(2));
        buttonPanel.add(Box.createHorizontalGlue(), GBC.std().fill(2));
        buttonPanel.add((Component)useScheme, GBC.std().insets(0, 5, 5, 0));
        buttonPanel.add((Component)addScheme, GBC.std().insets(0, 5, 5, 0));
        buttonPanel.add((Component)deleteScheme, GBC.std().insets(0, 5, 5, 0));
        JScrollPane scrollpane = new JScrollPane(panel);
        scrollpane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gui.getDisplayPreference().getTabPane().addTab(I18n.tr((String)"Color Schemes", (Object[])new Object[0]), scrollpane);
    }

    public TabPreferenceSetting getTabPreferenceSetting(PreferenceTabbedPane gui) {
        return gui.getDisplayPreference();
    }

    public void saveSchemeNamesToPref() {
        if (this.schemesList.getModel().getSize() > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.schemesList.getModel().getSize(); ++i) {
                sb.append(";" + this.schemesList.getModel().getElementAt(i));
            }
            Main.pref.put(PREF_KEY_SCHEMES_NAMES, sb.toString().substring(1));
        } else {
            Main.pref.put(PREF_KEY_SCHEMES_NAMES, null);
        }
    }

    public boolean ok() {
        return false;
    }

    public boolean isExpert() {
        return false;
    }

    public void removeColorSchemeFromPreferences(String schemeName) {
        Map colors = Main.pref.getAllPrefix(PREF_KEY_SCHEMES_PREFIX + schemeName + ".");
        for (String key : colors.keySet()) {
            Main.pref.put(key, null);
        }
    }

    public void setColorScheme(String schemeName, Map<String, ColorInfo> colorMap) {
        for (String colorKey : colorMap.keySet()) {
            String key = PREF_KEY_SCHEMES_PREFIX + schemeName + "." + PREF_KEY_COLOR_PREFIX + colorKey;
            Main.pref.put(key, ColorHelper.color2html((Color)colorMap.get(colorKey).getValue()));
        }
    }

    public Map<String, ColorInfo> getColorMap(String schemeName) {
        String prefix = PREF_KEY_SCHEMES_PREFIX + schemeName + "." + PREF_KEY_COLOR_PREFIX;
        HashMap<String, ColorInfo> colorMap = new HashMap<String, ColorInfo>();
        for (String schemeColorKey : Main.pref.getAllPrefix(prefix).keySet()) {
            String colorKey = schemeColorKey.substring(prefix.length());
            colorMap.put(colorKey, ColorInfo.fromPref(Arrays.asList(Main.pref.get(schemeColorKey), "", "", ""), (boolean)false));
        }
        return colorMap;
    }

    public ColorPreference getColorPreference(PreferenceTabbedPane gui) {
        if (this.colorPreference == null) {
            for (PreferenceSetting setting : gui.getSettings()) {
                if (!(setting instanceof ColorPreference)) continue;
                this.colorPreference = (ColorPreference)setting;
                break;
            }
        }
        return this.colorPreference;
    }
}

