/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.rasterfilters.preferences;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.List;
import javax.json.JsonObject;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.map.MapPreference;
import org.openstreetmap.josm.plugins.rasterfilters.preferences.FilterInfo;
import org.openstreetmap.josm.plugins.rasterfilters.preferences.FiltersDownloader;
import org.openstreetmap.josm.tools.GBC;

public class RasterFiltersPreferences
implements SubPreferenceSetting {
    private FiltersDownloader downloader = new FiltersDownloader();
    AbstractTableModel model;
    JPanel holder;

    public void addGui(PreferenceTabbedPane gui) {
        this.model = new FiltersTableModel();
        if (this.holder == null) {
            this.holder = new JPanel();
            this.holder.setLayout(new GridBagLayout());
            this.holder.setBorder(new EmptyBorder(10, 10, 10, 10));
            this.model.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    int row = e.getFirstRow();
                    int col = e.getColumn();
                    TableModel model = (TableModel)e.getSource();
                    Boolean isDownloadedUpdate = (Boolean)model.getValueAt(row, col);
                    List<FilterInfo> filtersList = ((FiltersTableModel)model).filtersInfoList;
                    filtersList.get(row).setNeedToDownload(isDownloadedUpdate);
                }
            });
            JTable table = new JTable(this.model);
            table.getTableHeader().setReorderingAllowed(false);
            table.getColumnModel().getColumn(3).setMaxWidth(20);
            JScrollPane pane = new JScrollPane(table);
            this.holder.add((Component)pane, GBC.eol().fill(1));
            GBC c = GBC.eol();
            c.anchor = 13;
            JButton download = new JButton("Download");
            download.addActionListener(this.downloader);
            this.holder.add((Component)download, c);
        }
        MapPreference pref = gui.getMapPreference();
        pref.addSubTab((SubPreferenceSetting)this, "Image Filters", (Component)this.holder);
    }

    public boolean ok() {
        List<FilterInfo> filtersInfoList = ((FiltersTableModel)this.model).getFiltersInfoList();
        for (FilterInfo temp : filtersInfoList) {
            JsonObject meta = temp.getMeta();
            String paramName = meta.getString("name");
            paramName = "rasterfilters." + paramName;
            Main.pref.putBoolean(paramName, temp.isNeedToDownload());
        }
        return false;
    }

    public boolean isExpert() {
        return false;
    }

    public TabPreferenceSetting getTabPreferenceSetting(PreferenceTabbedPane gui) {
        return gui.getMapPreference();
    }

    static class FiltersTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{"Filter Name", "Author", "Description", ""};
        Class<?>[] columnClasses = new Class[]{String.class, String.class, String.class, Boolean.class};
        List<FilterInfo> filtersInfoList = FiltersDownloader.downloadFiltersInfoList();
        Object[][] data = new Object[this.filtersInfoList.size()][4];

        FiltersTableModel() {
            for (int i = 0; i < this.filtersInfoList.size(); ++i) {
                this.data[i][0] = this.filtersInfoList.get(i).getName();
                this.data[i][1] = this.filtersInfoList.get(i).getOwner();
                this.data[i][2] = this.filtersInfoList.get(i).getDescription();
                this.data[i][3] = this.filtersInfoList.get(i).isNeedToDownload();
            }
        }

        @Override
        public int getRowCount() {
            return this.filtersInfoList.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.filtersInfoList.get(rowIndex).getName();
                }
                case 1: {
                    return this.filtersInfoList.get(rowIndex).getOwner();
                }
                case 2: {
                    return this.filtersInfoList.get(rowIndex).getDescription();
                }
                case 3: {
                    return this.filtersInfoList.get(rowIndex).isNeedToDownload();
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return this.columnClasses[col];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 3;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 3) {
                this.filtersInfoList.get(row).setNeedToDownload((Boolean)value);
                this.fireTableCellUpdated(row, col);
            }
        }

        public List<FilterInfo> getFiltersInfoList() {
            return this.filtersInfoList;
        }
    }
}

