/*
 * Decompiled with CFR 0.152.
 */
package relcontext.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.properties.HelpAction;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Logging;
import relcontext.ChosenRelation;
import relcontext.ChosenRelationListener;

public class RelationHelpAction
extends AbstractAction
implements ChosenRelationListener {
    private final ChosenRelation rel;

    public RelationHelpAction(ChosenRelation rel) {
        this.putValue("Name", I18n.tr((String)"Open relation wiki page", (Object[])new Object[0]));
        this.putValue("ShortDescription", I18n.tr((String)"Launch browser with wiki help for selected object", (Object[])new Object[0]));
        this.putValue("SmallIcon", ImageProvider.get((String)"dialogs", (String)"search"));
        this.rel = rel;
        rel.addChosenRelationListener(this);
        this.setEnabled(rel.get() != null);
    }

    @Override
    public void chosenRelationChanged(Relation oldRelation, Relation newRelation) {
        this.setEnabled(newRelation != null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.rel.get() == null) {
            return;
        }
        try {
            String base = Main.pref.get("url.openstreetmap-wiki", "http://wiki.openstreetmap.org/wiki/");
            String lang = LanguageInfo.getWikiLanguagePrefix();
            List uris = HelpAction.getRelationURIs((String)base, (String)lang, (Relation)this.rel.get());
            MainApplication.worker.execute(() -> HelpAction.displayHelp((List)uris));
        }
        catch (Exception e1) {
            Logging.error((Throwable)e1);
        }
    }
}

