/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.storage;

public final class DataInputBlock {
    private final byte[] _buf;
    private int _readIndex;
    private int _maxIndex;

    DataInputBlock(byte[] byArray, int n) {
        this._buf = byArray;
        this._readIndex = n;
        this._maxIndex = this._buf.length;
    }

    public int available() {
        return this._maxIndex - this._readIndex;
    }

    public int readUByte() {
        return this._buf[this._readIndex++] & 0xFF;
    }

    public int readUShortLE() {
        int n = this._readIndex;
        int n2 = this._buf[n++] & 0xFF;
        int n3 = this._buf[n++] & 0xFF;
        this._readIndex = n;
        return (n3 << 8) + (n2 << 0);
    }

    public int readUShortLE(DataInputBlock dataInputBlock) {
        int n = dataInputBlock._buf.length - 1;
        int n2 = dataInputBlock._buf[n++] & 0xFF;
        int n3 = this._buf[this._readIndex++] & 0xFF;
        return (n3 << 8) + (n2 << 0);
    }

    public int readIntLE() {
        int n = this._readIndex;
        int n2 = this._buf[n++] & 0xFF;
        int n3 = this._buf[n++] & 0xFF;
        int n4 = this._buf[n++] & 0xFF;
        int n5 = this._buf[n++] & 0xFF;
        this._readIndex = n;
        return (n5 << 24) + (n4 << 16) + (n3 << 8) + (n2 << 0);
    }

    public int readIntLE(DataInputBlock dataInputBlock, int n) {
        byte[] byArray = new byte[4];
        this.readSpanning(dataInputBlock, n, byArray);
        int n2 = byArray[0] & 0xFF;
        int n3 = byArray[1] & 0xFF;
        int n4 = byArray[2] & 0xFF;
        int n5 = byArray[3] & 0xFF;
        return (n5 << 24) + (n4 << 16) + (n3 << 8) + (n2 << 0);
    }

    public long readLongLE() {
        int n = this._readIndex;
        int n2 = this._buf[n++] & 0xFF;
        int n3 = this._buf[n++] & 0xFF;
        int n4 = this._buf[n++] & 0xFF;
        int n5 = this._buf[n++] & 0xFF;
        int n6 = this._buf[n++] & 0xFF;
        int n7 = this._buf[n++] & 0xFF;
        int n8 = this._buf[n++] & 0xFF;
        int n9 = this._buf[n++] & 0xFF;
        this._readIndex = n;
        return ((long)n9 << 56) + ((long)n8 << 48) + ((long)n7 << 40) + ((long)n6 << 32) + ((long)n5 << 24) + (long)(n4 << 16) + (long)(n3 << 8) + (long)(n2 << 0);
    }

    public long readLongLE(DataInputBlock dataInputBlock, int n) {
        byte[] byArray = new byte[8];
        this.readSpanning(dataInputBlock, n, byArray);
        int n2 = byArray[0] & 0xFF;
        int n3 = byArray[1] & 0xFF;
        int n4 = byArray[2] & 0xFF;
        int n5 = byArray[3] & 0xFF;
        int n6 = byArray[4] & 0xFF;
        int n7 = byArray[5] & 0xFF;
        int n8 = byArray[6] & 0xFF;
        int n9 = byArray[7] & 0xFF;
        return ((long)n9 << 56) + ((long)n8 << 48) + ((long)n7 << 40) + ((long)n6 << 32) + ((long)n5 << 24) + (long)(n4 << 16) + (long)(n3 << 8) + (long)(n2 << 0);
    }

    private void readSpanning(DataInputBlock dataInputBlock, int n, byte[] byArray) {
        System.arraycopy(dataInputBlock._buf, dataInputBlock._readIndex, byArray, 0, n);
        int n2 = byArray.length - n;
        System.arraycopy(this._buf, 0, byArray, n, n2);
        this._readIndex = n2;
    }

    public void readFully(byte[] byArray, int n, int n2) {
        System.arraycopy(this._buf, this._readIndex, byArray, n, n2);
        this._readIndex += n2;
    }
}

