/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.aggregates;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.poi.hssf.model.RecordStream;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.DBCellRecord;
import org.apache.poi.hssf.record.DimensionsRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.MulBlankRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RowRecord;
import org.apache.poi.hssf.record.UnknownRecord;
import org.apache.poi.hssf.record.aggregates.FormulaRecordAggregate;
import org.apache.poi.hssf.record.aggregates.RecordAggregate;
import org.apache.poi.hssf.record.aggregates.SharedValueManager;
import org.apache.poi.hssf.record.aggregates.ValueRecordsAggregate;
import org.apache.poi.ss.SpreadsheetVersion;

public final class RowRecordsAggregate
extends RecordAggregate {
    private int _firstrow = -1;
    private int _lastrow = -1;
    private final Map<Integer, RowRecord> _rowRecords;
    private final ValueRecordsAggregate _valuesAgg;
    private final List<Record> _unknownRecords;
    private final SharedValueManager _sharedValueManager;

    public RowRecordsAggregate() {
        this(SharedValueManager.createEmpty());
    }

    private RowRecordsAggregate(SharedValueManager sharedValueManager) {
        if (sharedValueManager == null) {
            throw new IllegalArgumentException("SharedValueManager must be provided.");
        }
        this._rowRecords = new TreeMap<Integer, RowRecord>();
        this._valuesAgg = new ValueRecordsAggregate();
        this._unknownRecords = new ArrayList<Record>();
        this._sharedValueManager = sharedValueManager;
    }

    public RowRecordsAggregate(RecordStream recordStream, SharedValueManager sharedValueManager) {
        this(sharedValueManager);
        block4: while (recordStream.hasNext()) {
            Record record = recordStream.getNext();
            switch (record.getSid()) {
                case 520: {
                    this.insertRow((RowRecord)record);
                    continue block4;
                }
                case 215: {
                    continue block4;
                }
            }
            if (record instanceof UnknownRecord) {
                this.addUnknownRecord(record);
                while (recordStream.peekNextSid() == 60) {
                    this.addUnknownRecord(recordStream.getNext());
                }
                continue;
            }
            if (record instanceof MulBlankRecord) {
                this._valuesAgg.addMultipleBlanks((MulBlankRecord)record);
                continue;
            }
            if (!(record instanceof CellValueRecordInterface)) {
                throw new RuntimeException("Unexpected record type (" + record.getClass().getName() + ")");
            }
            this._valuesAgg.construct((CellValueRecordInterface)((Object)record), recordStream, sharedValueManager);
        }
    }

    private void addUnknownRecord(Record record) {
        this._unknownRecords.add(record);
    }

    public void insertRow(RowRecord rowRecord) {
        this._rowRecords.put(rowRecord.getRowNumber(), rowRecord);
        if (rowRecord.getRowNumber() < this._firstrow || this._firstrow == -1) {
            this._firstrow = rowRecord.getRowNumber();
        }
        if (rowRecord.getRowNumber() > this._lastrow || this._lastrow == -1) {
            this._lastrow = rowRecord.getRowNumber();
        }
    }

    public void removeRow(RowRecord rowRecord) {
        int n = rowRecord.getRowNumber();
        this._valuesAgg.removeAllCellsValuesForRow(n);
        Integer n2 = n;
        RowRecord rowRecord2 = this._rowRecords.remove(n2);
        if (rowRecord2 == null) {
            throw new RuntimeException("Invalid row index (" + n2 + ")");
        }
        if (rowRecord != rowRecord2) {
            this._rowRecords.put(n2, rowRecord2);
            throw new RuntimeException("Attempt to remove row that does not belong to this sheet");
        }
    }

    public RowRecord getRow(int n) {
        int n2 = SpreadsheetVersion.EXCEL97.getLastRowIndex();
        if (n < 0 || n > n2) {
            throw new IllegalArgumentException("The row number must be between 0 and " + n2);
        }
        return this._rowRecords.get(n);
    }

    public int getRowBlockCount() {
        int n = this._rowRecords.size() / 32;
        if (this._rowRecords.size() % 32 != 0) {
            ++n;
        }
        return n;
    }

    private int getStartRowNumberForBlock(int n) {
        int n2 = n * 32;
        Iterator<RowRecord> iterator = this._rowRecords.values().iterator();
        RowRecord rowRecord = null;
        for (int i = 0; i <= n2; ++i) {
            rowRecord = iterator.next();
        }
        if (rowRecord == null) {
            throw new RuntimeException("Did not find start row for block " + n);
        }
        return rowRecord.getRowNumber();
    }

    private int getEndRowNumberForBlock(int n) {
        int n2 = (n + 1) * 32 - 1;
        if (n2 >= this._rowRecords.size()) {
            n2 = this._rowRecords.size() - 1;
        }
        Iterator<RowRecord> iterator = this._rowRecords.values().iterator();
        RowRecord rowRecord = null;
        for (int i = 0; i <= n2; ++i) {
            rowRecord = iterator.next();
        }
        if (rowRecord == null) {
            throw new RuntimeException("Did not find start row for block " + n);
        }
        return rowRecord.getRowNumber();
    }

    private int visitRowRecordsForBlock(int n, RecordAggregate.RecordVisitor recordVisitor) {
        int n2;
        int n3 = n * 32;
        int n4 = n3 + 32;
        Iterator<RowRecord> iterator = this._rowRecords.values().iterator();
        for (n2 = 0; n2 < n3; ++n2) {
            iterator.next();
        }
        int n5 = 0;
        while (iterator.hasNext() && n2++ < n4) {
            Record record = iterator.next();
            n5 += record.getRecordSize();
            recordVisitor.visitRecord(record);
        }
        return n5;
    }

    @Override
    public void visitContainedRecords(RecordAggregate.RecordVisitor recordVisitor) {
        int n;
        RecordAggregate.PositionTrackingVisitor positionTrackingVisitor = new RecordAggregate.PositionTrackingVisitor(recordVisitor, 0);
        int n2 = this.getRowBlockCount();
        for (n = 0; n < n2; ++n) {
            int n3 = 0;
            int n4 = this.visitRowRecordsForBlock(n, recordVisitor);
            n3 += n4;
            int n5 = this.getStartRowNumberForBlock(n);
            int n6 = this.getEndRowNumberForBlock(n);
            DBCellRecord.Builder builder = new DBCellRecord.Builder();
            int n7 = n4 - 20;
            for (int i = n5; i <= n6; ++i) {
                if (!this._valuesAgg.rowHasCells(i)) continue;
                positionTrackingVisitor.setPosition(0);
                this._valuesAgg.visitCellsForRow(i, positionTrackingVisitor);
                int n8 = positionTrackingVisitor.getPosition();
                n3 += n8;
                builder.addCellOffset(n7);
                n7 = n8;
            }
            recordVisitor.visitRecord(builder.build(n3));
        }
        for (n = 0; n < this._unknownRecords.size(); ++n) {
            recordVisitor.visitRecord(this._unknownRecords.get(n));
        }
    }

    public Iterator<RowRecord> getIterator() {
        return this._rowRecords.values().iterator();
    }

    public CellValueRecordInterface[] getValueRecords() {
        return this._valuesAgg.getValueRecords();
    }

    public void insertCell(CellValueRecordInterface cellValueRecordInterface) {
        this._valuesAgg.insertCell(cellValueRecordInterface);
    }

    public void removeCell(CellValueRecordInterface cellValueRecordInterface) {
        if (cellValueRecordInterface instanceof FormulaRecordAggregate) {
            ((FormulaRecordAggregate)cellValueRecordInterface).notifyFormulaChanging();
        }
        this._valuesAgg.removeCell(cellValueRecordInterface);
    }

    public FormulaRecordAggregate createFormula(int n, int n2) {
        FormulaRecord formulaRecord = new FormulaRecord();
        formulaRecord.setRow(n);
        formulaRecord.setColumn((short)n2);
        return new FormulaRecordAggregate(formulaRecord, null, this._sharedValueManager);
    }

    public DimensionsRecord createDimensions() {
        DimensionsRecord dimensionsRecord = new DimensionsRecord();
        dimensionsRecord.setFirstRow(this._firstrow);
        dimensionsRecord.setLastRow(this._lastrow);
        dimensionsRecord.setFirstCol((short)this._valuesAgg.getFirstCellNum());
        dimensionsRecord.setLastCol((short)this._valuesAgg.getLastCellNum());
        return dimensionsRecord;
    }
}

