/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi;

import java.io.IOException;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hpsf.HPSFException;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.PropertySetFactory;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public abstract class POIDocument {
    private SummaryInformation sInf;
    private DocumentSummaryInformation dsInf;
    protected DirectoryNode directory;
    private static final POILogger logger = POILogFactory.getLogger(POIDocument.class);
    private boolean initialized = false;

    protected POIDocument(DirectoryNode directoryNode) {
        this.directory = directoryNode;
    }

    public DocumentSummaryInformation getDocumentSummaryInformation() {
        if (!this.initialized) {
            this.readProperties();
        }
        return this.dsInf;
    }

    public SummaryInformation getSummaryInformation() {
        if (!this.initialized) {
            this.readProperties();
        }
        return this.sInf;
    }

    protected void readProperties() {
        PropertySet propertySet = this.getPropertySet("\u0005DocumentSummaryInformation");
        if (propertySet != null && propertySet instanceof DocumentSummaryInformation) {
            this.dsInf = (DocumentSummaryInformation)propertySet;
        } else if (propertySet != null) {
            logger.log(POILogger.WARN, (Object)"DocumentSummaryInformation property set came back with wrong class - ", propertySet.getClass());
        }
        propertySet = this.getPropertySet("\u0005SummaryInformation");
        if (propertySet instanceof SummaryInformation) {
            this.sInf = (SummaryInformation)propertySet;
        } else if (propertySet != null) {
            logger.log(POILogger.WARN, (Object)"SummaryInformation property set came back with wrong class - ", propertySet.getClass());
        }
        this.initialized = true;
    }

    protected PropertySet getPropertySet(String string) {
        DocumentInputStream documentInputStream;
        if (this.directory == null) {
            return null;
        }
        try {
            documentInputStream = this.directory.createDocumentInputStream(string);
        }
        catch (IOException iOException) {
            logger.log(POILogger.WARN, "Error getting property set with name " + string + "\n" + iOException);
            return null;
        }
        try {
            PropertySet propertySet = PropertySetFactory.create(documentInputStream);
            return propertySet;
        }
        catch (IOException iOException) {
            logger.log(POILogger.WARN, "Error creating property set with name " + string + "\n" + iOException);
        }
        catch (HPSFException hPSFException) {
            logger.log(POILogger.WARN, "Error creating property set with name " + string + "\n" + hPSFException);
        }
        return null;
    }
}

