/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tofix.oauth.signpost.signature;

import java.util.Iterator;
import org.openstreetmap.josm.plugins.tofix.oauth.signpost.OAuth;
import org.openstreetmap.josm.plugins.tofix.oauth.signpost.http.HttpParameters;
import org.openstreetmap.josm.plugins.tofix.oauth.signpost.http.HttpRequest;
import org.openstreetmap.josm.plugins.tofix.oauth.signpost.signature.SigningStrategy;

public class QueryStringSigningStrategy
implements SigningStrategy {
    private static final long serialVersionUID = 1L;

    @Override
    public String writeSignature(String signature, HttpRequest request, HttpParameters requestParameters) {
        HttpParameters oauthParams = requestParameters.getOAuthParameters();
        oauthParams.put("oauth_signature", signature, true);
        Iterator<String> iter = oauthParams.keySet().iterator();
        String firstKey = iter.next();
        StringBuilder sb = new StringBuilder(OAuth.addQueryString(request.getRequestUrl(), oauthParams.getAsQueryString(firstKey)));
        while (iter.hasNext()) {
            sb.append("&");
            String key = iter.next();
            sb.append(oauthParams.getAsQueryString(key));
        }
        String signedUrl = sb.toString();
        request.setRequestUrl(signedUrl);
        return signedUrl;
    }
}

