/*
 * Decompiled with CFR 0.152.
 */
package reverter;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.command.conflict.ConflictAddCommand;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.progress.swing.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.UserCancelException;
import reverter.ChangesetReverter;
import reverter.RevertChangesetCommand;
import reverter.RevertRedactedChangesetException;

public class RevertChangesetTask
extends PleaseWaitRunnable {
    private final Collection<Integer> changesetIds;
    private final ChangesetReverter.RevertType revertType;
    private boolean newLayer;
    private ChangesetReverter rev;
    private boolean downloadConfirmed;
    private int numberOfConflicts;

    public RevertChangesetTask(int changesetId, ChangesetReverter.RevertType revertType) {
        this(changesetId, revertType, false);
    }

    public RevertChangesetTask(int changesetId, ChangesetReverter.RevertType revertType, boolean autoConfirmDownload) {
        this(changesetId, revertType, autoConfirmDownload, false);
    }

    public RevertChangesetTask(int changesetId, ChangesetReverter.RevertType revertType, boolean autoConfirmDownload, boolean newLayer) {
        this(Collections.singleton(changesetId), revertType, autoConfirmDownload, newLayer);
    }

    public RevertChangesetTask(Collection<Integer> changesetIds, ChangesetReverter.RevertType revertType, boolean autoConfirmDownload, boolean newLayer) {
        super(I18n.tr((String)"Reverting...", (Object[])new Object[0]));
        this.changesetIds = new ArrayList<Integer>(changesetIds);
        this.revertType = revertType;
        this.downloadConfirmed = autoConfirmDownload;
        this.newLayer = newLayer;
    }

    private boolean checkAndDownloadMissing() throws OsmTransferException {
        if (!this.rev.hasMissingObjects()) {
            return true;
        }
        if (!this.downloadConfirmed) {
            Integer selectedOption = (Integer)GuiHelper.runInEDTAndWaitAndReturn((Callable)new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return JOptionPane.showConfirmDialog(Main.parent, I18n.tr((String)"This changeset has objects that are not present in current dataset.\nIt is needed to download them before reverting. Do you want to continue?", (Object[])new Object[0]), I18n.tr((String)"Confirm", (Object[])new Object[0]), 0);
                }
            });
            boolean bl = this.downloadConfirmed = selectedOption != null && selectedOption == 0;
            if (!this.downloadConfirmed) {
                return false;
            }
        }
        try (PleaseWaitProgressMonitor monitor = new PleaseWaitProgressMonitor(I18n.tr((String)"Fetching missing primitives", (Object[])new Object[0]));){
            this.rev.downloadMissingPrimitives((ProgressMonitor)monitor);
        }
        return !monitor.isCanceled();
    }

    protected void realRun() throws OsmTransferException {
        this.numberOfConflicts = 0;
        ArrayList<RevertChangesetCommand> allcmds = new ArrayList<RevertChangesetCommand>();
        Logging.info((String)"Reverting {0} changeset(s): {1}", (Object[])new Object[]{this.changesetIds.size(), this.changesetIds});
        for (int changesetId : this.changesetIds) {
            try {
                Logging.info((String)"Reverting changeset {0}", (Object[])new Object[]{changesetId});
                allcmds.add(this.revertChangeset(changesetId));
                Logging.info((String)"Reverted changeset {0}", (Object[])new Object[]{changesetId});
                this.newLayer = false;
            }
            catch (OsmTransferException e) {
                Logging.error((Throwable)e);
                throw e;
            }
            catch (UserCancelException e) {
                Logging.warn((String)"Revert canceled");
                Logging.trace((Throwable)e);
                return;
            }
        }
        if (!allcmds.isEmpty()) {
            SequenceCommand cmd = allcmds.size() == 1 ? (Command)allcmds.get(0) : new SequenceCommand(I18n.tr((String)"Revert changeset", (Object[])new Object[0]), allcmds);
            GuiHelper.runInEDT(() -> this.lambda$realRun$0((Command)cmd));
        }
    }

    private RevertChangesetCommand revertChangeset(int changesetId) throws OsmTransferException, UserCancelException {
        this.progressMonitor.indeterminateSubTask(I18n.tr((String)"Downloading changeset", (Object[])new Object[0]));
        try {
            this.rev = new ChangesetReverter(changesetId, this.revertType, this.newLayer, this.progressMonitor.createSubTaskMonitor(0, true));
        }
        catch (RevertRedactedChangesetException e) {
            GuiHelper.runInEDT(() -> new Notification(e.getMessage() + "<br>" + I18n.tr((String)"See {0}", (Object[])new Object[]{"<a href=\"https://www.openstreetmap.org/redactions\">https://www.openstreetmap.org/redactions</a>"})).setIcon(0).setDuration(Notification.TIME_LONG).show());
            this.progressMonitor.cancel();
        }
        if (this.progressMonitor.isCanceled()) {
            throw new UserCancelException();
        }
        this.rev.checkMissingCreated();
        this.rev.checkMissingUpdated();
        if (this.rev.hasMissingObjects()) {
            this.rev.checkMissingDeleted();
            if (!this.checkAndDownloadMissing()) {
                throw new UserCancelException();
            }
        } else {
            this.rev.checkMissingDeleted();
            this.rev.downloadMissingPrimitives(this.progressMonitor.createSubTaskMonitor(0, false));
        }
        if (this.progressMonitor.isCanceled()) {
            throw new UserCancelException();
        }
        this.rev.downloadObjectsHistory(this.progressMonitor.createSubTaskMonitor(-1, false));
        if (this.progressMonitor.isCanceled()) {
            throw new UserCancelException();
        }
        if (!this.checkAndDownloadMissing()) {
            throw new UserCancelException();
        }
        this.rev.fixNodesWithoutCoordinates(this.progressMonitor);
        List<Command> cmds = this.rev.getCommands();
        if (cmds.isEmpty()) {
            String msg = MessageFormat.format("No revert commands found for changeset {0}", changesetId);
            Logging.warn((String)msg);
            throw new OsmTransferException(msg);
        }
        for (Command c : cmds) {
            if (!(c instanceof ConflictAddCommand)) continue;
            ++this.numberOfConflicts;
        }
        return new RevertChangesetCommand(I18n.tr((String)(this.revertType == ChangesetReverter.RevertType.FULL ? "Revert changeset #{0}" : "Partially revert changeset #{0}"), (Object[])new Object[]{changesetId}), cmds);
    }

    protected void cancel() {
    }

    protected void finish() {
    }

    public final int getNumberOfConflicts() {
        return this.numberOfConflicts;
    }

    private /* synthetic */ void lambda$realRun$0(Command cmd) {
        MainApplication.undoRedo.add(cmd);
        if (this.numberOfConflicts > 0) {
            MainApplication.getMap().conflictDialog.warnNumNewConflicts(this.numberOfConflicts);
        }
    }
}

