/*
 * Decompiled with CFR 0.152.
 */
package controller;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import model.IndoorHelperModel;
import model.TagCatalog;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ValidateAction;
import org.openstreetmap.josm.actions.mapmode.DrawAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.actions.mapmode.SelectAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.tests.MapCSSTagChecker;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.help.HelpBrowser;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.spi.preferences.MapListSetting;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import views.LevelSelectorView;
import views.ToolBoxView;

public class IndoorHelperController {
    private IndoorHelperModel model = new IndoorHelperModel();
    private ToolBoxView toolboxView = new ToolBoxView();
    private String sep = System.getProperty("file.separator");
    private String levelValue;
    private String levelNum;
    private MapFrame map;
    private DrawAction drawAction;
    private SelectAction selectAction;
    private SpaceAction SpaceAction;
    private transient Shortcut SpaceShortcut;
    private EnterAction EnterAction;
    private transient Shortcut EnterShortcut;
    private boolean OuterHelp;
    private boolean InnerHelp;
    private boolean LevelHelp;
    private Collection<OsmPrimitive> innerRelation;
    private LevelSelectorView selectorView;

    public IndoorHelperController() {
        this.setPluginPreferences(true);
        this.drawAction = new DrawAction();
        this.map = MainApplication.getMap();
        this.selectAction = new SelectAction(this.map);
        this.toolboxView.setAllUiElementsEnabled(true);
        this.toolboxView.setROUiElementsEnabled(false);
        this.addToolboxListeners();
        MainApplication.getMap().addToggleDialog((ToggleDialog)this.toolboxView);
        this.SpaceShortcut = Shortcut.registerShortcut((String)"mapmode:space", (String)I18n.tr((String)"ConfirmObjectDrawing", (Object[])new Object[0]), (int)32, (int)5003);
        this.SpaceAction = new SpaceAction();
        MainApplication.registerActionShortcut((Action)this.SpaceAction, (Shortcut)this.SpaceShortcut);
        this.EnterShortcut = Shortcut.registerShortcut((String)"mapmode:enter", (String)I18n.tr((String)"ConfirmMultipolygonSelection", (Object[])new Object[0]), (int)10, (int)5003);
        this.EnterAction = new EnterAction();
        MainApplication.registerActionShortcut((Action)this.EnterAction, (Shortcut)this.EnterShortcut);
        this.OuterHelp = false;
        this.InnerHelp = false;
        this.LevelHelp = false;
        this.innerRelation = null;
        this.levelValue = new String();
        this.levelNum = new String();
    }

    private void addToolboxListeners() {
        if (this.toolboxView != null) {
            this.toolboxView.setApplyButtonListener(new ToolApplyButtonListener());
            this.toolboxView.setLevelCheckBoxListener(new ToolLevelCheckBoxListener());
            this.toolboxView.setHelpButtonListener(new ToolHelpButtonListener());
            this.toolboxView.setAddLevelButtonListener(new ToolAddLevelButtonListener());
            this.toolboxView.setObjectItemListener(new ToolObjectItemListener());
            this.toolboxView.setOuterButtonListener(new ToolOuterButtonListener());
            this.toolboxView.setInnerButtonListener(new ToolInnerButtonListener());
            this.toolboxView.setMultiCheckBoxListener(new ToolMultiCheckBoxListener());
            this.toolboxView.setPreset1Listener(new Preset1Listener());
            this.toolboxView.setPreset2Listener(new Preset2Listener());
            this.toolboxView.setPreset3Listener(new Preset3Listener());
            this.toolboxView.setPreset4Listener(new Preset4Listener());
        }
    }

    private void addLevelSelectorListeners() {
        if (this.selectorView != null) {
            this.selectorView.setOkButtonListener(new ToolLevelOkButtonListener());
            this.selectorView.setCancelButtonListener(new ToolLevelCancelButtonListener());
            this.selectorView.setSelectorWindowListener(new ToolSelectorWindowSListener());
        }
    }

    private void refreshPresets() {
        this.toolboxView.setPresetButtons(this.model.getPresetRanking());
    }

    public void unsetSpecificKeyFilter(String key) {
        Collection p = Main.main.getEditDataSet().allPrimitives();
        Map tags = new HashMap();
        Integer level = Integer.parseInt(this.levelValue);
        for (OsmPrimitive osm : p) {
            if (!osm.isDisabledAndHidden() && !osm.isDisabled() || !osm.hasKey(key)) continue;
            tags = osm.getInterestingTags();
            for (Map.Entry e : tags.entrySet()) {
                Integer secVal;
                Integer firstVal;
                if (!((String)e.getKey()).equals(key)) continue;
                String val = (String)e.getValue();
                if (val.indexOf("-") == 0) {
                    firstVal = Integer.parseInt(val.split("-", 2)[1].split("-", 2)[0]) * -1;
                    secVal = Integer.parseInt(val.split("-", 2)[1].split("-", 2)[1]);
                } else {
                    firstVal = Integer.parseInt(val.split("-")[0]);
                    secVal = Integer.parseInt(val.split("-")[1]);
                }
                if (level >= firstVal - 1 && level <= secVal) {
                    osm.unsetDisabledState();
                    continue;
                }
                osm.setDisabledState(true);
            }
        }
    }

    public void setIndoorLevel(String indoorLevel) {
        this.toolboxView.setLevelLabel(indoorLevel);
    }

    public void getIndoorLevel(String indoorLevel) {
        this.levelValue = indoorLevel;
    }

    private void resetHelper() {
        this.InnerHelp = false;
        this.OuterHelp = false;
    }

    private void updateSettings() {
        Main.pref.init(false);
        MapCSSTagChecker tagChecker = (MapCSSTagChecker)OsmValidator.getTest(MapCSSTagChecker.class);
        if (tagChecker != null) {
            OsmValidator.initializeTests(Collections.singleton(tagChecker));
        }
        MapPaintStyles.readFromPreferences();
    }

    private void setPluginPreferences(boolean enabled) {
        Map settings = Main.pref.getAllSettings();
        MapListSetting validatorMapListSetting = (MapListSetting)settings.get("validator.org.openstreetmap.josm.data.validation.tests.MapCSSTagChecker.entries");
        List validatorMaps = new ArrayList();
        if (validatorMapListSetting != null) {
            validatorMaps = (List)validatorMapListSetting.getValue();
        }
        MapListSetting styleMapListSetting = (MapListSetting)settings.get("mappaint.style.entries");
        List styleMaps = new ArrayList();
        if (styleMapListSetting != null) {
            styleMaps = (List)styleMapListSetting.getValue();
        }
        if (enabled) {
            ArrayList validatorMapsNew = new ArrayList();
            if (!validatorMaps.isEmpty()) {
                validatorMapsNew.addAll(validatorMaps);
            }
            for (Map map : validatorMapsNew) {
                if (!map.containsValue(I18n.tr((String)"Indoor", (Object[])new Object[0]))) continue;
                validatorMapsNew.remove(map);
                break;
            }
            HashMap<String, String> indoorValidator = new HashMap<String, String>();
            indoorValidator.put("title", "Indoor");
            indoorValidator.put("active", "true");
            indoorValidator.put("url", Main.pref.getDirs().getUserDataDirectory(true) + this.sep + "validator" + this.sep + "indoorhelper.validator.mapcss");
            validatorMapsNew.add(indoorValidator);
            Main.pref.putListOfMaps("validator.org.openstreetmap.josm.data.validation.tests.MapCSSTagChecker.entries", validatorMapsNew);
            ArrayList arrayList = new ArrayList();
            if (!styleMaps.isEmpty()) {
                arrayList.addAll(styleMaps);
            }
            for (Map map : arrayList) {
                if (!map.containsValue(I18n.tr((String)"Indoor", (Object[])new Object[0]))) continue;
                arrayList.remove(map);
                break;
            }
            HashMap<String, String> indoorMapPaint = new HashMap<String, String>();
            indoorMapPaint.put("title", I18n.tr((String)"Indoor", (Object[])new Object[0]));
            indoorMapPaint.put("active", "true");
            indoorMapPaint.put("url", Main.pref.getDirs().getUserDataDirectory(true) + this.sep + "styles" + this.sep + "indoor.mapcss");
            arrayList.add(indoorMapPaint);
            Main.pref.putListOfMaps("mappaint.style.entries", arrayList);
            this.updateSettings();
        } else {
            ArrayList<Object> validatorMapsNew = new ArrayList<Object>();
            if (!validatorMaps.isEmpty()) {
                validatorMapsNew.addAll(validatorMaps);
            }
            for (Map map : validatorMapsNew) {
                if (!map.containsValue(I18n.tr((String)"Indoor", (Object[])new Object[0]))) continue;
                validatorMapsNew.remove(map);
                break;
            }
            HashMap indoorValidator = new HashMap();
            indoorValidator.put("title", I18n.tr((String)"Indoor", (Object[])new Object[0]));
            indoorValidator.put("active", "false");
            indoorValidator.put("url", Main.pref.getDirs().getUserDataDirectory(true) + this.sep + "validator" + this.sep + "indoorhelper.validator.mapcss");
            validatorMapsNew.add(indoorValidator);
            Main.pref.putListOfMaps("validator.org.openstreetmap.josm.data.validation.tests.MapCSSTagChecker.entries", validatorMapsNew);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (!styleMaps.isEmpty()) {
                arrayList.addAll(styleMaps);
            }
            for (Map map : arrayList) {
                if (!map.containsValue(I18n.tr((String)"Indoor", (Object[])new Object[0]))) continue;
                arrayList.remove(map);
                break;
            }
            HashMap indoorMapPaint = new HashMap();
            indoorMapPaint.put("title", I18n.tr((String)"Indoor", (Object[])new Object[0]));
            indoorMapPaint.put("active", "false");
            indoorMapPaint.put("url", Main.pref.getDirs().getUserDataDirectory(true) + this.sep + "styles" + this.sep + "indoor.mapcss");
            arrayList.add(indoorMapPaint);
            Main.pref.putListOfMaps("mappaint.style.entries", arrayList);
            this.updateSettings();
        }
    }

    private class EnterAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private EnterAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (IndoorHelperController.this.InnerHelp && !IndoorHelperController.this.OuterHelp) {
                IndoorHelperController.this.model.editRelation("inner", IndoorHelperController.this.innerRelation);
                IndoorHelperController.this.InnerHelp = false;
            } else if (IndoorHelperController.this.InnerHelp && IndoorHelperController.this.OuterHelp || IndoorHelperController.this.OuterHelp && !IndoorHelperController.this.InnerHelp) {
                JOptionPane.showMessageDialog(null, I18n.tr((String)"Please press spacebar first to add \"outer\" object to relation.", (Object[])new Object[0]), I18n.tr((String)"Relation-Error", (Object[])new Object[0]), 0);
                IndoorHelperController.this.resetHelper();
            }
        }
    }

    private class SpaceAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private SpaceAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (IndoorHelperController.this.OuterHelp) {
                IndoorHelperController.this.model.addRelation("outer");
                IndoorHelperController.this.map.selectMapMode((MapMode)IndoorHelperController.this.selectAction);
                IndoorHelperController.this.OuterHelp = false;
                MainApplication.getLayerManager().getEditDataSet().clearSelection();
            } else if (IndoorHelperController.this.InnerHelp) {
                IndoorHelperController.this.innerRelation = MainApplication.getLayerManager().getEditDataSet().getAllSelected();
                IndoorHelperController.this.map.selectMapMode((MapMode)IndoorHelperController.this.selectAction);
                MainApplication.getLayerManager().getEditDataSet().clearSelection();
            } else if (IndoorHelperController.this.LevelHelp) {
                ArrayList<Tag> tags = new ArrayList<Tag>();
                tags.add(new Tag("level", IndoorHelperController.this.levelNum));
                IndoorHelperController.this.model.addTagsToOSM(tags);
                IndoorHelperController.this.map.selectMapMode((MapMode)IndoorHelperController.this.selectAction);
                IndoorHelperController.this.LevelHelp = false;
            }
        }
    }

    class ToolSelectorWindowSListener
    implements WindowListener {
        ToolSelectorWindowSListener() {
        }

        @Override
        public void windowClosed(WindowEvent e) {
            IndoorHelperController.this.selectorView = null;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            IndoorHelperController.this.selectorView = null;
        }

        @Override
        public void windowActivated(WindowEvent arg0) {
        }

        @Override
        public void windowDeactivated(WindowEvent arg0) {
        }

        @Override
        public void windowDeiconified(WindowEvent arg0) {
        }

        @Override
        public void windowIconified(WindowEvent arg0) {
        }

        @Override
        public void windowOpened(WindowEvent arg0) {
        }
    }

    class ToolLevelCancelButtonListener
    implements ActionListener {
        ToolLevelCancelButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IndoorHelperController.this.selectorView.dispose();
            IndoorHelperController.this.selectorView = null;
        }
    }

    class ToolLevelOkButtonListener
    implements ActionListener {
        ToolLevelOkButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IndoorHelperController.this.LevelHelp = true;
            if (!IndoorHelperController.this.selectorView.getLevelNumber().equals("")) {
                IndoorHelperController.this.levelNum = IndoorHelperController.this.selectorView.getLevelNumber();
                IndoorHelperController.this.selectorView.dispose();
                IndoorHelperController.this.map.selectMapMode((MapMode)IndoorHelperController.this.drawAction);
            } else {
                JOptionPane.showMessageDialog(null, I18n.tr((String)"Please insert a value.", (Object[])new Object[0]), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
            }
            IndoorHelperController.this.selectorView = null;
        }
    }

    class Preset4Listener
    implements ActionListener {
        Preset4Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IndoorHelperController.this.model.addTagsToOSM(IndoorHelperController.this.toolboxView.getPreset4());
        }
    }

    class Preset3Listener
    implements ActionListener {
        Preset3Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IndoorHelperController.this.model.addTagsToOSM(IndoorHelperController.this.toolboxView.getPreset3());
        }
    }

    class Preset2Listener
    implements ActionListener {
        Preset2Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IndoorHelperController.this.model.addTagsToOSM(IndoorHelperController.this.toolboxView.getPreset2());
        }
    }

    class Preset1Listener
    implements ActionListener {
        Preset1Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IndoorHelperController.this.model.addTagsToOSM(IndoorHelperController.this.toolboxView.getPreset1());
        }
    }

    class ToolInnerButtonListener
    implements ActionListener {
        ToolInnerButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IndoorHelperController.this.map.selectMapMode((MapMode)IndoorHelperController.this.drawAction);
            IndoorHelperController.this.InnerHelp = true;
            IndoorHelperController.this.OuterHelp = false;
        }
    }

    class ToolOuterButtonListener
    implements ActionListener {
        ToolOuterButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IndoorHelperController.this.map.selectMapMode((MapMode)IndoorHelperController.this.drawAction);
            IndoorHelperController.this.OuterHelp = true;
            IndoorHelperController.this.InnerHelp = false;
        }
    }

    class ToolMultiCheckBoxListener
    implements ItemListener {
        ToolMultiCheckBoxListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                IndoorHelperController.this.toolboxView.setMultiUiElementsEnabled(false);
            } else {
                IndoorHelperController.this.toolboxView.setMultiUiElementsEnabled(true);
            }
        }
    }

    class ToolAddLevelButtonListener
    implements ActionListener {
        ToolAddLevelButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (IndoorHelperController.this.selectorView == null) {
                IndoorHelperController.this.selectorView = new LevelSelectorView();
                IndoorHelperController.this.addLevelSelectorListeners();
                IndoorHelperController.this.selectorView.setVisible(true);
            } else {
                IndoorHelperController.this.selectorView.toFront();
            }
        }
    }

    static class ToolHelpButtonListener
    implements ActionListener {
        ToolHelpButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String topic = "Plugin/indoorHelper";
            HelpBrowser.setUrlForHelpTopic((String)Optional.ofNullable(topic).orElse("/"));
        }
    }

    class ToolLevelCheckBoxListener
    implements ItemListener {
        ToolLevelCheckBoxListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                IndoorHelperController.this.toolboxView.setLVLUiElementsEnabled(false);
            } else {
                IndoorHelperController.this.toolboxView.setLVLUiElementsEnabled(true);
            }
        }
    }

    class ToolObjectItemListener
    implements ItemListener {
        ToolObjectItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (IndoorHelperController.this.toolboxView.getSelectedObject().equals((Object)TagCatalog.IndoorObject.ROOM)) {
                IndoorHelperController.this.toolboxView.setNRUiElementsEnabled(true);
                IndoorHelperController.this.toolboxView.setROUiElementsEnabled(false);
            } else if (IndoorHelperController.this.toolboxView.getSelectedObject().equals((Object)TagCatalog.IndoorObject.STEPS) || IndoorHelperController.this.toolboxView.getSelectedObject().equals((Object)TagCatalog.IndoorObject.ELEVATOR)) {
                IndoorHelperController.this.toolboxView.setROUiElementsEnabled(true);
                IndoorHelperController.this.toolboxView.setNRUiElementsEnabled(true);
            } else {
                IndoorHelperController.this.toolboxView.setROUiElementsEnabled(false);
            }
        }
    }

    class ToolApplyButtonListener
    implements ActionListener {
        ToolApplyButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TagCatalog.IndoorObject indoorObject = IndoorHelperController.this.toolboxView.getSelectedObject();
            ArrayList<Tag> tags = new ArrayList<Tag>();
            if (!IndoorHelperController.this.toolboxView.getLevelCheckBoxStatus() && !IndoorHelperController.this.levelValue.equals("")) {
                tags.add(new Tag("level", IndoorHelperController.this.levelValue));
            }
            if (!IndoorHelperController.this.toolboxView.getLevelNameText().isEmpty() && !IndoorHelperController.this.toolboxView.getLevelCheckBoxStatus()) {
                tags.add(new Tag("level_name", IndoorHelperController.this.toolboxView.getLevelNameText()));
            }
            if (!IndoorHelperController.this.toolboxView.getNameText().isEmpty()) {
                tags.add(new Tag("name", IndoorHelperController.this.toolboxView.getNameText()));
            }
            if (!IndoorHelperController.this.toolboxView.getRefText().isEmpty()) {
                tags.add(new Tag("ref", IndoorHelperController.this.toolboxView.getRefText()));
            }
            if (!IndoorHelperController.this.toolboxView.getRepeatOnText().isEmpty()) {
                tags.add(new Tag("repeat_on", IndoorHelperController.this.toolboxView.getRepeatOnText()));
            }
            if (!IndoorHelperController.this.toolboxView.getLevelNameText().isEmpty() && !IndoorHelperController.this.toolboxView.getLevelCheckBoxStatus()) {
                tags.add(new Tag("level_name", IndoorHelperController.this.toolboxView.getLevelNameText()));
            }
            IndoorHelperController.this.model.addTagsToOSM(indoorObject, tags);
            IndoorHelperController.this.toolboxView.resetUiElements();
            ValidateAction validateAction = new ValidateAction();
            validateAction.doValidate(true);
            IndoorHelperController.this.refreshPresets();
        }
    }
}

