/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.eventbus;

import java.awt.event.KeyEvent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExpertModeChangedEvent;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.data.CommandQueueEvent;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.SoMChangedEvent;
import org.openstreetmap.josm.data.SystemOfMeasurement;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.conflict.ConflictsAddedEvent;
import org.openstreetmap.josm.data.conflict.ConflictsRemovedEvent;
import org.openstreetmap.josm.data.conflict.IConflictListener;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.data.osm.ChangesetCacheListener;
import org.openstreetmap.josm.data.osm.DataSelectionListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.HighlightUpdateListener;
import org.openstreetmap.josm.data.osm.NoteData;
import org.openstreetmap.josm.data.osm.NoteDataUpdatedEvent;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SelectedNoteChangedEvent;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.osm.history.HistoryClearedEvent;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.data.osm.history.HistoryDataSetListener;
import org.openstreetmap.josm.data.osm.history.HistoryUpdatedEvent;
import org.openstreetmap.josm.data.projection.ProjectionChangeListener;
import org.openstreetmap.josm.data.projection.ProjectionChangedEvent;
import org.openstreetmap.josm.eventbus.JosmEventBus;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapFrameInitializedEvent;
import org.openstreetmap.josm.gui.MapModeChangeEvent;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.ZoomChangedEvent;
import org.openstreetmap.josm.gui.conflict.tags.MultiValueCellEditor;
import org.openstreetmap.josm.gui.conflict.tags.NextDecisionEvent;
import org.openstreetmap.josm.gui.conflict.tags.PreviousDecisionEvent;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListRefreshedEvent;
import org.openstreetmap.josm.gui.dialogs.LayerVisibleEvent;
import org.openstreetmap.josm.gui.dialogs.relation.IMemberModelListener;
import org.openstreetmap.josm.gui.dialogs.relation.MemberVisibleEvent;
import org.openstreetmap.josm.gui.layer.AbstractTileSourceLayer;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.LayerStateChangeEvent;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.NoteLayer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.imagery.FilterChangedEvent;
import org.openstreetmap.josm.gui.layer.imagery.ImageryFilterSettings;
import org.openstreetmap.josm.gui.layer.imagery.TileSourceDisplaySettings;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyleEntryUpdatedEvent;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.MapPaintStylesUpdatedEvent;
import org.openstreetmap.josm.gui.preferences.imagery.AddImageryPanel;
import org.openstreetmap.josm.gui.preferences.imagery.ContentValidationEvent;
import org.openstreetmap.josm.gui.preferences.server.ProxyPreference;
import org.openstreetmap.josm.gui.preferences.server.ProxyPreferenceChangedEvent;
import org.openstreetmap.josm.gui.preferences.server.ProxyPreferenceListener;
import org.openstreetmap.josm.gui.progress.OperationCancelledEvent;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetListener;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetModifiedEvent;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.gui.util.KeyPressReleaseListener;
import org.openstreetmap.josm.gui.util.KeyPressedEvent;
import org.openstreetmap.josm.gui.util.KeyReleasedEvent;
import org.openstreetmap.josm.gui.util.ModifierExChangedEvent;
import org.openstreetmap.josm.gui.util.ModifierExListener;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiInitializedEvent;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.PreferenceChangedListener;
import org.openstreetmap.josm.tools.Logging;

public class EventBusPlugin
extends Plugin {
    private final MainLayerManager.ActiveLayerChangeListener activeLayerChangeListener = e -> JosmEventBus.post(e);
    private final ChangesetCacheListener changesetCacheListener = e -> JosmEventBus.post(e);
    private final DataSelectionListener selectionListener = e -> JosmEventBus.post(e);
    private final ExpertToggleAction.ExpertModeChangeListener expertModeChangeListener = x -> JosmEventBus.post(new ExpertModeChangedEvent((Object)this, x));
    private final GpxData.GpxDataChangeListener gpxChangeListener = e -> JosmEventBus.post(e);
    private final GpxTrack.GpxTrackChangeListener gpxTrackChangeListener = e -> JosmEventBus.post(e);
    private final HighlightUpdateListener highlightUpdateListener = e -> JosmEventBus.post(e);
    private final SelectionChangedListener selectionChangedListener = e -> JosmEventBus.post(e);
    private final PreferenceChangedListener preferenceChangedListener = e -> JosmEventBus.post(e);
    private final MapViewPaintable.PaintableInvalidationListener paintableInvalidationListener = e -> JosmEventBus.post(e);
    private final NoteData.NoteDataUpdateListener noteDataUpdateListener = new NoteData.NoteDataUpdateListener(){

        public void selectedNoteChanged(NoteData noteData) {
            JosmEventBus.post(new SelectedNoteChangedEvent(this, noteData));
        }

        public void noteDataUpdated(NoteData data) {
            JosmEventBus.post(new NoteDataUpdatedEvent(this, data));
        }
    };
    private final IConflictListener conflictsListener = new IConflictListener(){

        public void onConflictsRemoved(ConflictCollection conflicts) {
            JosmEventBus.post(new ConflictsRemovedEvent(this, conflicts));
        }

        public void onConflictsAdded(ConflictCollection conflicts) {
            JosmEventBus.post(new ConflictsAddedEvent(this, conflicts));
        }
    };
    private final ImageryFilterSettings.FilterChangeListener filterChangeListener = () -> JosmEventBus.post(new FilterChangedEvent((Object)this));
    private final TileSourceDisplaySettings.DisplaySettingsChangeListener displaySettingsChangeListener = e -> JosmEventBus.post(e);
    private final OsmDataLayer.LayerStateChangeListener layerStateChangeListener = (layer, newValue) -> JosmEventBus.post(new LayerStateChangeEvent((Object)this, layer, newValue));
    private final MainLayerManager.LayerAvailabilityListener layerAvailabilityListener = new MainLayerManager.LayerAvailabilityListener(){

        public void beforeFirstLayerAdded(MainLayerManager.LayerAvailabilityEvent e) {
            JosmEventBus.post(e);
        }

        public void afterLastLayerRemoved(MainLayerManager.LayerAvailabilityEvent e) {
            JosmEventBus.post(e);
        }
    };
    private final LayerManager.LayerChangeListener layerChangeListener = new LayerManager.LayerChangeListener(){

        public void layerAdded(LayerManager.LayerAddEvent e) {
            JosmEventBus.post(e);
            Layer layer = e.getAddedLayer();
            layer.addInvalidationListener(EventBusPlugin.this.paintableInvalidationListener);
            if (layer instanceof OsmDataLayer) {
                ((OsmDataLayer)layer).addLayerStateChangeListener(EventBusPlugin.this.layerStateChangeListener);
                DataSet ds = ((OsmDataLayer)layer).data;
                ds.addDataSetListener(EventBusPlugin.this.dataSetListener);
                ds.addHighlightUpdateListener(EventBusPlugin.this.highlightUpdateListener);
                ds.addSelectionListener(EventBusPlugin.this.selectionListener);
                ds.getConflicts().addConflictListener(EventBusPlugin.this.conflictsListener);
            } else if (layer instanceof GpxLayer) {
                GpxData gpx = ((GpxLayer)layer).data;
                gpx.addChangeListener(EventBusPlugin.this.gpxChangeListener);
                Logging.debug((String)("TODO: add" + EventBusPlugin.this.gpxTrackChangeListener));
            } else if (layer instanceof NoteLayer) {
                NoteData notes = ((NoteLayer)layer).getNoteData();
                notes.addNoteDataUpdateListener(EventBusPlugin.this.noteDataUpdateListener);
            } else if (layer instanceof ImageryLayer) {
                ((ImageryLayer)layer).getFilterSettings().addFilterChangeListener(EventBusPlugin.this.filterChangeListener);
                if (layer instanceof AbstractTileSourceLayer) {
                    ((AbstractTileSourceLayer)layer).getDisplaySettings().addSettingsChangeListener(EventBusPlugin.this.displaySettingsChangeListener);
                }
            }
        }

        public void layerRemoving(LayerManager.LayerRemoveEvent e) {
            JosmEventBus.post(e);
            Layer layer = e.getRemovedLayer();
            layer.removeInvalidationListener(EventBusPlugin.this.paintableInvalidationListener);
            if (layer instanceof OsmDataLayer) {
                ((OsmDataLayer)layer).removeLayerStateChangeListener(EventBusPlugin.this.layerStateChangeListener);
                DataSet ds = ((OsmDataLayer)layer).data;
                ds.removeDataSetListener(EventBusPlugin.this.dataSetListener);
                ds.removeHighlightUpdateListener(EventBusPlugin.this.highlightUpdateListener);
                ds.removeSelectionListener(EventBusPlugin.this.selectionListener);
                ds.getConflicts().removeConflictListener(EventBusPlugin.this.conflictsListener);
                Logging.debug((String)("TODO: remove" + EventBusPlugin.this.gpxTrackChangeListener));
            } else if (layer instanceof GpxLayer) {
                GpxData gpx = ((GpxLayer)layer).data;
                gpx.removeChangeListener(EventBusPlugin.this.gpxChangeListener);
            } else if (layer instanceof NoteLayer) {
                NoteData notes = ((NoteLayer)layer).getNoteData();
                notes.removeNoteDataUpdateListener(EventBusPlugin.this.noteDataUpdateListener);
            } else if (layer instanceof ImageryLayer) {
                ((ImageryLayer)layer).getFilterSettings().removeFilterChangeListener(EventBusPlugin.this.filterChangeListener);
                if (layer instanceof AbstractTileSourceLayer) {
                    ((AbstractTileSourceLayer)layer).getDisplaySettings().removeSettingsChangeListener(EventBusPlugin.this.displaySettingsChangeListener);
                }
            }
        }

        public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
            JosmEventBus.post(e);
        }
    };
    private final DataSetListener dataSetListener = new DataSetListener(){

        public void wayNodesChanged(WayNodesChangedEvent event) {
            JosmEventBus.post(event);
        }

        public void tagsChanged(TagsChangedEvent event) {
            JosmEventBus.post(event);
        }

        public void relationMembersChanged(RelationMembersChangedEvent event) {
            JosmEventBus.post(event);
        }

        public void primitivesRemoved(PrimitivesRemovedEvent event) {
            JosmEventBus.post(event);
        }

        public void primitivesAdded(PrimitivesAddedEvent event) {
            JosmEventBus.post(event);
        }

        public void otherDatasetChange(AbstractDatasetChangedEvent event) {
            JosmEventBus.post(event);
        }

        public void nodeMoved(NodeMovedEvent event) {
            JosmEventBus.post(event);
        }

        public void dataChanged(DataChangedEvent event) {
            JosmEventBus.post(event);
        }
    };
    private final HistoryDataSetListener historyDataSetListener = new HistoryDataSetListener(){

        public void historyUpdated(HistoryDataSet source, PrimitiveId id) {
            JosmEventBus.post(new HistoryUpdatedEvent(this, source, id));
        }

        public void historyDataSetCleared(HistoryDataSet source) {
            JosmEventBus.post(new HistoryClearedEvent(this, source));
        }
    };
    private final ProjectionChangeListener projectionChangeListener = (oldValue, newValue) -> JosmEventBus.post(new ProjectionChangedEvent((Object)this, oldValue, newValue));
    private final SystemOfMeasurement.SoMChangeListener soMChangeListener = (oldSoM, newSoM) -> JosmEventBus.post(new SoMChangedEvent((Object)this, oldSoM, newSoM));
    private final UndoRedoHandler.CommandQueueListener commandQueueListener = (queueSize, redoSize) -> JosmEventBus.post(new CommandQueueEvent((Object)this, queueSize, redoSize));
    private final MultiValueCellEditor.NavigationListener navigationListener = new MultiValueCellEditor.NavigationListener(){

        public void gotoNextDecision() {
            JosmEventBus.post(new NextDecisionEvent(this));
        }

        public void gotoPreviousDecision() {
            JosmEventBus.post(new PreviousDecisionEvent(this));
        }
    };
    private final LayerListDialog.LayerListModelListener layerListModelListener = new LayerListDialog.LayerListModelListener(){

        public void makeVisible(int index, Layer layer) {
            JosmEventBus.post(new LayerVisibleEvent(this, index, layer));
        }

        public void refresh() {
            JosmEventBus.post(new LayerListRefreshedEvent(this));
        }
    };
    private final IMemberModelListener memberModelListener = index -> JosmEventBus.post(new MemberVisibleEvent((Object)this, index));
    private final AddImageryPanel.ContentValidationListener contentValidationListener = isValid -> JosmEventBus.post(new ContentValidationEvent((Object)this, isValid));
    private final ProxyPreferenceListener proxyPreferenceListener = () -> JosmEventBus.post(new ProxyPreferenceChangedEvent((Object)this));
    private final ProgressMonitor.CancelListener cancelListener = () -> JosmEventBus.post(new OperationCancelledEvent((Object)this));
    private final TaggingPresetListener taggingPresetListener = () -> JosmEventBus.post(new TaggingPresetModifiedEvent((Object)this));
    private final MapPaintStyles.MapPaintSylesUpdateListener mapPaintSylesUpdateListener = new MapPaintStyles.MapPaintSylesUpdateListener(){

        public void mapPaintStylesUpdated() {
            JosmEventBus.post(new MapPaintStylesUpdatedEvent(this));
        }

        public void mapPaintStyleEntryUpdated(int index) {
            JosmEventBus.post(new MapPaintStyleEntryUpdatedEvent(this, index));
        }
    };
    private final OsmApi.OsmApiInitializationListener osmApiInitializationListener = api -> JosmEventBus.post(new OsmApiInitializedEvent((Object)this, api));
    private final NavigatableComponent.ZoomChangeListener zoomChangeListener = () -> JosmEventBus.post(new ZoomChangedEvent((Object)this));
    private final MapFrame.MapModeChangeListener mapModeChangeListener = (oldMode, newMode) -> JosmEventBus.post(new MapModeChangeEvent((Object)this, oldMode, newMode));
    private final ModifierExListener modifierExListener = modifiers -> JosmEventBus.post(new ModifierExChangedEvent((Object)this, modifiers));
    private final KeyPressReleaseListener keyPressReleaseListener = new KeyPressReleaseListener(){

        public void doKeyPressed(KeyEvent e) {
            JosmEventBus.post(new KeyPressedEvent(this, e));
        }

        public void doKeyReleased(KeyEvent e) {
            JosmEventBus.post(new KeyReleasedEvent(this, e));
        }
    };

    public EventBusPlugin(PluginInformation info) {
        super(info);
        this.registerAllJosmListeners();
        Logging.debug((String)("TODO: add" + this.navigationListener));
        Logging.debug((String)("TODO: add" + this.memberModelListener));
        Logging.debug((String)("TODO: add" + this.contentValidationListener));
        Logging.debug((String)("TODO: add" + this.cancelListener));
    }

    void registerAllJosmListeners() {
        Main.addProjectionChangeListener((ProjectionChangeListener)this.projectionChangeListener);
        MainApplication.getLayerManager().addLayerChangeListener(this.layerChangeListener);
        MainApplication.getLayerManager().addActiveLayerChangeListener(this.activeLayerChangeListener);
        MainApplication.getLayerManager().addLayerAvailabilityListener(this.layerAvailabilityListener);
        MainApplication.undoRedo.addCommandQueueListener(this.commandQueueListener);
        ChangesetCache.getInstance().addChangesetCacheListener(this.changesetCacheListener);
        DataSet.addSelectionListener((SelectionChangedListener)this.selectionChangedListener);
        ExpertToggleAction.addExpertModeChangeListener((ExpertToggleAction.ExpertModeChangeListener)this.expertModeChangeListener);
        HistoryDataSet.getInstance().addHistoryDataSetListener(this.historyDataSetListener);
        SystemOfMeasurement.addSoMChangeListener((SystemOfMeasurement.SoMChangeListener)this.soMChangeListener);
        MapPaintStyles.addMapPaintSylesUpdateListener((MapPaintStyles.MapPaintSylesUpdateListener)this.mapPaintSylesUpdateListener);
        ProxyPreference.addProxyPreferenceListener((ProxyPreferenceListener)this.proxyPreferenceListener);
        MapFrame.addMapModeChangeListener((MapFrame.MapModeChangeListener)this.mapModeChangeListener);
        NavigatableComponent.addZoomChangeListener((NavigatableComponent.ZoomChangeListener)this.zoomChangeListener);
        TaggingPresets.addListener((TaggingPresetListener)this.taggingPresetListener);
        OsmApi.addOsmApiInitializationListener((OsmApi.OsmApiInitializationListener)this.osmApiInitializationListener);
        Config.getPref().addPreferenceChangeListener(this.preferenceChangedListener);
    }

    void unregisterAllJosmListeners() {
        Main.removeProjectionChangeListener((ProjectionChangeListener)this.projectionChangeListener);
        MainApplication.getLayerManager().removeLayerChangeListener(this.layerChangeListener);
        MainApplication.getLayerManager().removeActiveLayerChangeListener(this.activeLayerChangeListener);
        MainApplication.getLayerManager().removeLayerAvailabilityListener(this.layerAvailabilityListener);
        MainApplication.undoRedo.removeCommandQueueListener(this.commandQueueListener);
        ChangesetCache.getInstance().removeChangesetCacheListener(this.changesetCacheListener);
        DataSet.removeSelectionListener((SelectionChangedListener)this.selectionChangedListener);
        ExpertToggleAction.removeExpertModeChangeListener((ExpertToggleAction.ExpertModeChangeListener)this.expertModeChangeListener);
        HistoryDataSet.getInstance().removeHistoryDataSetListener(this.historyDataSetListener);
        SystemOfMeasurement.removeSoMChangeListener((SystemOfMeasurement.SoMChangeListener)this.soMChangeListener);
        MapPaintStyles.removeMapPaintSylesUpdateListener((MapPaintStyles.MapPaintSylesUpdateListener)this.mapPaintSylesUpdateListener);
        ProxyPreference.removeProxyPreferenceListener((ProxyPreferenceListener)this.proxyPreferenceListener);
        MapFrame.removeMapModeChangeListener((MapFrame.MapModeChangeListener)this.mapModeChangeListener);
        NavigatableComponent.removeZoomChangeListener((NavigatableComponent.ZoomChangeListener)this.zoomChangeListener);
        TaggingPresets.removeListener((TaggingPresetListener)this.taggingPresetListener);
        OsmApi.removeOsmApiInitializationListener((OsmApi.OsmApiInitializationListener)this.osmApiInitializationListener);
        Config.getPref().removePreferenceChangeListener(this.preferenceChangedListener);
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        LayerListDialog dlg;
        JosmEventBus.post(new MapFrameInitializedEvent((Object)this, oldFrame, newFrame));
        if (newFrame != null) {
            dlg = (LayerListDialog)newFrame.getToggleDialog(LayerListDialog.class);
            if (dlg != null) {
                dlg.getModel().addLayerListModelListener(this.layerListModelListener);
            }
            newFrame.keyDetector.addKeyListener(this.keyPressReleaseListener);
            newFrame.keyDetector.addModifierExListener(this.modifierExListener);
        }
        if (oldFrame != null) {
            dlg = (LayerListDialog)oldFrame.getToggleDialog(LayerListDialog.class);
            if (dlg != null) {
                dlg.getModel().removeLayerListModelListener(this.layerListModelListener);
            }
            oldFrame.keyDetector.removeKeyListener(this.keyPressReleaseListener);
            oldFrame.keyDetector.removeModifierExListener(this.modifierExListener);
        }
    }
}

