/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fr.cadastre.wms;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.plugins.fr.cadastre.CadastrePlugin;
import org.openstreetmap.josm.plugins.fr.cadastre.actions.MenuActionCancelGrab;
import org.openstreetmap.josm.plugins.fr.cadastre.actions.MenuActionLoadFromCache;
import org.openstreetmap.josm.plugins.fr.cadastre.actions.MenuActionRefineGeoRef;
import org.openstreetmap.josm.plugins.fr.cadastre.actions.MenuActionSaveRasterAs;
import org.openstreetmap.josm.plugins.fr.cadastre.actions.mapmode.WMSAdjustAction;
import org.openstreetmap.josm.plugins.fr.cadastre.preferences.CadastrePreferenceSetting;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.CadastreGrabber;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.EastNorthBound;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.GeorefImage;
import org.openstreetmap.josm.plugins.fr.cadastre.wms.GrabThread;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class WMSLayer
extends Layer
implements ImageObserver {
    private int lambertZone = -1;
    public CadastreGrabber grabber = new CadastreGrabber();
    protected static final Icon icon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(CadastrePlugin.class.getResource("/images/cadastre_small.png")));
    private Vector<GeorefImage> images = new Vector();
    public Lock imagesLock = new ReentrantLock();
    protected final int serializeFormatVersion = 4;
    public static int currentFormat;
    private ArrayList<EastNorthBound> dividedBbox = new ArrayList();
    private String location = "";
    private String departement = "";
    private String codeCommune = "";
    public EastNorthBound communeBBox = new EastNorthBound(new EastNorth(0.0, 0.0), new EastNorth(0.0, 0.0));
    private boolean isRaster;
    private boolean isAlreadyGeoreferenced;
    public double X0;
    public double Y0;
    public double angle;
    public double fX;
    public double fY;
    private EastNorth rasterMin;
    private EastNorth rasterMax;
    private double rasterRatio;
    public double deltaEast;
    public double deltaNorth;
    private Action saveAsPng;
    private Action cancelGrab;
    private Action refineGeoRef;
    public boolean adjustModeEnabled;
    public GrabThread grabThread;

    public WMSLayer() {
        this(I18n.tr((String)"Blank Layer", (Object[])new Object[0]), "", -1);
    }

    public WMSLayer(String location, String codeCommune, int lambertZone) {
        super(WMSLayer.buildName(location, codeCommune));
        this.location = location;
        this.codeCommune = codeCommune;
        this.lambertZone = lambertZone;
        this.grabThread = new GrabThread(this);
        this.grabThread.start();
        CadastrePlugin.pluginUsed = true;
    }

    public void destroy() {
        if (this.grabThread != null) {
            this.grabThread.cancel();
        }
        this.grabThread = null;
        super.destroy();
        this.images = null;
        this.dividedBbox = null;
        Logging.info((String)("Layer " + this.location + " destroyed"));
    }

    private static String buildName(String location, String codeCommune) {
        String ret = location.toUpperCase(Locale.FRANCE);
        if (codeCommune != null && !codeCommune.isEmpty()) {
            ret = ret + "(" + codeCommune + ")";
        }
        return ret;
    }

    private String rebuildName() {
        return WMSLayer.buildName(this.location.toUpperCase(Locale.FRANCE), this.codeCommune);
    }

    public void grab(Bounds b) throws IOException {
        this.grabThread.setCanceled(false);
        this.grabThread.setGrabber(this.grabber);
        if (MainApplication.getLayerManager().getLayers().size() == 1) {
            Bounds bounds = this.getCommuneBBox().toBounds();
            GuiHelper.runInEDTAndWait(() -> MainApplication.getMap().mapView.zoomTo(bounds));
            this.divideBbox(bounds, 1);
        } else if (this.isRaster) {
            this.divideBbox(new Bounds(Main.getProjection().eastNorth2latlon(this.rasterMin), Main.getProjection().eastNorth2latlon(this.rasterMax)), Integer.parseInt(Main.pref.get("cadastrewms.rasterDivider", "7")));
        } else {
            this.divideBbox(b, Integer.parseInt(Main.pref.get("cadastrewms.scale", CadastrePreferenceSetting.DEFAULT_GRAB_MULTIPLIER)));
        }
        this.grabThread.addImages(this.dividedBbox);
    }

    private void divideBbox(Bounds b, int factor) {
        EastNorth lambertMin = Main.getProjection().latlon2eastNorth(b.getMin());
        EastNorth lambertMax = Main.getProjection().latlon2eastNorth(b.getMax());
        double minEast = lambertMin.east() + this.deltaEast;
        double minNorth = lambertMin.north() + this.deltaNorth;
        double dEast = (lambertMax.east() - minEast) / (double)factor;
        double dNorth = (lambertMax.north() - minNorth) / (double)factor;
        this.dividedBbox.clear();
        if (factor < 4 || this.isRaster) {
            for (int xEast = 0; xEast < factor; ++xEast) {
                for (int xNorth = 0; xNorth < factor; ++xNorth) {
                    this.dividedBbox.add(new EastNorthBound(new EastNorth(minEast + (double)xEast * dEast, minNorth + (double)xNorth * dNorth), new EastNorth(minEast + (double)(xEast + 1) * dEast, minNorth + (double)(xNorth + 1) * dNorth)));
                }
            }
        } else {
            int c = Integer.parseInt(Main.pref.get("cadastrewms.squareSize", String.valueOf(100)));
            lambertMin = lambertMin.add(-minEast % (double)c, -minNorth % (double)c);
            lambertMax = lambertMax.add((double)c - lambertMax.east() % (double)c, (double)c - lambertMax.north() % (double)c);
            EastNorth mid = lambertMax.getCenter(lambertMin);
            mid = mid.add(-1.0, 1.0);
            mid = mid.add(-mid.east() % (double)c, -mid.north() % (double)c);
            int x = (int)(lambertMax.east() - lambertMin.east()) / c;
            int y = (int)(lambertMax.north() - lambertMin.north()) / c;
            int[] dx = new int[]{1, 0, -1, 0};
            int[] dy = new int[]{0, -1, 0, 1};
            int currDir = -1;
            int lDir = 1;
            int i = 1;
            int j = 0;
            int k = -1;
            if (x == 1) {
                currDir = 0;
            }
            this.dividedBbox.add(new EastNorthBound(mid, new EastNorth(mid.east() + (double)c, mid.north() + (double)c)));
            while (i < x * y) {
                ++i;
                if (++j >= lDir) {
                    if (++k > 1) {
                        ++lDir;
                        k = 0;
                    }
                    j = 0;
                    currDir = (currDir + 1) % 4;
                } else if (currDir >= 0 && j >= (currDir == 0 || currDir == 2 ? x - 1 : y - 1)) {
                    if (++k > 1) {
                        ++lDir;
                        k = 0;
                    }
                    j = lDir - 1;
                    currDir = (currDir + 1) % 4;
                    mid = new EastNorth(mid.east() + (double)(dx[currDir] * c * (lDir - 1)), mid.north() + (double)(dy[currDir] * c * (lDir - 1)));
                }
                mid = new EastNorth(mid.east() + (double)(dx[currDir] * c), mid.north() + (double)(dy[currDir] * c));
                this.dividedBbox.add(new EastNorthBound(mid, new EastNorth(mid.east() + (double)c, mid.north() + (double)c)));
            }
        }
    }

    public Icon getIcon() {
        return icon;
    }

    public String getToolTipText() {
        String str = I18n.tr((String)"WMS layer ({0}), {1} tile(s) loaded", (Object[])new Object[]{this.getName(), this.images.size()});
        if (this.isRaster) {
            str = str + "\n" + I18n.tr((String)"Is not vectorized.", (Object[])new Object[0]);
            str = str + "\n" + I18n.tr((String)"Bounding box: {0}", (Object[])new Object[]{this.communeBBox});
            if (!this.images.isEmpty()) {
                str = str + "\n" + I18n.tr((String)"Image size (px): {0}/{1}", (Object[])new Object[]{this.images.get((int)0).image.getWidth(), this.images.get((int)0).image.getHeight()});
            }
        } else {
            str = str + "\n" + I18n.tr((String)"Is vectorized.", (Object[])new Object[0]);
            str = str + "\n" + I18n.tr((String)"Commune bbox: {0}", (Object[])new Object[]{this.communeBBox});
        }
        return str;
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
        WMSLayer wMSLayer = this;
        synchronized (wMSLayer) {
            String interpolation;
            Object savedInterpolation = g.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
            if (savedInterpolation == null) {
                savedInterpolation = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
            }
            if ((interpolation = Main.pref.get("cadastrewms.imageInterpolation", "standard")).equals("bilinear")) {
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            } else if (interpolation.equals("bicubic")) {
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            } else {
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            }
            this.imagesLock.lock();
            for (GeorefImage img : this.images) {
                img.paint(g, (NavigatableComponent)mv, CadastrePlugin.backgroundTransparent, CadastrePlugin.transparency, CadastrePlugin.drawBoundaries);
            }
            this.imagesLock.unlock();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, savedInterpolation);
        }
        if (this.isRaster) {
            this.paintCrosspieces(g, mv);
        }
        this.grabThread.paintBoxesToGrab(g, mv);
        if (this.adjustModeEnabled) {
            WMSAdjustAction.paintAdjustFrames(g, mv);
        }
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
        for (GeorefImage img : this.images) {
            v.visit(img.min);
            v.visit(img.max);
        }
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public Action[] getMenuEntries() {
        this.saveAsPng = new MenuActionSaveRasterAs(this);
        this.saveAsPng.setEnabled(this.isRaster);
        this.cancelGrab = new MenuActionCancelGrab(this);
        this.cancelGrab.setEnabled(!this.isRaster && this.grabThread.getImagesToGrabSize() > 0);
        this.refineGeoRef = new MenuActionRefineGeoRef(this);
        this.refineGeoRef.setEnabled(this.isRaster && this.grabThread.getImagesToGrabSize() == 0);
        ResetOffsetActionMenu resetOffset = new ResetOffsetActionMenu();
        resetOffset.setEnabled(!this.isRaster && !this.images.isEmpty() && (this.deltaEast != 0.0 || this.deltaNorth != 0.0));
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), new MenuActionLoadFromCache(), this.saveAsPng, this.cancelGrab, this.refineGeoRef, resetOffset, new LayerListPopup.InfoAction((Layer)this)};
    }

    public GeorefImage findImage(EastNorth eastNorth) {
        for (int i = this.images.size() - 1; i >= 0; --i) {
            if (!this.images.get(i).contains(eastNorth)) continue;
            return this.images.get(i);
        }
        return null;
    }

    public boolean isOverlapping(Bounds bounds) {
        GeorefImage georefImage = new GeorefImage(null, Main.getProjection().latlon2eastNorth(bounds.getMin()), Main.getProjection().latlon2eastNorth(bounds.getMax()), this);
        for (GeorefImage img : this.images) {
            if (!img.overlap(georefImage)) continue;
            return true;
        }
        return false;
    }

    public String eastNorth2raster(EastNorth min, EastNorth max) {
        double minX = (min.east() - this.rasterMin.east()) / this.rasterRatio;
        double minY = (min.north() - this.rasterMin.north()) / this.rasterRatio;
        double maxX = (max.east() - this.rasterMin.east()) / this.rasterRatio;
        double maxY = (max.north() - this.rasterMin.north()) / this.rasterRatio;
        return minX + "," + minY + "," + maxX + "," + maxY;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
        this.setName(this.rebuildName());
    }

    public String getDepartement() {
        return this.departement;
    }

    public void setDepartement(String departement) {
        this.departement = departement;
    }

    public String getCodeCommune() {
        return this.codeCommune;
    }

    public void setCodeCommune(String codeCommune) {
        this.codeCommune = codeCommune;
        this.setName(this.rebuildName());
    }

    public boolean isRaster() {
        return this.isRaster;
    }

    public void setRaster(boolean isRaster) {
        this.isRaster = isRaster;
        if (this.saveAsPng != null) {
            this.saveAsPng.setEnabled(isRaster);
        }
    }

    public boolean isAlreadyGeoreferenced() {
        return this.isAlreadyGeoreferenced;
    }

    public void setAlreadyGeoreferenced(boolean isAlreadyGeoreferenced) {
        this.isAlreadyGeoreferenced = isAlreadyGeoreferenced;
    }

    public void setRasterBounds(Bounds bounds) {
        EastNorth rasterCenter = Main.getProjection().latlon2eastNorth(bounds.getCenter());
        EastNorth eaMin = Main.getProjection().latlon2eastNorth(bounds.getMin());
        EastNorth eaMax = Main.getProjection().latlon2eastNorth(bounds.getMax());
        double rasterSizeX = this.communeBBox.max.getX() - this.communeBBox.min.getX();
        double rasterSizeY = this.communeBBox.max.getY() - this.communeBBox.min.getY();
        double ratio = rasterSizeY / rasterSizeX;
        this.rasterMin = new EastNorth(eaMin.getX(), rasterCenter.getY() - (eaMax.getX() - eaMin.getX()) * ratio / 2.0);
        this.rasterMax = new EastNorth(eaMax.getX(), rasterCenter.getY() + (eaMax.getX() - eaMin.getX()) * ratio / 2.0);
        this.rasterRatio = (this.rasterMax.getX() - this.rasterMin.getX()) / rasterSizeX;
    }

    public void write(File associatedFile, ObjectOutputStream oos) throws IOException {
        currentFormat = this.serializeFormatVersion;
        this.setAssociatedFile(associatedFile);
        oos.writeInt(this.serializeFormatVersion);
        oos.writeObject(this.location);
        oos.writeObject(this.codeCommune);
        oos.writeInt(this.lambertZone);
        oos.writeBoolean(this.isRaster);
        oos.writeBoolean(false);
        if (this.isRaster) {
            oos.writeDouble(this.rasterMin.getX());
            oos.writeDouble(this.rasterMin.getY());
            oos.writeDouble(this.rasterMax.getX());
            oos.writeDouble(this.rasterMax.getY());
            oos.writeDouble(this.rasterRatio);
        }
        oos.writeDouble(this.communeBBox.min.getX());
        oos.writeDouble(this.communeBBox.min.getY());
        oos.writeDouble(this.communeBBox.max.getX());
        oos.writeDouble(this.communeBBox.max.getY());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean read(File associatedFile, ObjectInputStream ois, int currentLambertZone) throws IOException, ClassNotFoundException {
        currentFormat = ois.readInt();
        if (currentFormat < 2) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Unsupported cache file version; found {0}, expected {1}\nCreate a new one.", (Object[])new Object[]{currentFormat, this.serializeFormatVersion}), I18n.tr((String)"Cache Format Error", (Object[])new Object[0]), 0);
            return false;
        }
        this.setLocation((String)ois.readObject());
        this.setCodeCommune((String)ois.readObject());
        this.lambertZone = ois.readInt();
        this.setRaster(ois.readBoolean());
        this.setAssociatedFile(associatedFile);
        if (currentFormat >= 4) {
            ois.readBoolean();
        }
        if (this.isRaster) {
            double X = ois.readDouble();
            double Y = ois.readDouble();
            this.rasterMin = new EastNorth(X, Y);
            X = ois.readDouble();
            Y = ois.readDouble();
            this.rasterMax = new EastNorth(X, Y);
            this.rasterRatio = ois.readDouble();
        }
        double minX = ois.readDouble();
        double minY = ois.readDouble();
        double maxX = ois.readDouble();
        double maxY = ois.readDouble();
        this.communeBBox = new EastNorthBound(new EastNorth(minX, minY), new EastNorth(maxX, maxY));
        if (this.lambertZone != currentLambertZone && currentLambertZone != -1) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Lambert zone {0} in cache incompatible with current Lambert zone {1}", (Object[])new Object[]{this.lambertZone + 1, currentLambertZone}), I18n.tr((String)"Cache Lambert Zone Error", (Object[])new Object[0]), 0);
            return false;
        }
        WMSLayer wMSLayer = this;
        synchronized (wMSLayer) {
            boolean EOF = false;
            try {
                while (!EOF) {
                    GeorefImage newImage = (GeorefImage)ois.readObject();
                    for (GeorefImage img : this.images) {
                        if (!CadastrePlugin.backgroundTransparent) continue;
                        if (img.overlap(newImage)) {
                            img.withdraw(newImage);
                            continue;
                        }
                        newImage.withdraw(img);
                    }
                    newImage.wmsLayer = this;
                    this.images.add(newImage);
                }
            }
            catch (EOFException ex) {
                Logging.trace((Throwable)ex);
            }
        }
        Logging.info((String)("Cache loaded for location " + this.location + " with " + this.images.size() + " images"));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinBufferedImages() {
        if (this.images.size() > 1) {
            EastNorth min = this.images.get((int)0).min;
            EastNorth max = this.images.get((int)(this.images.size() - 1)).max;
            int oldImgWidth = this.images.get((int)0).image.getWidth();
            int oldImgHeight = this.images.get((int)0).image.getHeight();
            HashSet<Double> lx = new HashSet<Double>();
            HashSet<Double> ly = new HashSet<Double>();
            for (GeorefImage img : this.images) {
                lx.add(img.min.east());
                ly.add(img.min.north());
            }
            int newWidth = oldImgWidth * lx.size();
            int newHeight = oldImgHeight * ly.size();
            BufferedImage newImg = new BufferedImage(newWidth, newHeight, this.images.get((int)0).image.getType());
            Graphics g = newImg.getGraphics();
            int rasterDivider = (int)Math.sqrt(this.images.size());
            for (int h = 0; h < lx.size(); ++h) {
                for (int v = 0; v < ly.size(); ++v) {
                    int newx = h * oldImgWidth;
                    int newy = newHeight - oldImgHeight - v * oldImgHeight;
                    int j = h * rasterDivider + v;
                    g.drawImage(this.images.get((int)j).image, newx, newy, this);
                }
            }
            WMSLayer wMSLayer = this;
            synchronized (wMSLayer) {
                this.images.clear();
                this.images.add(new GeorefImage(newImg, min, max, this));
            }
        }
    }

    public void cropImage(EastNorth en1, EastNorth en2) {
        EastNorth adj1 = new EastNorth(en1.east() <= en2.east() ? en1.east() : en2.east(), en1.north() <= en2.north() ? en1.north() : en2.north());
        EastNorth adj2 = new EastNorth(en1.east() > en2.east() ? en1.east() : en2.east(), en1.north() > en2.north() ? en1.north() : en2.north());
        this.images.get(0).crop(adj1, adj2);
        this.rasterMin = adj1;
        this.rasterMax = adj2;
        this.setCommuneBBox(new EastNorthBound(new EastNorth(0.0, 0.0), new EastNorth((double)(this.images.get((int)0).image.getWidth() - 1), (double)(this.images.get((int)0).image.getHeight() - 1))));
        this.rasterRatio = (this.rasterMax.getX() - this.rasterMin.getX()) / (this.communeBBox.max.getX() - this.communeBBox.min.getX());
    }

    public EastNorthBound getCommuneBBox() {
        return this.communeBBox;
    }

    public EastNorthBound getFirstViewFromCacheBBox() {
        if (this.isRaster) {
            return this.communeBBox;
        }
        double minX = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double minY = Double.MAX_VALUE;
        double maxY = Double.MIN_VALUE;
        for (GeorefImage image : this.images) {
            minX = image.min.east() < minX ? image.min.east() : minX;
            maxX = image.max.east() > maxX ? image.max.east() : maxX;
            minY = image.min.north() < minY ? image.min.north() : minY;
            maxY = image.max.north() > maxY ? image.max.north() : maxY;
        }
        return new EastNorthBound(new EastNorth(minX, minY), new EastNorth(maxX, maxY));
    }

    public void setCommuneBBox(EastNorthBound entireCommune) {
        this.communeBBox = entireCommune;
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return false;
    }

    public int getLambertZone() {
        return this.lambertZone;
    }

    public EastNorth getRasterCenter() {
        return new EastNorth((this.images.get((int)0).max.east() + this.images.get((int)0).min.east()) / 2.0, (this.images.get((int)0).max.north() + this.images.get((int)0).min.north()) / 2.0);
    }

    public void displace(double dx, double dy) {
        if (this.isRaster) {
            this.rasterMin = new EastNorth(this.rasterMin.east() + dx, this.rasterMin.north() + dy);
            this.rasterMax = new EastNorth(this.rasterMax.east() + dx, this.rasterMax.north() + dy);
            this.images.get(0).shear(dx, dy);
        } else {
            this.deltaEast += dx;
            this.deltaNorth += dy;
        }
    }

    public void resize(EastNorth rasterCenter, double proportion) {
        this.rasterMin = this.rasterMin.interpolate(rasterCenter, proportion);
        this.rasterMax = this.rasterMax.interpolate(rasterCenter, proportion);
        this.images.get(0).scale(rasterCenter, proportion);
    }

    public void rotate(EastNorth rasterCenter, double angle) {
        this.rasterMin = this.rasterMin.rotate(rasterCenter, angle);
        this.rasterMax = this.rasterMax.rotate(rasterCenter, angle);
        this.images.get(0).rotate(rasterCenter, angle);
        this.angle += angle;
    }

    private void paintCrosspieces(Graphics g, MapView mv) {
        String crosspieces = Main.pref.get("cadastrewms.crosspieces", "0");
        if (!crosspieces.equals("0")) {
            int modulo = 25;
            if (crosspieces.equals("2")) {
                modulo = 50;
            }
            if (crosspieces.equals("3")) {
                modulo = 100;
            }
            EastNorthBound currentView = new EastNorthBound(mv.getEastNorth(0, mv.getHeight()), mv.getEastNorth(mv.getWidth(), 0));
            int minX = ((int)currentView.min.east() / modulo + 1) * modulo;
            int minY = ((int)currentView.min.north() / modulo + 1) * modulo;
            int maxX = (int)currentView.max.east() / modulo * modulo;
            int maxY = (int)currentView.max.north() / modulo * modulo;
            int size = (maxX - minX) / modulo;
            if (size < 20) {
                int px = size > 10 ? 2 : Math.abs(12 - size);
                g.setColor(Color.green);
                for (int x = minX; x <= maxX; x += modulo) {
                    for (int y = minY; y <= maxY; y += modulo) {
                        Point p = mv.getPoint(new EastNorth((double)x, (double)y));
                        g.drawLine(p.x - px, p.y, p.x + px, p.y);
                        g.drawLine(p.x, p.y - px, p.x, p.y + px);
                    }
                }
            }
        }
    }

    public GeorefImage getImage(int index) {
        this.imagesLock.lock();
        GeorefImage img = null;
        try {
            img = this.images.get(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Logging.error((Throwable)e);
        }
        this.imagesLock.unlock();
        return img;
    }

    public Vector<GeorefImage> getImages() {
        return this.images;
    }

    public boolean hasImages() {
        return this.images != null && !this.images.isEmpty();
    }

    public void addImage(GeorefImage img) {
        this.imagesLock.lock();
        this.images.add(img);
        this.imagesLock.unlock();
    }

    public void setImages(Vector<GeorefImage> images) {
        this.imagesLock.lock();
        this.images = images;
        this.imagesLock.unlock();
    }

    public void clearImages() {
        this.imagesLock.lock();
        this.images.clear();
        this.imagesLock.unlock();
    }

    class ResetOffsetActionMenu
    extends JosmAction {
        ResetOffsetActionMenu() {
            super(I18n.tr((String)"Reset offset", (Object[])new Object[0]), null, I18n.tr((String)"Reset offset (only vector images)", (Object[])new Object[0]), null, false);
        }

        public void actionPerformed(ActionEvent arg0) {
            WMSLayer.this.deltaEast = 0.0;
            WMSLayer.this.deltaNorth = 0.0;
            WMSLayer.this.invalidate();
        }
    }
}

