/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.hot.sds;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.hot.sds.DetermineSdsModificationsUploadHook;
import org.openstreetmap.hot.sds.ReadPostprocessor;
import org.openstreetmap.hot.sds.SdsMenu;
import org.openstreetmap.hot.sds.SdsOsmWriterFactory;
import org.openstreetmap.hot.sds.SdsPluginPreferences;
import org.openstreetmap.hot.sds.WritePostprocessor;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.UploadAction;
import org.openstreetmap.josm.actions.upload.UploadHook;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.PrimitiveVisitor;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmServerReadPostprocessor;
import org.openstreetmap.josm.io.OsmServerWritePostprocessor;
import org.openstreetmap.josm.io.OsmServerWriter;
import org.openstreetmap.josm.io.OsmWriterFactory;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;

public class SeparateDataStorePlugin
extends Plugin {
    public final Map<Long, IPrimitive> originalNodes = new HashMap<Long, IPrimitive>();
    public final Map<Long, IPrimitive> originalWays = new HashMap<Long, IPrimitive>();
    public final Map<Long, IPrimitive> originalRelations = new HashMap<Long, IPrimitive>();
    public List<QueueItem> uploadQueue = new ArrayList<QueueItem>();
    private PrimitiveVisitor learnVisitor = new PrimitiveVisitor(){

        public void visit(INode i) {
            SeparateDataStorePlugin.this.originalNodes.put(i.getId(), (IPrimitive)i);
        }

        public void visit(IWay i) {
            SeparateDataStorePlugin.this.originalWays.put(i.getId(), (IPrimitive)i);
        }

        public void visit(IRelation i) {
            SeparateDataStorePlugin.this.originalRelations.put(i.getId(), (IPrimitive)i);
        }
    };

    public SeparateDataStorePlugin(PluginInformation info) {
        super(info);
        OsmReader.registerPostprocessor((OsmServerReadPostprocessor)new ReadPostprocessor(this));
        OsmWriterFactory.setDefaultFactory((OsmWriterFactory)new SdsOsmWriterFactory(this));
        UploadAction.registerUploadHook((UploadHook)new DetermineSdsModificationsUploadHook(this));
        OsmServerWriter.registerPostprocessor((OsmServerWritePostprocessor)new WritePostprocessor(this));
        new SdsMenu(this);
    }

    public String getIgnorePrefix() {
        return Main.pref.get("sds-server.tag-prefix", "hot:");
    }

    public IPrimitive getOriginalPrimitive(IPrimitive other) {
        switch (other.getType()) {
            case NODE: {
                return this.originalNodes.get(other.getId());
            }
            case WAY: {
                return this.originalWays.get(other.getId());
            }
            case RELATION: {
                return this.originalRelations.get(other.getId());
            }
        }
        throw new AssertionError((Object)("unexpected case: " + other.getType()));
    }

    protected void enqueueForUpload(IPrimitive prim, HashMap<String, String> tags, boolean onlySds) {
        this.uploadQueue.add(new QueueItem(prim, tags, onlySds));
    }

    protected void learn(IPrimitive prim) {
        if (prim instanceof OsmPrimitive) {
            ((OsmPrimitive)prim).save().accept(this.learnVisitor);
        } else {
            prim.accept(this.learnVisitor);
        }
    }

    protected void clearQueue() {
        ArrayList<QueueItem> newQueue = new ArrayList<QueueItem>();
        for (QueueItem q : this.uploadQueue) {
            if (q.processed) continue;
            newQueue.add(q);
        }
        this.uploadQueue = newQueue;
    }

    protected void resetQueue() {
        for (QueueItem q : this.uploadQueue) {
            q.processed = false;
        }
    }

    public PreferenceSetting getPreferenceSetting() {
        return new SdsPluginPreferences();
    }

    static class QueueItem {
        public final IPrimitive primitive;
        public final Map<String, String> tags;
        public final boolean sdsOnly;
        public boolean processed;

        QueueItem(IPrimitive p, HashMap<String, String> t, boolean s) {
            this.primitive = p;
            this.tags = t;
            this.sdsOnly = s;
            this.processed = false;
        }
    }
}

