/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.hot.sds;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.openstreetmap.hot.sds.SeparateDataStorePlugin;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.io.OsmWriter;
import org.openstreetmap.josm.io.XmlWriter;

public class SdsOsmWriter
extends OsmWriter {
    private SeparateDataStorePlugin plugin;

    public SdsOsmWriter(SeparateDataStorePlugin plugin, PrintWriter out, boolean osmConform, String version) {
        super(out, osmConform, version);
        this.plugin = plugin;
    }

    protected void addTags(Tagged osm, String tagname, boolean tagOpen) {
        if (osm.hasKeys()) {
            if (tagOpen) {
                this.out.println(">");
            }
            ArrayList entries = new ArrayList(osm.getKeys().entrySet());
            Collections.sort(entries, byKeyComparator);
            for (Map.Entry entry : entries) {
                String key = (String)entry.getKey();
                if (!(osm instanceof Changeset) && "created_by".equals(key) || key.startsWith(this.plugin.getIgnorePrefix())) continue;
                this.out.println("    <tag k='" + XmlWriter.encode((String)((String)entry.getKey())) + "' v='" + XmlWriter.encode((String)((String)entry.getValue())) + "' />");
            }
            this.out.println("  </" + tagname + ">");
        } else if (tagOpen) {
            this.out.println(" />");
        } else {
            this.out.println("  </" + tagname + ">");
        }
    }
}

