/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.graphview.core.property;

import org.openstreetmap.josm.plugins.graphview.core.access.AccessParameters;
import org.openstreetmap.josm.plugins.graphview.core.data.DataSource;
import org.openstreetmap.josm.plugins.graphview.core.data.TagGroup;
import org.openstreetmap.josm.plugins.graphview.core.property.RoadPropertyType;
import org.openstreetmap.josm.plugins.graphview.core.property.VehiclePropertyTypes;

public class RoadTracktype
implements RoadPropertyType<Integer> {
    @Override
    public <N, W, R, M> Integer evaluateN(N node, AccessParameters accessParameters, DataSource<N, W, R, M> dataSource) {
        return null;
    }

    @Override
    public <N, W, R, M> Integer evaluateW(W way, boolean forward, AccessParameters accessParameters, DataSource<N, W, R, M> dataSource) {
        assert (way != null && accessParameters != null && dataSource != null);
        TagGroup tags = dataSource.getTagsW(way);
        String tracktypeString = tags.getValue("tracktype");
        if (tracktypeString != null) {
            if ("grade1".equals(tracktypeString)) {
                return 1;
            }
            if ("grade2".equals(tracktypeString)) {
                return 2;
            }
            if ("grade3".equals(tracktypeString)) {
                return 3;
            }
            if ("grade4".equals(tracktypeString)) {
                return 4;
            }
            if ("grade5".equals(tracktypeString)) {
                return 5;
            }
        }
        return null;
    }

    @Override
    public boolean isUsable(Object propertyValue, AccessParameters accessParameters) {
        assert (propertyValue instanceof Integer);
        int tracktype = (Integer)propertyValue;
        Integer maxTracktype = accessParameters.getVehiclePropertyValue(VehiclePropertyTypes.MAX_TRACKTYPE);
        return maxTracktype == null || tracktype <= maxTracktype;
    }
}

