/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.vectorbin;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygonal;
import com.vividsolutions.jts.geom.prep.PreparedGeometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometryFactory;
import it.geosolutions.jaiext.vectorbin.VectorBinarizeOpImage;
import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;

public class VectorBinarizeRIF
implements RenderedImageFactory {
    public RenderedImage create(ParameterBlock paramBlock, RenderingHints renderHints) {
        ImageLayout il;
        int minx = paramBlock.getIntParameter(0);
        int miny = paramBlock.getIntParameter(1);
        int width = paramBlock.getIntParameter(2);
        int height = paramBlock.getIntParameter(3);
        Object obj = paramBlock.getObjectParameter(4);
        PreparedGeometry pg = null;
        if (obj instanceof Polygonal) {
            Geometry g = (Geometry)((Geometry)obj).clone();
            pg = PreparedGeometryFactory.prepare((Geometry)g);
        } else if (obj instanceof PreparedGeometry) {
            pg = (PreparedGeometry)obj;
        } else {
            throw new IllegalArgumentException("The geometry must be a JTS polygon or multipolygon");
        }
        Dimension tileSize = null;
        if (renderHints != null && renderHints.containsKey(JAI.KEY_IMAGE_LAYOUT) && (il = (ImageLayout)renderHints.get(JAI.KEY_IMAGE_LAYOUT)) != null) {
            tileSize = new Dimension(il.getTileWidth(null), il.getTileHeight(null));
        }
        if (tileSize == null) {
            tileSize = JAI.getDefaultTileSize();
        }
        MultiPixelPackedSampleModel sm = new MultiPixelPackedSampleModel(0, tileSize.width, tileSize.height, 1);
        boolean antiAliasing = false;
        Object antiAlias = paramBlock.getObjectParameter(5);
        if (antiAlias != null && antiAlias instanceof Boolean) {
            antiAliasing = (Boolean)antiAlias;
        }
        return new VectorBinarizeOpImage(sm, renderHints, minx, miny, width, height, pg, antiAliasing);
    }
}

