/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.geotools;

import com.sun.media.jai.imageioimpl.ImageReadWriteSpi;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.IIOServiceProvider;
import javax.media.jai.JAI;
import javax.media.jai.OperationRegistry;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.Logging;

public class GeoToolsPlugin
extends Plugin {
    public GeoToolsPlugin(PluginInformation info) {
        super(info);
        this.initJAI();
        this.initGeoTools();
        this.checkEPSG();
    }

    private void initJAI() {
        System.setProperty("com.sun.media.jai.disableMediaLib", "true");
        OperationRegistry registry = JAI.getDefaultInstance().getOperationRegistry();
        if (registry == null) {
            Logging.error((String)"geotools: error in JAI initialization. Cannot access default operation registry");
        } else {
            try {
                new ImageReadWriteSpi().updateRegistry(registry);
            }
            catch (IllegalArgumentException e) {
                Logging.warn((String)("geotools: error in JAI/ImageReadWriteSpi initialization: " + e.getMessage()));
            }
            try (InputStream in = GeoToolsPlugin.class.getResourceAsStream("/META-INF/registryFile.jai");){
                if (in == null) {
                    Logging.error((String)"geotools: error in JAI initialization. Cannot access META-INF/registryFile.jai");
                } else {
                    registry.updateFromStream(in);
                }
            }
            catch (IOException | IllegalArgumentException e) {
                Logging.error((String)("geotools: error in JAI/GeoTools initialization: " + e.getMessage()));
            }
        }
        IIORegistry ioRegistry = IIORegistry.getDefaultInstance();
        ClassLoader loader = GeoToolsPlugin.class.getClassLoader();
        Iterator<Class<?>> categories = ioRegistry.getCategories();
        while (categories.hasNext()) {
            for (IIOServiceProvider provider : ServiceLoader.load(categories.next(), loader)) {
                Logging.debug((String)("Registering " + provider.getClass()));
                ioRegistry.registerServiceProvider(provider);
            }
        }
    }

    private void initGeoTools() {
        System.setProperty("org.geotools.referencing.forceXY", "true");
    }

    private void checkEPSG() {
        try {
            CRS.decode("EPSG:4326");
        }
        catch (NoSuchAuthorityCodeException e) {
            Logging.error((String)("geotools: error in EPSG database initialization. NoSuchAuthorityCodeException: " + e.getMessage()));
        }
        catch (FactoryException e) {
            Logging.error((String)("geotools: error in EPSG database initialization. FactoryException: " + e.getMessage()));
        }
    }
}

