/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function.color;

import java.awt.Color;
import org.geotools.filter.FunctionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.function.color.HSLColor;
import org.opengis.filter.capability.FunctionName;

public abstract class AbstractHSLFunction
extends FunctionImpl {
    public static FunctionName NAME = new FunctionNameImpl("abstractHSL", FunctionNameImpl.parameter("result", Color.class), FunctionNameImpl.parameter("color", Color.class), FunctionNameImpl.parameter("amount", Float.class), FunctionNameImpl.parameter("method", Method.class, 0, 1));

    public AbstractHSLFunction(String name) {
        this.functionName = new FunctionNameImpl(name, NAME.getReturn(), NAME.getArguments());
    }

    @Override
    public Object evaluate(Object object) {
        Color source = (Color)this.getParameterValue(object, 0);
        float amount = ((Float)this.getParameterValue(object, 1)).floatValue();
        Method method = (Method)((Object)this.getParameterValue(object, 2, (Object)Method.absolute));
        HSLColor hsl = new HSLColor(source);
        if (method == Method.absolute) {
            this.adjustAbsolute(amount, hsl);
        } else {
            this.adjstRelative(amount, hsl);
        }
        return hsl.toRGB();
    }

    protected abstract void adjstRelative(float var1, HSLColor var2);

    protected abstract void adjustAbsolute(float var1, HSLColor var2);

    static enum Method {
        absolute,
        relative;

    }
}

