/*
 *    GeoTools - The Open Source Java GIS Toolkit
 *    http://geotools.org
 *
 *    (C) 2011, Open Source Geospatial Foundation (OSGeo)
 *    (C) 2005, Open Geospatial Consortium Inc.
 *    
 *    All Rights Reserved. http://www.opengis.org/legal/
 */
package org.opengis.temporal;

import org.opengis.annotation.UML;

import static org.opengis.annotation.Obligation.*;
import static org.opengis.annotation.Specification.*;


/**
 * Represents a single non-decomposable element of topology and its relationships to other
 * topological primitives within a topological complex.
 *
 * @author Alexander Petkov
 *
 *
 * @source $URL$
 */
@UML(identifier="TM_TopologicalPrimitive", specification=ISO_19108)
public interface TemporalTopologicalPrimitive {
}
