/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.lakewalker;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.openstreetmap.josm.plugins.lakewalker.Configurer;
import org.openstreetmap.josm.tools.I18n;

public class StringEnumConfigurer
extends Configurer {
    protected String[] validValues;
    protected String[] transValues;
    protected JComboBox<String> box;
    protected Box panel;
    protected String tooltipText = "";

    public StringEnumConfigurer(String key, String name, String[] validValues) {
        super(key, name);
        this.validValues = validValues;
        this.transValues = new String[validValues.length];
        for (int i = 0; i < validValues.length; ++i) {
            this.transValues[i] = I18n.tr((String)validValues[i], (Object[])new Object[0]);
        }
    }

    public StringEnumConfigurer(String[] validValues) {
        this((String)null, "", validValues);
    }

    public void setToolTipText(String s) {
        this.tooltipText = s;
    }

    @Override
    public Component getControls() {
        if (this.panel == null) {
            this.panel = Box.createHorizontalBox();
            this.panel.add(new JLabel(this.name));
            this.box = new JComboBox<String>(this.transValues);
            this.box.setToolTipText(this.tooltipText);
            this.box.setMaximumSize(new Dimension(this.box.getMaximumSize().width, this.box.getPreferredSize().height));
            this.setValue(this.value);
            this.box.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StringEnumConfigurer.this.noUpdate = true;
                    StringEnumConfigurer.this.setValue(StringEnumConfigurer.this.box.getSelectedIndex());
                    StringEnumConfigurer.this.noUpdate = false;
                }
            });
            this.panel.add(this.box);
        }
        return this.panel;
    }

    @Override
    public void setValue(Object o) {
        if (o == null) {
            o = 0;
        }
        super.setValue(o);
        if (!this.noUpdate && this.box != null) {
            this.box.setSelectedIndex((Integer)o);
        }
    }

    @Override
    public void setValue(String s) {
        Integer n = 0;
        for (int i = 0; i < this.transValues.length; ++i) {
            if (!this.transValues[i].equals(s) && !this.validValues[i].equals(s)) continue;
            n = i;
            break;
        }
        this.setValue(n);
    }

    @Override
    public String getValueString() {
        return this.validValues[(Integer)this.value];
    }
}

