/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.indoorhelper;

import controller.IndoorHelperController;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;

public class IndoorHelperPlugin
extends Plugin {
    private IndoorHelperController controller;
    String sep = System.getProperty("file.separator");

    public IndoorHelperPlugin(PluginInformation info) throws Exception {
        super(info);
        this.exportValidator("/data/indoorhelper.validator.mapcss");
        this.exportStyleFile("indoor.mapcss");
        this.exportStyleFile("entrance_door_icon.png");
        this.exportStyleFile("entrance_icon.png");
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        super.mapFrameInitialized(oldFrame, newFrame);
        if (oldFrame == null && newFrame != null) {
            this.controller = new IndoorHelperController();
        }
    }

    private void exportValidator(String resourceName) throws Exception {
        FileOutputStream resStreamOut = null;
        try (InputStream stream = null;){
            int readBytes;
            stream = IndoorHelperPlugin.class.getResourceAsStream(resourceName);
            if (stream == null) {
                System.out.println("Validator: stream is null");
                throw new Exception("Cannot get resource \"" + resourceName + "\" from Jar file.");
            }
            byte[] buffer = new byte[4096];
            String valDirPath = Main.pref.getDirs().getUserDataDirectory(false) + this.sep + "validator";
            File valDir = new File(valDirPath);
            valDir.mkdirs();
            String outPath = valDir.getAbsolutePath() + this.sep + "indoorhelper.validator.mapcss";
            System.out.println("Validator:" + outPath);
            resStreamOut = new FileOutputStream(outPath);
            while ((readBytes = stream.read(buffer)) > 0) {
                ((OutputStream)resStreamOut).write(buffer, 0, readBytes);
            }
            ((OutputStream)resStreamOut).close();
        }
    }

    private void exportStyleFile(String resourceName) throws Exception {
        FileOutputStream resStreamOut = null;
        try (InputStream stream = null;){
            int readBytes;
            stream = IndoorHelperPlugin.class.getResourceAsStream("/data/" + resourceName);
            if (stream == null) {
                System.out.println("MapPaint: stream is null");
                throw new Exception("Cannot get resource \"" + resourceName + "\" from Jar file.");
            }
            byte[] buffer = new byte[4096];
            String valDirPath = Main.pref.getDirs().getUserDataDirectory(false) + this.sep + "styles";
            File valDir = new File(valDirPath);
            valDir.mkdirs();
            String outPath = valDir.getAbsolutePath() + this.sep + resourceName;
            System.out.println("MapPaint" + outPath);
            resStreamOut = new FileOutputStream(outPath);
            while ((readBytes = stream.read(buffer)) > 0) {
                ((OutputStream)resStreamOut).write(buffer, 0, readBytes);
            }
            ((OutputStream)resStreamOut).close();
        }
    }
}

