/*
 * Decompiled with CFR 0.152.
 */
package reverter;

import java.util.Collection;
import java.util.Collections;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.gui.widgets.AbstractIdTextField;
import org.openstreetmap.josm.gui.widgets.ChangesetIdTextField;

public class ChangesetIdsTextField
extends AbstractIdTextField<OsmIdsValidator> {
    public ChangesetIdsTextField() {
        super(OsmIdsValidator.class);
    }

    public boolean readIds() {
        return ((OsmIdsValidator)this.validator).readChangesetId();
    }

    public Collection<Integer> getIdsInReverseOrder() {
        return ((OsmIdsValidator)this.validator).ids;
    }

    public static class OsmIdsValidator
    extends ChangesetIdTextField.ChangesetIdValidator {
        private Collection<Integer> ids = new TreeSet(Collections.reverseOrder());

        public OsmIdsValidator(JTextComponent tc) {
            super(tc);
        }

        public boolean readChangesetId() {
            this.ids.clear();
            String value = this.getComponent().getText();
            try {
                StringTokenizer tokenizer = new StringTokenizer(value, ",.+/ \t\n");
                while (tokenizer.hasMoreTokens()) {
                    this.ids.add(Integer.parseInt(tokenizer.nextToken().trim()));
                }
                return true;
            }
            catch (NumberFormatException e) {
                this.ids.clear();
                return false;
            }
        }
    }
}

