/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanes.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.turnlanes.model.Constants;
import org.openstreetmap.josm.plugins.turnlanes.model.Issue;
import org.openstreetmap.josm.plugins.turnlanes.model.Lane;
import org.openstreetmap.josm.plugins.turnlanes.model.Route;
import org.openstreetmap.josm.plugins.turnlanes.model.UnexpectedDataException;
import org.openstreetmap.josm.plugins.turnlanes.model.Utils;
import org.openstreetmap.josm.tools.I18n;

public class Validator {
    public List<Issue> validate(DataSet dataSet) {
        ArrayList<Relation> lenghts = new ArrayList<Relation>();
        ArrayList<Relation> turns = new ArrayList<Relation>();
        for (Relation r : OsmPrimitive.getFilteredList((Collection)dataSet.allPrimitives(), Relation.class)) {
            if (!r.isUsable()) continue;
            String type = r.get("type");
            if ("turnlanes:lengths".equals(type)) {
                lenghts.add(r);
                continue;
            }
            if (!"turnlanes:turns".equals(type)) continue;
            turns.add(r);
        }
        ArrayList<Issue> issues = new ArrayList<Issue>();
        HashMap<IncomingLanes.Key, IncomingLanes> incomingLanes = new HashMap<IncomingLanes.Key, IncomingLanes>();
        issues.addAll(this.validateLengths(lenghts, incomingLanes));
        issues.addAll(this.validateTurns(turns, incomingLanes));
        for (IncomingLanes lanes : incomingLanes.values()) {
            if (lanes.unreferenced() <= 0) continue;
            issues.add(Issue.newWarning(Arrays.asList(lanes.key.junction, lanes.key.from), I18n.tr((String)"{0} lanes are not referenced in any turn-relation.", (Object[])new Object[]{lanes.unreferenced()})));
        }
        return issues;
    }

    private List<Issue> validateLengths(List<Relation> lenghts, Map<IncomingLanes.Key, IncomingLanes> incomingLanes) {
        ArrayList<Issue> issues = new ArrayList<Issue>();
        for (Relation r : lenghts) {
            issues.addAll(this.validateLengths(r, incomingLanes));
        }
        return issues;
    }

    private List<Issue> validateLengths(Relation r, Map<IncomingLanes.Key, IncomingLanes> incomingLanes) {
        ArrayList<Issue> issues = new ArrayList<Issue>();
        try {
            Node end = Utils.getMemberNode(r, "end");
            Route route = this.validateLengthsWays(r, end, issues);
            if (route == null) {
                return issues;
            }
            List<Double> left = Lane.loadLengths(r, "lengths:left", 0.0);
            List<Double> right = Lane.loadLengths(r, "lengths:right", 0.0);
            int tooLong = 0;
            for (Double l : left) {
                if (!(l > route.getLength())) continue;
                ++tooLong;
            }
            for (Double l : right) {
                if (!(l > route.getLength())) continue;
                ++tooLong;
            }
            if (tooLong > 0) {
                issues.add(Issue.newError(r, (OsmPrimitive)end, "The lengths-relation specifies " + tooLong + " extra-lanes which are longer than its ways."));
            }
            this.putIncomingLanes(route, left, right, incomingLanes);
            return issues;
        }
        catch (UnexpectedDataException e) {
            issues.add(Issue.newError(r, e.getMessage()));
            return issues;
        }
    }

    private void putIncomingLanes(Route route, List<Double> left, List<Double> right, Map<IncomingLanes.Key, IncomingLanes> incomingLanes) {
        IncomingLanes lanes;
        Way way;
        Node end = route.getLastSegment().getEnd();
        IncomingLanes.Key key = new IncomingLanes.Key(end, way = route.getLastSegment().getWay());
        IncomingLanes old = incomingLanes.put(key, lanes = new IncomingLanes(key, left.size(), Lane.getRegularCount(way, end), right.size()));
        if (old != null) {
            incomingLanes.put(key, new IncomingLanes(key, Math.max(lanes.extraLeft, old.extraLeft), Math.max(lanes.regular, old.regular), Math.max(lanes.extraRight, old.extraRight)));
        }
    }

    private Route validateLengthsWays(Relation r, Node end, List<Issue> issues) {
        List<Way> ways = Utils.getMemberWays(r, "ways");
        if (ways.isEmpty()) {
            issues.add(Issue.newError(r, "A lengths-relation requires at least one member-way with role \"ways\"."));
            return null;
        }
        Node current = end;
        for (Way w : ways) {
            if (!w.isFirstLastNode(current)) {
                return this.orderWays(r, ways, current, issues, "ways", "lengths");
            }
            current = Utils.getOppositeEnd(w, current);
        }
        return Route.create(ways, end);
    }

    private Route orderWays(final Relation r, List<Way> ways, Node end, List<Issue> issues, String role, String type) {
        ArrayList<Way> unordered = new ArrayList<Way>(ways);
        final ArrayList<Way> ordered = new ArrayList<Way>(ways.size());
        HashSet<Node> ends = new HashSet<Node>();
        Node current = end;
        block0: while (!unordered.isEmpty()) {
            if (!ends.add(current)) {
                issues.add(Issue.newError(r, ways, "The " + role + " of the " + type + "-relation are unordered (and contain cycles)."));
                return null;
            }
            Iterator it = unordered.iterator();
            while (it.hasNext()) {
                Way w = (Way)it.next();
                if (!w.isFirstLastNode(current)) continue;
                it.remove();
                ordered.add(w);
                current = Utils.getOppositeEnd(w, current);
                continue block0;
            }
            issues.add(Issue.newError(r, ways, "The " + role + " of the " + type + "-relation are disconnected."));
            return null;
        }
        Issue.QuickFix quickFix = new Issue.QuickFix(I18n.tr((String)"Put the ways in order.", (Object[])new Object[0])){

            @Override
            public boolean perform() {
                for (int i = r.getMembersCount() - 1; i >= 0; --i) {
                    RelationMember m = r.getMember(i);
                    if (!m.isWay() || !"ways".equals(m.getRole())) continue;
                    r.removeMember(i);
                }
                for (Way w : ordered) {
                    r.addMember(new RelationMember("ways", (OsmPrimitive)w));
                }
                return true;
            }
        };
        issues.add(Issue.newError(r, ways, "The ways of the lengths-relation are unordered.", quickFix));
        return Route.create(ordered, end);
    }

    private List<Issue> validateTurns(List<Relation> turns, Map<IncomingLanes.Key, IncomingLanes> incomingLanes) {
        ArrayList<Issue> issues = new ArrayList<Issue>();
        for (Relation r : turns) {
            issues.addAll(this.validateTurns(r, incomingLanes));
        }
        return issues;
    }

    private List<Issue> validateTurns(Relation r, Map<IncomingLanes.Key, IncomingLanes> incomingLanes) {
        ArrayList<Issue> issues = new ArrayList<Issue>();
        try {
            Node fromJunctionNode;
            Way from = Utils.getMemberWay(r, "from");
            Way to = Utils.getMemberWay(r, "to");
            if (from.firstNode().equals((Object)from.lastNode())) {
                issues.add(Issue.newError(r, (OsmPrimitive)from, "The from-way both starts as well as ends at the via-node."));
            }
            if (to.firstNode().equals((Object)to.lastNode())) {
                issues.add(Issue.newError(r, (OsmPrimitive)to, "The to-way both starts as well as ends at the via-node."));
            }
            if (!issues.isEmpty()) {
                return issues;
            }
            List<RelationMember> viaMembers = Utils.getMembers(r, "via");
            if (viaMembers.isEmpty()) {
                throw UnexpectedDataException.Kind.NO_MEMBER.chuck("via");
            }
            if (viaMembers.get(0).isWay()) {
                List<Way> vias = Utils.getMemberWays(r, "via");
                Node current = fromJunctionNode = Utils.lineUp(from, vias.get(0));
                for (Way via : vias) {
                    if (!via.isFirstLastNode(current)) {
                        this.orderWays(r, vias, current, issues, "via-ways", "turns");
                        break;
                    }
                    current = Utils.getOppositeEnd(via, current);
                }
            } else {
                Node via = Utils.getMemberNode(r, "via");
                if (!from.isFirstLastNode(via)) {
                    issues.add(Issue.newError(r, (OsmPrimitive)from, "The from-way does not start or end at the via-node."));
                }
                if (!to.isFirstLastNode(via)) {
                    issues.add(Issue.newError(r, (OsmPrimitive)to, "The to-way does not start or end at the via-node."));
                }
                fromJunctionNode = via;
            }
            if (!issues.isEmpty()) {
                return issues;
            }
            IncomingLanes lanes = this.get(incomingLanes, fromJunctionNode, from);
            for (int l : this.splitInts(r, "lanes", issues)) {
                if (lanes.existsRegular(l)) continue;
                issues.add(Issue.newError(r, I18n.tr((String)"Relation references non-existent (regular) lane {0}", (Object[])new Object[]{l})));
            }
            for (int l : this.splitInts(r, "lanes:extra", issues)) {
                if (lanes.existsExtra(l)) continue;
                issues.add(Issue.newError(r, I18n.tr((String)"Relation references non-existent extra lane {0}", (Object[])new Object[]{l})));
            }
            return issues;
        }
        catch (UnexpectedDataException e) {
            issues.add(Issue.newError(r, e.getMessage()));
            return issues;
        }
    }

    private List<Integer> splitInts(Relation r, String key, List<Issue> issues) {
        String ints = r.get(key);
        if (ints == null) {
            return Collections.emptyList();
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String s : Constants.SPLIT_PATTERN.split(ints)) {
            try {
                int i = Integer.parseInt(s.trim());
                result.add(i);
            }
            catch (NumberFormatException e) {
                issues.add(Issue.newError(r, I18n.tr((String)"Integer list \"{0}\" contains unexpected values.", (Object[])new Object[]{key})));
            }
        }
        return result;
    }

    private IncomingLanes get(Map<IncomingLanes.Key, IncomingLanes> incomingLanes, Node via, Way from) {
        IncomingLanes.Key key = new IncomingLanes.Key(via, from);
        IncomingLanes lanes = incomingLanes.get(key);
        if (lanes == null) {
            IncomingLanes newLanes = new IncomingLanes(key, 0, Lane.getRegularCount(from, via), 0);
            incomingLanes.put(key, newLanes);
            return newLanes;
        }
        return lanes;
    }

    private static final class IncomingLanes {
        final Key key;
        private final int extraLeft;
        private final int regular;
        private final int extraRight;
        private final BitSet bitset;

        IncomingLanes(Key key, int extraLeft, int regular, int extraRight) {
            this.key = key;
            this.extraLeft = extraLeft;
            this.regular = regular;
            this.extraRight = extraRight;
            this.bitset = new BitSet(extraLeft + regular + extraRight);
        }

        public boolean existsRegular(int l) {
            if (l > 0 && l <= this.regular) {
                this.bitset.set(this.extraLeft + l - 1);
                return true;
            }
            return false;
        }

        public boolean existsExtra(int l) {
            if (l < 0 && Math.abs(l) <= this.extraLeft) {
                this.bitset.set(Math.abs(l) - 1);
                return true;
            }
            if (l > 0 && l <= this.extraRight) {
                this.bitset.set(this.extraLeft + this.regular + l - 1);
                return true;
            }
            return false;
        }

        public int unreferenced() {
            return this.extraLeft + this.regular + this.extraRight - this.bitset.cardinality();
        }

        private static final class Key {
            final Node junction;
            final Way from;

            Key(Node junction, Way from) {
                this.junction = junction;
                this.from = from;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
                result = 31 * result + (this.junction == null ? 0 : this.junction.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Key other = (Key)obj;
                if (this.from == null ? other.from != null : !this.from.equals((Object)other.from)) {
                    return false;
                }
                return !(this.junction == null ? other.junction != null : !this.junction.equals((Object)other.junction));
            }
        }
    }
}

